#ifndef TEXTUREDSMOOTHTRIANGLE_HXX
#define TEXTUREDSMOOTHTRIANGLE_HXX

#include "SmoothTriangle.hxx"

class TexturedSmoothTriangle : public SmoothTriangle
{
	// Vec3f  a, b, c; // vtx positions inherited from Triangle
	// Vec3f na,nb,nc; // vtx normals inherited from SmoothTriangle
	Vec3f ta, tb, tc;  // vertex texture coordinates
public:
	TexturedSmoothTriangle(Vec3f a,  Vec3f b,  Vec3f c,
		Vec3f na, Vec3f nb, Vec3f nc,
		Vec3f ta, Vec3f tb, Vec3f tc,
		Shader *shader)
		: SmoothTriangle(a,b,c,na,nb,nc,shader),ta(ta),tb(tb),tc(tc)
	{};

	// virtual bool Intersect(Ray &ray); // inherited from Triangle
	// virtual Box CalcBounds();         // inherited from Triangle 
	// virtual Vec3f GetNormal(Ray &ray) // inherited from Triangle

	virtual void GetUV(Ray &ray, float &u, float &v)
	{
		// assume u/v coordinates in ray correspond to beta(u) and gamma
		// (v) barycentric coordinates of hitpoint on triangle (have to be
		// stored like this in the intersection code !)
		//    Vec3f normal = ray.u*tb + ray.v*tc + (1-ray.u-ray.v)*ta;
		//    Normalize(normal);
		u = ray.u * tb.x + ray.v * tc.x + (1 - ray.u - ray.v) * ta.x;
		v = ray.u * tb.y + ray.v * tc.y + (1 - ray.u - ray.v) * ta.y;

		v=1 - v;// very important
	};
};

#endif
