#ifndef TEXTUREDEYELIGHTSHADER_HXX
#define TEXTUREDEYELIGHTSHADER_HXX

#include "EyeLightShader.hxx"
#include "Texture.hxx"

class TexturedEyeLightShader : public EyeLightShader
{
public:
  Texture texture;
  
  TexturedEyeLightShader(Scene *scene, Vec3f color=Vec3f(0.5,0.5,0.5), char *fileName = NULL)
    : EyeLightShader(scene, color), texture(fileName)
  {};
  
  // just because of compiler warning
  virtual ~TexturedEyeLightShader()
  {};
  
  virtual Vec3f Shade(Ray &ray)
  {
    /* get texture coordinates from primitive */
    
    float u,v;
    ray.hit->GetUV(ray,u,v);
    
    /* modulate surface color */
    
    return Product(EyeLightShader::Shade(ray),texture.GetTexel(u,v));
  };
};

#endif
