#ifndef STRATIFIEDSAMPLEGENERATOR_HXX
#define STRATIFIEDSAMPLEGENERATOR_HXX

#include "SampleGenerator.hxx"

class StratifiedSampleGenerator : public SampleGenerator 
{
public:
	virtual void GetSamples(int n, float *u, float *v, float *weight)
	{    
		int m = (int)sqrt((float)n);
		if (m*m != n) {
			std::cerr << "stratified sampling only possible with a square number of samples" << std::endl;
			exit(1);
		}

		for (int i=0;i<m;i++) {
			for (int j=0;j<m;j++) {
				u[i*m+j] = (i+(float)drand48())/(float)m;
				v[i*m+j] = (j+(float)drand48())/(float)m;
				weight[i*m+j] = 1.0f/(float)n;
			}
		}
	};
};

#endif
