#ifndef SMOOTHTRIANGLE_HXX
#define SMOOTHTRIANGLE_HXX

#include "Primitive.hxx"
#include "Shader.hxx"

class SmoothTriangle : public Triangle
{
	// Vec3f a, b, c; // vtx positions inherited from Triangle
	Vec3f na, nb, nc; // vertex normals
public:
	SmoothTriangle(Vec3f a, Vec3f b, Vec3f c,
		Vec3f na,Vec3f nb,Vec3f nc,
		Shader *shader)
		: Triangle(a,b,c,shader),na(na),nb(nb),nc(nc)
	{};

	virtual Vec3f GetNormal(Ray &ray)
	{
		// assume u/v coordinates in ray correspond to beta(u) and gamma
		// (v) barycentric coordinates of hit point on triangle (have to be
		// stored like this in the intersection code !)

		Vec3f normal = ray.u * nb + ray.v * nc + (1 - ray.u - ray.v) * na;
		Normalize(normal);

		return normal;
	};
};

#endif
