#include "stdafx.h"

#include "Scene.hxx"
#include "EyeLightShader.hxx"

Vec3f vec3fFromStream(std::istream &aStream)
{
	float x, y, z;
	aStream >> x >> y >> z;
	return Vec3f(x, y, z);
}

struct FaceIdcs 
{
	int v[3], vn[3], vt[3];
	FaceIdcs()
	{ memset(this, -1, sizeof(*this)); }

	FaceIdcs(std::istream &aStream)
	{ 
		memset(this, -1, sizeof(*this));
		char c;

		for(int i = 0; i < 3; i++)
		{
			aStream >> v[i] >> std::ws;
			if(aStream.peek() != '/')
				continue;
			aStream >> c >> std::ws;
			if(aStream.peek() == '/')
				aStream >> c >> std::ws >> vn[i];
			else
				aStream >> vt[i];
			if(aStream.peek() != '/')
				continue;
			aStream >> c >> vn[i];
		}
	}
};


void Scene::ParseOBJ(char *fileName, PrimitiveFactory *aFactory)
{
	cout << "Parsing OBJFile : " << fileName << endl;

	std::ifstream ifile(fileName);

	std::vector<FaceIdcs> faces;
	std::vector<Vec3f> vert, norm, text;

	while(!ifile.eof())
	{
		std::string curLine;
		std::getline(ifile, curLine);

		std::istringstream issLine(curLine);
		std::string lineType;
		issLine >> std::ws >> lineType;

		if(lineType == "v")
			vert.push_back(vec3fFromStream(issLine));
		else if (lineType == "vn")
			norm.push_back(vec3fFromStream(issLine));
		else if (lineType == "vt")
			text.push_back(vec3fFromStream(issLine));
		else if (lineType == "f")
			faces.push_back(issLine);
	}

	for(std::vector<FaceIdcs>::iterator it = faces.begin(); it != faces.end(); it++)
	{
		Vec3f v[3], vn[3], vt[3];
		for(int i = 0; i < 3; i++)
		{
			v[i] = vert[it->v[i] - 1];
			if(it->vn[i] > 1 && it->vn[i] <= (int)norm.size())
				vn[i] = norm[it->vn[i] - 1];
			if(it->vt[i] > 1 && it->vt[i] <= (int)text.size())
				vt[i] = text[it->vt[i] - 1];
		}

		primitive.push_back(aFactory->createPrimitive(
			v[0], v[1], v[2], vn[0], vn[1], vn[2], vt[0], vt[1], vt[2]
		));
	}

	cout << "Number of Vertices: " << (vert.size() / 3) << endl;
	cout << "Number of Triangles: " << primitive.size() << endl;

	cout << "Finished Parsing" << endl;
}
