#ifndef AREALIGHT_HXX
#define AREALIGHT_HXX

#include "Light.hxx"

// quadrangular area light source

class QuadAreaLight : public Light
{
  Vec3f power;
  Vec3f p0,e1,e2;
  float area;
  Vec3f normal;
public:
  QuadAreaLight(Scene *scene,
		Vec3f power,Vec3f p0, Vec3f p1, Vec3f p2, Vec3f p3)
    : Light(scene),power(power),p0(p0),e1(p1-p0),e2(p3-p0)
  { 
    normal = Cross(e1,e2);
    area = Length(normal); 
    Normalize(normal);
  };  

  virtual bool Illuminate(Ray &ray, Vec3f &intensity)
  {
    float xi1 = drand48();
    float xi2 = drand48();

    Vec3f pos = p0 + xi1 * e1 + xi2 * e2;

    ray.dir = pos - ray.org;

    float dist = Length(ray.dir);

    float cosN = - Dot(ray.dir,normal) / dist;

    if (cosN <= 0.0f) 
      return false;
    
    intensity = (area * cosN / (dist*dist)) * power;
    
    Normalize(ray.dir);
    
    ray.t = dist;
    
    return true;
  }

  virtual Vec3f GetNormal(const Vec3f &position) const
  {
    return normal;
  }


};

#endif
