#ifndef INFINITEPLANE_HXX
#define INFINITEPLANE_HXX

#include "Primitive.hxx"
#include "Shader.hxx"

class InfinitePlane : public Primitive
{
  Vec3f normal;
  Vec3f origin;
public:
  InfinitePlane(Vec3f origin, Vec3f normal, Shader *shader)
    : Primitive(shader),normal(normal),origin(origin)
  { Normalize(normal); };

  virtual bool Intersect(Ray &ray)
  {
    Vec3f diff = origin - ray.org;
    float t = Dot(diff,normal) / Dot(ray.dir,normal);
    if (t < Epsilon || t > ray.t)
      return false;

    ray.t = t;
    ray.hit = this;
    return true;
  };

  virtual Vec3f GetNormal(Ray &ray)
  {
    return normal;
  };

  Box InfinitePlane::CalcBounds()
  {
    Box bounds;
    
    Vec3f infty = Vec3f(Infinity,Infinity,Infinity);
    
    if (normal.x == 0) {
      bounds.Extend(Vec3f(origin.x,-Infinity,-Infinity));
      bounds.Extend(Vec3f(origin.x,Infinity,Infinity));
    } else if (normal.y == 0) {
      bounds.Extend(Vec3f(-Infinity,origin.y,-Infinity));
      bounds.Extend(Vec3f(Infinity,origin.y,Infinity));
    } else if (normal.z == 0) {
      bounds.Extend(Vec3f(-Infinity,-Infinity,origin.z));
      bounds.Extend(Vec3f(Infinity,Infinity,origin.z));
    } else {
      bounds.Extend(Vec3f(-Infinity,-Infinity,-Infinity));
      bounds.Extend(Vec3f(Infinity,Infinity,Infinity));
    }
    
    return bounds;
  }
};

#endif
