#ifndef POINTLIGHT_HXX
#define POINTLIGHT_HXX

#include "Light.hxx"

class PointLight : public Light
{
public:
  Vec3f position;  // origin
  Vec3f intensity; // emission (red, green, blue)

  PointLight(Scene *scene, Vec3f position, Vec3f intensity)
    : Light(scene),position(position),intensity(intensity)
  {};  

  virtual bool Illuminate(Ray &ray, Vec3f &intensity)
  {
    /* ray towards point light position */
    
    ray.dir = position - ray.org;
    ray.hit = NULL;
    ray.t   = Length(ray.dir) - Epsilon; // maximal ray length
    Normalize(ray.dir);
    
    /* return attenuated intensity */

    //float sqrtDist = ray.t * ray.t;
    
    //float attenuation = 1.0f / sqrtDist; 
    float attenuation = 1.0f / (0.5f* ray.t + 1.0f); // linear attenuation
    intensity = attenuation * this->intensity;

    return true;
  };
};

#endif
