#include "stdafx.h"

#include "Scene.hxx"
#include "EyeLightShader.hxx"

void Scene::ParseOBJ(char *fileName)
{
	cout << "Parsing OBJFile : " << fileName << endl;

	shd = new EyeLightShader(this, Vec3f(1, 1 ,1));

	FILE *file = fopen(fileName, "r");

	if(file == NULL)
	{
		cout << "Could not open " << fileName << endl;;
		return;
	}

	char line[1000];

	vector <int> faces;
	vector <float> vert;

	while(fgets(line, 1000, file) && !feof(file))
	{
		if(strncmp(line,"v ",2) == 0)
		{
			float a,b,c;

			sscanf(line,"v %f %f %f",&a,&b,&c);

			vert.push_back(a);
			vert.push_back(b);
			vert.push_back(c);
		}

		if(strncmp(line,"f ",2) == 0)
		{
			int a,b,c;

			sscanf(line,"f %d %d %d", &a, &b, &c);

			faces.push_back(a);
			faces.push_back(b);
			faces.push_back(c);
		}
	}

	for(unsigned int n = 0; n < faces.size() / 3; n++)
	{
		// vertex positions of triangle
		Vec3f tri[3];

		// index into face list
		int vertID[3];

		vertID[0] = faces[n * 3 + 0] - 1;
		vertID[1] = faces[n * 3 + 1] - 1;
		vertID[2] = faces[n * 3 + 2] - 1;


		tri[0][0] = vert[vertID[0] * 3 + 0] * 1;
		tri[0][1] = vert[vertID[0] * 3 + 1] * 1;
		tri[0][2] = vert[vertID[0] * 3 + 2] * 1;

		tri[1][0] = vert[vertID[1] * 3 + 0] * 1;
		tri[1][1] = vert[vertID[1] * 3 + 1] * 1;
		tri[1][2] = vert[vertID[1] * 3 + 2] * 1;

		tri[2][0] = vert[vertID[2] * 3 + 0] * 1;
		tri[2][1] = vert[vertID[2] * 3 + 1] * 1;
		tri[2][2] = vert[vertID[2] * 3 + 2] * 1;

		primitive.push_back(new Triangle(tri[0], tri[1], tri[2], shd));
	}

	cout << "Number of Verts: " << (vert.size() / 3) << endl;
	cout << "Number of Triangles: " << primitive.size() << endl;

	cout << "Finished Parsing" << endl;
}
