#include "stdafx.h"

#include "Scene.hxx"
#include "Triangle.hxx"
#include "Image.hxx"
#include "PerspectiveCamera.hxx"

#include "EyeLightShader.hxx"

void RenderFrame(char *fileName, bool aUseBVH)
{
	/* Define a scene */
	Scene scene(aUseBVH);

	/* Load scene description */
	scene.ParseOBJ(fileName);

	/* Build BVH */
	scene.BuildAccelStructure();

	Vec3f pointLightIntensity(3,3,3);
	Vec3f lightPosition2(-3,5,+4);
	Vec3f lightPosition3(0,1,+4);

	Image img(scene.camera->resX,scene.camera->resY); // image array
	Ray ray;                                          // primary ray

	for (int y=0;y<scene.camera->resY;y++)
		for (int x=0;x<scene.camera->resX;x++) {
			scene.camera->InitRay(x+0.5f,y+0.5f,ray); // initialize ray
			//scene.camera->InitRay(0+0.5,0+0.5,ray); // initialize ray

			//Color values must be clamped between 0 and 1
			img[y][x] = Min(Max(scene.RayTrace(ray),Vec3f(0,0,0)),Vec3f(1,1,1));
		}

	img.WritePPM("result.ppm"); // write final image
}

#define RESX 320 // image x-resolution
#define RESY 200 // image y-resolution

int main(int argc, char* argv[])
{
	bool cmdError = argc == 3 && _strcmp(argv[1], "-bvh") != 0 || argc > 3 || argc < 2;

	if(cmdError)
	{
		std::cerr << "Usage: " << argv[0] << " [-bvh] <file-name>" << std::endl;
		exit(1);
	}

	RenderFrame(argv[argc-1], argc == 3);
}
