#ifndef __BVH_TREE_H_INCLUDED
#define __BVH_TREE_H_INCLUDED

#include "Box.hxx"

class BVH
{
	struct Node
	{
		Box bbox;
		//Note: the result is stored in ray! (in ray.t and ray.hit)
		virtual void traverse(Ray &ray) = 0;
	};

	struct InnerNode : public Node
	{
		Node *leftChild, *rightChild;

		InnerNode(const Box& aBBox)
		{
			bbox = aBBox;
		}

		virtual void traverse(Ray &ray)
		{
			//////////////////////////////////////////////////////////////////////////
			//TODO: Implement!	
			//Note: use a recursive algorithm:
			//	- Intersect the ray with the bounding boxes of both children
			//	- Classify them as near and far, based on the entry distance of the ray
			//	- Search for intersection recursively in the near one
			//	- If no intersection is found there, or if the distance to the intersection
			//		is beyond the entry point of the right one, search for intersection
			//		in the right one recursively
			//////////////////////////////////////////////////////////////////////////
		}

		virtual ~InnerNode() {}
	};

	struct LeafNode : public Node
	{
		vector<Primitive *> primitive;

		LeafNode(const Box& aBBox, vector<Primitive *> &prim)
		{
			bbox = aBBox;
			primitive = prim;
		}

		virtual void traverse(Ray &ray)
		{
			//////////////////////////////////////////////////////////////////////////
			//TODO: Implement!	
			//Note: Simply loop over the contained primitives and intersect them 
			//	with the ray
			//////////////////////////////////////////////////////////////////////////
		}

		virtual ~LeafNode() {}
	};

public:
	int maxDepth, minTri;

	Node *BuildTree(Box &bounds, vector<Primitive *> prim, int depth)
	{
		//////////////////////////////////////////////////////////////////////////
		//TODO: Implement!	
		//////////////////////////////////////////////////////////////////////////
		
		return NULL;
	}

	Node *root;

	BVH(Box topBox, vector<Primitive *> primitives)
	{
		maxDepth = 30;
		minTri = 3;
		root = NULL;
		root = BuildTree(topBox, primitives, 0);
	}

	bool Intersect(Ray &ray) 
	{
		root->traverse(ray);

		return ray.hit != NULL;
	}

};

#endif
