#ifndef SCENE_HXX
#define SCENE_HXX

#include "Light.hxx"
#include "Primitive.hxx"
#include "PerspectiveCamera.hxx"

#include <vector>

class Scene 
{
public:
  Vec3f bgColor;    // background color

  std::vector<Primitive *> primitive; // primitives
  std::vector<Light *> lights; // lights

  Camera *camera; 

  Scene()
    : bgColor(Vec3f(0,0,0)),
      camera(new PerspectiveCamera(Vec3f(0,0,8),Vec3f(0,0,-1),
				   Vec3f(0,1,0),60,640,480))
  {};
  
  virtual ~Scene() {};
  
  // add a new primitive
  void Add(Primitive *prim)
  { primitive.push_back(prim); };

  // add a new light
  void Add(Light *light)
  { lights.push_back(light); };
  
  // intersect all contained objects
  virtual bool Intersect(Ray &ray)
  {
    bool hit = false;
    
    for (unsigned int i=0;i<primitive.size();i++)
      hit |= primitive[i]->Intersect(ray);
    
    return hit;
  };

  // find occluder
  bool Occluded(Ray &ray)
  {
    for (unsigned int i=0;i<primitive.size();i++)
      if (primitive[i]->Occluded(ray))
        return true;
  
    return false;
  };
  
  // trace the given ray and shade it and
  // return the color of the shaded ray
  Vec3f RayTrace(Ray &ray)
  {
    Vec3f result;
	  
    if(Intersect(ray)) {
      result = ray.hit->shader->Shade(ray); // shade the primitive
      
      return result;
    }
    else
      return bgColor; // ray missed geometric primitives
  };
};

#endif
