
#include "Scene.hxx"
#include "Sphere.hxx"
#include "InfinitePlane.hxx"
#include "Triangle.hxx"
#include "Image.hxx"
#include "PerspectiveCamera.hxx"

#include "FlatShader.hxx"
#include "PhongShader.hxx"
#include "EyeLightShader.hxx"

#include "PointLight.hxx"
#include "QuadAreaLight.hxx"

void RenderFrame(char *fileName)
{
  /* Define a scene */

  Scene scene;

  /* Flat surface shaders */

//   FlatShader shd1(&scene, Vec3f(1,0,0)); // red surface
//   FlatShader shd2(&scene, Vec3f(0,1,0)); // green surface
//  FlatShader shd3(&scene, Vec3f(0,0,1)); // blue surface
//   FlatShader shd4(&scene, Vec3f(1,1,0)); // yellow surface
//   FlatShader shd5(&scene, Vec3f(0,1,1)); // cyan surface
//  FlatShader shd6(&scene, Vec3f(1,1,1)); // white surface

  /* EyeLight surface shaders */

//   EyeLightShader shd1(&scene, Vec3f(1,0,0)); // red surface
//   EyeLightShader shd2(&scene, Vec3f(0,1,0)); // green surface
//   EyeLightShader shd3(&scene, Vec3f(0,0,1)); // blue surface
//   EyeLightShader shd4(&scene, Vec3f(1,1,0)); // yellow surface
//   EyeLightShader shd5(&scene, Vec3f(0,1,1)); // cyan surface
//   EyeLightShader shd6(&scene, Vec3f(1,1,1)); // white surface

  /* Phong surface shaders */
  
  PhongShader shd1(&scene, Vec3f(1,0,0), 0.1, 0.5, 0.5, 40); // red surface
  PhongShader shd2(&scene, Vec3f(0,1,0), 0.1, 0.5, 0.5, 40); // green surface
  PhongShader shd3(&scene, Vec3f(0,0,1), 0.1, 0.5, 0.5, 40); // blue surface
  PhongShader shd4(&scene, Vec3f(1,1,0), 0.1, 0.5, 0.5, 40); // yellow surface
  PhongShader shd5(&scene, Vec3f(0,1,1), 0.1, 0.5, 0.5, 40); // cyan surface
  PhongShader shd6(&scene, Vec3f(1,1,1), 0.1, 0.5, 0.5, 40); // white surface
  
  /* scene objects */

  Sphere s1(Vec3f(-2,1.7,0),2, &shd1);
  Sphere s2(Vec3f(1,-1,1),2.2, &shd2);
  Sphere s3(Vec3f(3,0.8,-2),2, &shd3);
  InfinitePlane p1(Vec3f(0,-1,0),Vec3f(0,1,0), &shd4);
  
  Triangle t1(Vec3f(-2,3,1),Vec3f(1,2,1),Vec3f(3,2.8,3), &shd5); 
  //Triangle t2(Vec3f(3,2,3),Vec3f(3,2,-3),Vec3f(-3,2,-1), &shd6);

  /* Add primitives to scene */

  scene.Add(&s1);
  scene.Add(&s2);
  scene.Add(&s3);
  scene.Add(&p1);
  scene.Add(&t1);
  //scene.Add(&t2);
  
   Vec3f pointLightIntensity(50,50,50);
  // Vec3f lightPosition1(0,50,0);
   //Vec3f lightPosition2(-3,5,+4);

  //  Vec3f quadLightIntensity(25,25,25);
  /*Vec3f lightPosition1(0,50,0);
  Vec3f lightPosition2(-3,5,+4);
  
  PointLight pointLight1(&scene, lightPosition1, pointLightIntensity);
  PointLight pointLight2(&scene, lightPosition2, pointLightIntensity);

  scene.Add(&pointLight1);
  scene.Add(&pointLight2);
*/
 Vec3f quadLightIntensity(25,25,25);
 
 QuadAreaLight quadLight(&scene, quadLightIntensity, //Vec3f(-1.5, 10, -1.5), Vec3f(1.5, 10, 1.5), Vec3f(1.5, 10, -1.5),
		 //Vec3f(-1.5, 10, 1.5));

		 
		 Vec3f(-1.5, 10, -1.5), Vec3f(-1.5, 10, 1.5), 
			  Vec3f(1.5, 10, 1.5), Vec3f(1.5, 10,-1.5));

			  scene.Add(&quadLight);

  Image img(scene.camera->resX,scene.camera->resY); // image array
  Ray ray;                                          // primary ray

  for (int y=0;y<scene.camera->resY;y++)
    for (int x=0;x<scene.camera->resX;x++) {
      scene.camera->InitRay(x+0.5,y+0.5,ray); // initialize ray
      
      //Color values must be clamped between 0 and 1
      img[y][x] = Min(Max(scene.RayTrace(ray),Vec3f(0,0,0)),Vec3f(1,1,1));
    }
  
  img.WritePPM(fileName); // write final image
}

#define RESX 640 // image x-resolution
#define RESY 480 // image y-resolution

int main(int, char **)
{
  RenderFrame("phong_area.ppm");
}
