#ifndef IMAGE_HXX
#define IMAGE_HXX

#include "Vec3f.hxx"
class Image
{
  int resX, resY;
  Vec3f *pixel;
public:
  Image(int resX,int resY) : resX(resX),resY(resY)
  {
    assert (resX > 0 && resY > 0);
    pixel = new Vec3f[resX*resY];
  }
  ~Image()
  { delete[] pixel; };

  Vec3f *operator[](int y)
  { 
    return pixel+y*resX; 
  };

  void WritePPM(char *fileName);
};

#endif
