#include "Image.hxx"

void Image::WritePPM(char *fileName)
{
  std::ofstream file(fileName);
  file << "P3" << std::endl;
  file << resX << " " << resY << " " << 255 << std::endl;
  for (int y=resY-1;y>=0;y--) {
    for (int x=0;x<resX;x++)
      file 
	<< (int)(255.99999999 * (*this)[y][x].x) << " "
	<< (int)(255.99999999 * (*this)[y][x].y) << " "
	<< (int)(255.99999999 * (*this)[y][x].z) << " "
	<< "\t";
    file << std::endl;
    file << std::flush;
  };
};
