#ifndef SCENE_HXX
#define SCENE_HXX

#include "Light.hxx"
#include "Primitive.hxx"
#include "PerspectiveCamera.hxx"

#include <vector>

class Scene 
{
public:
  Vec3f bgColor;    // background color

  std::vector<Primitive *> primitive; // primitives
  std::vector<Light *> lights; // lights

  Camera *camera; 

  Scene()
    : bgColor(Vec3f(0,0,0)),
      camera(new PerspectiveCamera(Vec3f(0,0,8),Vec3f(0,0,-1),
				   Vec3f(0,1,0),60,640,480))
  {};
  
  virtual ~Scene() {};
  
  // add a new primitive
  void Add(Primitive *prim)
  { };

  // add a new light
  void Add(Light *light)
  { };
  
  // intersect all contained objects
  virtual bool Intersect(Ray &ray)
  {
    return false;
  };

  // find occluder
  bool Occluded(Ray &ray)
  {
    return false;
  };
  
  // trace the given ray and shade it and
  // return the color of the shaded ray
  Vec3f RayTrace(Ray &ray)
  {
    Vec3f result;
	  
    return result;
  };
};

#endif
