#ifndef AREALIGHT_HXX
#define AREALIGHT_HXX

#include "Light.hxx"

// quadrangular area light source

class QuadAreaLight : public Light
{
  Vec3f power;
  Vec3f p0,e1,e2;
  float area;
  Vec3f normal;
public:
  QuadAreaLight(Scene *scene,
		Vec3f power,Vec3f p0, Vec3f p1, Vec3f p2, Vec3f p3)
    : Light(scene),power(power),p0(p0),e1(p1-p0),e2(p3-p0)
  { 
    normal = Cross(e1,e2);
    area = Length(normal); 
    Normalize(normal);
  };  

  virtual bool Illuminate(Ray &ray, Vec3f &intensity)
  {
    return true;
  }

  virtual Vec3f GetNormal(const Vec3f &position) const
  {
    return normal;
  }


};

#endif
