#ifndef PRIMITIVE_HXX
#define PRIMITIVE_HXX

#include "Ray.hxx"
#include "Shader.hxx"

class Primitive
{
public:
  Shader *shader;

  Primitive(Shader *shader=NULL) : shader(shader)
  {};

  virtual bool Intersect(Ray &ray) = 0;
  virtual bool Occluded(Ray &ray) {return Intersect(ray);}
  virtual Vec3f GetNormal(Ray &ray) = 0;
};

#endif
