#ifndef PHONGSHADER_HXX
#define PHONGSHADER_HXX

#include "Shader.hxx"
 
#define AREALIGHT 
#define NUM_AREA_SAMPLES 1000

class PhongShader : public Shader
{
public:
  Vec3f color; // color = diffuse color (cd) = ambient color (ca)
               // use Vec3f(1,1,1) as specular color 
  float ka;    // ambient coefficient
  float kd;    // diffuse reflection coefficients
  float ks;    // specular refelection coefficients
  float ke;    // shininess exponent

  PhongShader(Scene *scene,
	      Vec3f color, float ka,float kd, float ks, float ke)
    : Shader(scene),color(color),ka(ka),kd(kd),ks(ks),ke(ke)
  {};

  virtual Vec3f Shade(Ray &ray)
  {
    return Vec3f(0,0,0);
  };
};

#endif
