#ifndef PERSPECTIVECAMERA_HXX
#define PERSPECTIVECAMERA_HXX

#include "Camera.hxx"

class PerspectiveCamera : public Camera
{
  // input values
  Vec3f pos,dir,up;
  float angle;
  
  // preprocessed values
  float focus;
  Vec3f xAxis,yAxis,zAxis;
  float aspect;
public:
  PerspectiveCamera(Vec3f pos,Vec3f dir,Vec3f up,
		    float angle,
		    int resX, int resY
		    )
    : Camera(resX,resY),pos(pos),dir(dir),up(up),angle(angle)
  {
    zAxis = dir;
    xAxis = Cross(dir,up);
    yAxis = Cross(xAxis,zAxis);

    Normalize(xAxis);
    Normalize(yAxis);
    Normalize(zAxis);

    aspect = resX / float(resY);

    // opening angle:
    float angleInRad = angle * M_PI / 180.;
    focus = 1.0 / tan(angleInRad/2.);
  }
  virtual bool InitRay(float x, float y, Ray &ray)
  {
    ray.org = pos;
    ray.dir 
      = ( 2.0f * ((x/(float)resX - .5)*aspect) * xAxis)
      + ( 2.0f * (y/(float)resY - .5) * yAxis)
      + (focus * zAxis);
    ray.t = Infinity;
    Normalize(ray.dir);
    return true;
  };
};
#endif
