#ifndef INFINITEPLANE_HXX
#define INFINITEPLANE_HXX

#include "Primitive.hxx"
#include "Shader.hxx"

class InfinitePlane : public Primitive
{
  Vec3f normal;
  Vec3f origin;
public:
  InfinitePlane(Vec3f origin, Vec3f normal, Shader *shader)
    : normal(normal),origin(origin)
  { Normalize(normal); };

  virtual bool Intersect(Ray &ray)
  {
    Vec3f diff = origin - ray.org;
    float t = Dot(diff,normal) / Dot(ray.dir,normal);
    if (t < Epsilon || t > ray.t)
      return false;

    ray.t = t;
    return true;
  };

  virtual Vec3f GetNormal(Ray &ray)
  {
    return Vec3f(0,0,0);
  };
};

#endif
