#include "Sphere.hxx"
#include "Triangle.hxx"
#include "InfinitePlane.hxx"

#include "Image.hxx"
#include "PerspectiveCamera.hxx"

void RenderFrame(Camera &camera,char *fileName)
{
  /* scene objects */

  Sphere s1(Vec3f(-2,1.7,0),2);
  Sphere s2(Vec3f(1,-1,1),2.2);
  Sphere s3(Vec3f(3,0.8,-2),2);
  InfinitePlane p1(Vec3f(0,-1,0),Vec3f(0,1,0));

  Triangle t1(Vec3f(-2,3.7,0),Vec3f(1,2,1),Vec3f(3,2.8,-2)); 
  Triangle t2(Vec3f(3,2,3),Vec3f(3,2,-3),Vec3f(-3,2,-3)); 	

  Image img(camera.resX,camera.resY); // image array
  Ray ray;                            // primary ray

  for(int y=0;y<camera.resY;y++)
    for (int x=0;x<camera.resX;x++) {
      
      /* Initialize your ray here */

      /* Your code */

      Vec3f col = Vec3f(0,0,0); // background color
      
      /* 
       * Find closest intersection with scene
       * objetcs and calculate color 
       */
      
      /* Your code */

      img[y][x] = col; // store pixel color
    }
  img.WritePPM(fileName); // write final image
}

#define RESX 640 // image x-resolution
#define RESY 480 // image y-resolution

int main(int, char **)
{
  /* render three images with different camera settings */

  PerspectiveCamera c1(Vec3f(0,0,10),Vec3f(0,0,-1),Vec3f(0,1,0),60,RESX,RESY);
  RenderFrame(c1,"perspective1.ppm");

  PerspectiveCamera c2(Vec3f(-8,3,8),Vec3f(1,-.1,-1),Vec3f(0,1,0),45,RESX,RESY);
  RenderFrame(c2,"perspective2.ppm");

  PerspectiveCamera c3(Vec3f(-8,3,8),Vec3f(1,-.1,-1),Vec3f(1,1,0),45,RESX,RESY);
  RenderFrame(c3,"perspective3.ppm");
}
