#ifndef TEXTUREDSMOOTHTRIANGLE_HXX
#define TEXTUREDSMOOTHTRIANGLE_HXX

#include "SmoothTriangle.hxx"

class TexturedSmoothTriangle : public SmoothTriangle
{
	// Vec3f  a, b, c; // vtx positions inherited from Triangle
	// Vec3f na,nb,nc; // vtx normals inherited from SmoothTriangle
	Vec3f ta, tb, tc;  // vertex texture coordinates
public:
	TexturedSmoothTriangle(Vec3f a,  Vec3f b,  Vec3f c,
		Vec3f na, Vec3f nb, Vec3f nc,
		Vec3f ta, Vec3f tb, Vec3f tc,
		Shader *shader)
		: SmoothTriangle(a,b,c,na,nb,nc,shader),ta(ta),tb(tb),tc(tc)
	{};

	// virtual bool Intersect(Ray &ray); // inherited from Triangle
	// virtual Box CalcBounds();         // inherited from Triangle 
	// virtual Vec3f GetNormal(Ray &ray) // inherited from Triangle

	virtual void GetUV(Ray &ray, float &u, float &v)
	{
		Vec3f pixelcoord = ray.u * (tb - ta) + ray.v * (tc - ta)  + ta;
		u = pixelcoord.x;
		v = pixelcoord.y;
	};
};

#endif
