#ifndef TEXTUREDEYELIGHTSHADER_HXX
#define TEXTUREDEYELIGHTSHADER_HXX

#include "EyeLightShader.hxx"
#include "Texture.hxx"

class TexturedEyeLightShader : public EyeLightShader
{
public:
  Texture texture;
  
  TexturedEyeLightShader(Scene *scene, Vec3f color=Vec3f(0.5,0.5,0.5), char *fileName = NULL)
    : EyeLightShader(scene, color), texture(fileName)
  {};
  
  // just because of compiler warning
  virtual ~TexturedEyeLightShader()
  {};
  
  virtual Vec3f Shade(Ray &ray)
  {
	float u = 0,
	      v = 0;

	ray.hit->GetUV(ray, u, v);
	v = 1.0f - v;

	return Product(color, texture.GetTexel(u,v)) * fabs(Dot(ray.dir,ray.hit->GetNormal(ray)));
  };
};

#endif
