#ifndef TEXTURE_HXX
#define TEXTURE_HXX

#include "Image.hxx"

class Texture : public Image
{
public:
  Texture(int resX, int resY) : Image(resX,resY)
  {};

  Texture(char *fileName) : Image(1,1)
  { ReadPPM(fileName); };
  
  Vec3f GetTexel(float u, float v)
  {
    /* find texel indices */
    
    int px = (int)floor(resX * u);
    int py = (int)floor(resY * v);
    
    /* texture repeat wrap */
    
    px = ((px % resX) + resX) % resX;
    py = ((py % resY) + resY) % resY;
    
    return (*this)[resY-py-1][px];
  };
};

#endif
