#ifndef STRATIFIEDSAMPLEGENERATOR_HXX
#define STRATIFIEDSAMPLEGENERATOR_HXX

#include "SampleGenerator.hxx"

class StratifiedSampleGenerator : public SampleGenerator 
{
public:
	virtual void GetSamples(int n, float *u, float *v, float *weight)
	{    
		float stdweight = 1.0f / static_cast<float>(n),
		      mf        = sqrt(n);
		int   m         = static_cast<int>(mf),
		      pos;

		for (int i = 0; i < m; ++i)
			for (int j = 0; j < m; ++j)
			{
				pos = i * m + j;
				u[pos] = (static_cast<float>(i) + drand48()) / mf;
				v[pos] = (static_cast<float>(j) + drand48()) / mf;
				weight[pos] = stdweight;
			}
	};

	virtual ~StratifiedSampleGenerator(){};
};

#endif
