#ifndef SMOOTHTRIANGLE_HXX
#define SMOOTHTRIANGLE_HXX

#include "Primitive.hxx"
#include "Shader.hxx"

class SmoothTriangle : public Triangle
{
	// Vec3f a, b, c; // vtx positions inherited from Triangle
	Vec3f na, nb, nc; // vertex normals
public:
	SmoothTriangle(Vec3f a, Vec3f b, Vec3f c,
		Vec3f na,Vec3f nb,Vec3f nc,
		Shader *shader)
		: Triangle(a,b,c,shader),na(na),nb(nb),nc(nc)
	{};

	virtual Vec3f GetNormal(Ray &ray)
	{
		Vec3f hitNormal = ray.u * (nb - na) + ray.v * (nc - na)  + na;
		Normalize(hitNormal);

		return hitNormal;
	};
};

#endif
