#ifndef REGULARSAMPLEGENERATOR_HXX
#define REGULARSAMPLEGENERATOR_HXX

#include "SampleGenerator.hxx"
#include <math.h>

class RegularSampleGenerator : public SampleGenerator 
{
public:
	virtual void GetSamples(int n,float *u, float *v, float *weight)
	{
		float stdweight = 1.0f / static_cast<float>(n),
		      mf        = sqrt(n);
		int   m         = static_cast<int>(mf),
		      pos;

		for (int i = 0; i < m; ++i)
			for (int j = 0; j < m; ++j)
			{
				pos = i * m + j;
				u[pos] = (static_cast<float>(i) + 0.5) / mf;
				v[pos] = (static_cast<float>(j) + 0.5) / mf;
				weight[pos] = stdweight;
			}
	};

	virtual ~RegularSampleGenerator(){};
};

#endif
