#ifndef PRIMITIVE_HXX
#define PRIMITIVE_HXX

#include "Box.hxx"
#include "Ray.hxx"
#include "Shader.hxx"

class Primitive
{
public:
	Shader *shader;

	Primitive(Shader *shader=NULL) : shader(shader)
	{};

	virtual ~Primitive()
	{};

	virtual bool Intersect(Ray &ray) = 0;
	virtual bool Occluded(Ray &ray) {return Intersect(ray);}
	virtual Vec3f GetNormal(Ray &ray) = 0;

	virtual Box CalcBounds() = 0;

	virtual void GetUV(Ray &ray, float &u, float &v)
	{
		u = ray.org.x + ray.t * ray.dir.x;
		v = ray.org.z + ray.t * ray.dir.z;
	};
};

#endif
