#ifndef POINTLIGHT_HXX
#define POINTLIGHT_HXX

#include "Light.hxx"

class PointLight : public Light
{
public:
	Vec3f position;  // origin
	Vec3f intensity; // emission (red, green, blue)

	PointLight(Scene *scene, Vec3f position, Vec3f intensity)
		: Light(scene),position(position),intensity(intensity)
	{};  

	virtual bool Illuminate(Ray &ray, Vec3f &intensity)
	{
		ray.dir = position - ray.org;
		ray.t   = Length(ray.dir) - Epsilon;
		ray.hit = NULL;

		Normalize(ray.dir);

		intensity = this->intensity / (0.5f * ray.t + 1.0f);
		return true;
	};
};

#endif
