#ifndef INFINITEPLANE_HXX
#define INFINITEPLANE_HXX

#include "Box.hxx"

class InfinitePlane : public Primitive
{
	Vec3f normal, origin;
	float numerator, denominator, t;

	Box box;
public:
	InfinitePlane(Vec3f origin, Vec3f normal, Shader *shader)
		: normal(normal),origin(origin)
	{
		this->shader = shader;
		Normalize(normal);

		if      (normal.x == 0)
		{
			box.Extend(Vec3f(origin.x, -Infinity, -Infinity));
			box.Extend(Vec3f(origin.x,  Infinity,  Infinity));
		}
		else if (normal.y == 0)
		{
			box.Extend(Vec3f(-Infinity, origin.y, -Infinity));
			box.Extend(Vec3f( Infinity, origin.y,  Infinity));
		}
		else if (normal.z == 0)
		{
			box.Extend(Vec3f(-Infinity, -Infinity, origin.z));
			box.Extend(Vec3f( Infinity,  Infinity, origin.z));
		}
		else
		{
			box.Extend(Vec3f(-Infinity));
			box.Extend(Vec3f( Infinity));
		}
	};

	virtual ~InfinitePlane(){};

	virtual bool Intersect(Ray &ray)
	{
		numerator   = Dot(origin - ray.org, normal);
		denominator = Dot(         ray.dir, normal);

		if (denominator != 0.0)
		{
			t = numerator / denominator;
			if (t < ray.t && t > Epsilon)
			{
				ray.t = t;
				ray.hit = this;
				return true;
			}
		}

		return false;
	};

	virtual Vec3f GetNormal(Ray &ray)
	{
		Vec3f normal = this->normal;
		return normal;
	};

	virtual Box CalcBounds()
	{
		return Box();
	}
};

#endif
