;;;
;;; File: robotworld.lisp
;;; ---------------------
;;; This file should define the operators for the robot environment.
;;;


;;; Some important things to remember as you implement the preconditions
;;; and effects for each of the operators in the "robot-world" domain:
;;;
;;; * The "at" predicate has two arguments: an entity and a cell location
;;;   as in (at robot x1-y8) or (at box x8-y7).
;;;
;;; * Your planner need not (and should not) try to reason about any cell 
;;;   locations in the world which are not explicitly given in the
;;;   "inits" of a problem using the "cell" predicate.
;;;
;;; * The "object" predicate describes which entities are objects.
;;;   Since the box and the stick are the only two objects, the
;;;   predicates (object box) and (object stick) should always hold.
;;;
;;; * The "holding" predicate should be used to determine what object
;;;   the robot is holding.  Thus (holding box) indicates the robot is
;;;   holding the box.
;;;
;;; * There are several propositions which are useful in keeping track
;;;   of the state of the world.  They are: (hand-empty) to indicate
;;;   the robot is not holding anything, (light-on) to indicate that
;;;   the light is on, and (on-box) to indicate that the robot is
;;;   standing on the box.
;;;
;;; * You should absolutely NOT add any operators, nor change the
;;;   parameter list for any of the operators provided.  You should
;;;   ONLY fill in the preconditions and effects for each operator
;;;   list below.

(in-package "UCPOP")

(defun robot-world ()
  (reset-domain)
  (define (operator move-to)
	     :parameters ((cell ?from) (cell ?to))
	     :precondition ()
	     :effect ()
	     )
  (define (operator get-object)
	     :parameters ((object ?obj) (cell ?c))
	     :precondition ()
	     :effect ()
	     )
  (define (operator drop-object)
	     :parameters ((object ?obj) (cell ?c))
	     :precondition ()
	     :effect ()
	     )
  (define (operator climb-box)
	     :parameters ((cell ?c))
	     :precondition ()
	     :effect ()
	     )
  (define (operator descend-box)
	     :parameters ((cell ?c))
	     :precondition ()
	     :effect ()
	     )
  (define (operator jump-light-on)
	     :parameters ((cell ?c))
	     :precondition ()
	     :effect ()
	     )
  (define (operator jump-light-off)
	     :parameters ((cell ?c))
	     :precondition ()
	     :effect ()
	     )
  (define (operator switch-light-on)
	     :parameters ((cell ?c))
	     :precondition ()
	     :effect ()
	     )
  (define (operator switch-light-off)
	     :parameters ((cell ?c))
	     :precondition ()
	     :effect ()
	     )
  (define (operator stick-light-on)
	     :parameters ((cell ?c))
	     :precondition ()
	     :effect ()
	     )
  (define (operator stick-light-off)
	     :parameters ((cell ?c))
	     :precondition ()
	     :effect ()
	     )
  )


;;; You should not modify anything below this line in the file!

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (problem simple-move)
  :domain 'robot-world
  :inits (
	  ;;; cell symbolic identifiers
	  (cell x1-y8)
	  (cell x5-y1)
	  (cell x8-y7)
	  (cell x7-y1)
	  (cell x1-y1)

	  ;;; initial locations
	  (at robot x1-y8)
	  (at box x8-y7)
	  (at stick x1-y1)
	  (at light x7-y1)

	  ;;; objects in the world
	  (object box)
	  (object stick)

	  ;;; initial world conditions
	  (hand-empty)
	  (not light-on)   ;; not necessary, only for clarity
	  (not on-box)     ;; not necessary, only for clarity
	  (not holding box)   ;; not necessary, only for clarity
	  (not holding stick) ;; not necessary, only for clarity
	  )

  :goal (at robot x5-y1)
  )


(define (problem turn-light-on)
  :domain 'robot-world
  :inits (
	  ;;; cell symbolic identifiers
	  (cell x1-y8)
	  (cell x5-y1)
	  (cell x8-y7)
	  (cell x7-y1)
	  (cell x1-y1)

	  ;;; initial locations
	  (at robot x1-y8)
	  (at box x8-y7)
	  (at stick x1-y1)
	  (at light x7-y1)

	  ;;; objects in the world
	  (object box)
	  (object stick)

	  ;;; initial world conditions
	  (hand-empty)
	  (not light-on)   ;; not necessary, only for clarity
	  (not on-box)     ;; not necessary, only for clarity
	  (not holding box)   ;; not necessary, only for clarity
	  (not holding stick) ;; not necessary, only for clarity
	  )

  :goal (light-on)
  )


(define (problem stick-and-light)
  :domain 'robot-world
  :inits (
	  ;;; cell symbolic identifiers
	  (cell x1-y8)
	  (cell x5-y1)
	  (cell x8-y7)
	  (cell x7-y1)
	  (cell x1-y1)

	  ;;; initial locations
	  (at robot x1-y8)
	  (at box x8-y7)
	  (at stick x1-y1)
	  (at light x7-y1)

	  ;;; objects in the world
	  (object box)
	  (object stick)

	  ;;; initial world conditions
	  (hand-empty)
	  (not light-on)   ;; not necessary, only for clarity
	  (not on-box)     ;; not necessary, only for clarity
	  (not holding box)   ;; not necessary, only for clarity
	  (not holding stick) ;; not necessary, only for clarity
	  )

  :goal (and (holding stick) 
	     (light-on))
  )


(define (problem get-on-box)
  :domain 'robot-world
  :inits (
	  ;;; cell symbolic identifiers
	  (cell x1-y8)
	  (cell x5-y1)
	  (cell x8-y7)
	  (cell x7-y1)
	  (cell x1-y1)

	  ;;; initial locations
	  (at robot x1-y8)
	  (at box x8-y7)
	  (at stick x1-y1)
	  (at light x7-y1)

	  ;;; objects in the world
	  (object box)
	  (object stick)

	  ;;; initial world conditions
	  (hand-empty)
	  (not light-on)   ;; not necessary, only for clarity
	  (not on-box)     ;; not necessary, only for clarity
	  (not holding box)   ;; not necessary, only for clarity
	  (not holding stick) ;; not necessary, only for clarity
	  )

  :goal (and (at robot x5-y1)
	     (on-box))
  )


(define (problem box-and-light)
  :domain 'robot-world
  :inits (
	  ;;; cell symbolic identifiers
	  (cell x1-y8)
	  (cell x5-y1)
	  (cell x8-y7)
	  (cell x7-y1)
	  (cell x1-y1)

	  ;;; initial locations
	  (at robot x1-y8)
	  (at box x8-y7)
	  (at stick x1-y1)
	  (at light x7-y1)

	  ;;; objects in the world
	  (object box)
	  (object stick)

	  ;;; initial world conditions
	  (hand-empty)
	  (not light-on)   ;; not necessary, only for clarity
	  (not on-box)     ;; not necessary, only for clarity
	  (not holding box)   ;; not necessary, only for clarity
	  (not holding stick) ;; not necessary, only for clarity
	  )

  :goal (and (light-on)
	     (at robot x5-y1)
	     (on-box))
  )




