;;;;;;;;;;;;;;;
;;; This is a large real-world scheduling domain
;;; In controllers.lisp you will find a search controller for it
;;; To make a problem from those supplied in the default directory,
;;; evaluate (load-metal-prob filename)

(in-package "UCPOP")

;;; Directory to find problems in:

(defparameter *p-metal-dir* "~/ai/planners/ucpop/other-domains/processp/")


;;; The domain

(define (domain metal-domain)

  (:operator DRILL-WITH-SPOT-DRILL
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE DRILL)
			 (IS-A ?DRILL-BIT SPOT-DRILL)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y)))
  
  (:operator DRILL-WITH-TWIST-DRILL
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?HOLE-DEPTH ?HOLE-DIAMETER ?LOC-Y ?LOC-X
			    ?DRILL-BIT-DIAMETER)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE DRILL)
			 (EQ ?DRILL-BIT-DIAMETER ?HOLE-DIAMETER)
			 (DIAMETER-OF-DRILL-BIT ?DRILL-BIT ?DRILL-BIT-DIAMETER)
			 (IS-A ?DRILL-BIT TWIST-DRILL)
			 (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y))
		   (HAS-HOLE ?PART ?HOLE ?SIDE ?HOLE-DEPTH ?HOLE-DIAMETER 
			     ?LOC-X ?LOC-Y)))
  
  (:operator DRILL-WITH-HIGH-HELIX-DRILL
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?HOLE-DEPTH ?HOLE-DIAMETER ?LOC-Y ?LOC-X ?FLUID
			    ?DRILL-BIT-DIAMETER)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE DRILL)
			 (EQ ?DRILL-BIT-DIAMETER ?HOLE-DIAMETER)
			 (DIAMETER-OF-DRILL-BIT ?DRILL-BIT ?DRILL-BIT-DIAMETER)
			 (IS-A ?DRILL-BIT HIGH-HELIX-DRILL)
			 (HAS-FLUID ?MACHINE ?FLUID ?PART)
			 (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y))
		   (HAS-HOLE ?PART ?HOLE ?SIDE ?HOLE-DEPTH ?HOLE-DIAMETER 
			     ?LOC-X ?LOC-Y)))
  
  (:operator DRILL-WITH-STRAIGHT-FLUTED-DRILL
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?HOLE-DEPTH ?HOLE-DIAMETER ?LOC-Y ?LOC-X 
			    ?DRILL-BIT-DIAMETER)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE DRILL)
			 (EQ ?DRILL-BIT-DIAMETER ?HOLE-DIAMETER)
			 (DIAMETER-OF-DRILL-BIT ?DRILL-BIT ?DRILL-BIT-DIAMETER)
			 (IS-A ?DRILL-BIT STRAIGHT-FLUTED-DRILL)
			 (SMALLER ?HOLE-DEPTH 2)
			 (MATERIAL-OF ?PART BRASS)
			 (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y))
		   (HAS-HOLE ?PART ?HOLE ?SIDE ?HOLE-DEPTH ?HOLE-DIAMETER 
			     ?LOC-X ?LOC-Y)))
  
  (:operator DRILL-WITH-OIL-HOLE-DRILL
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?HOLE-DEPTH ?HOLE-DIAMETER ?LOC-Y ?LOC-X ?FLUID
			    ?DRILL-BIT-DIAMETER)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE DRILL)
			 (EQ ?DRILL-BIT-DIAMETER ?HOLE-DIAMETER)
			 (DIAMETER-OF-DRILL-BIT ?DRILL-BIT ?DRILL-BIT-DIAMETER)
			 (IS-A ?DRILL-BIT OIL-HOLE-DRILL) 
			 (SMALLER ?HOLE-DEPTH 20)
			 (HAS-FLUID ?MACHINE ?FLUID ?PART)
			 (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y))
		   (HAS-HOLE ?PART ?HOLE ?SIDE ?HOLE-DEPTH ?HOLE-DIAMETER 
			     ?LOC-X ?LOC-Y)))
  
  (:operator DRILL-WITH-GUN-DRILL
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?HOLE-DEPTH ?HOLE-DIAMETER ?LOC-Y ?LOC-X ?FLUID
			    ?DRILL-BIT-DIAMETER)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE DRILL)
			 (EQ ?DRILL-BIT-DIAMETER ?HOLE-DIAMETER)
			 (DIAMETER-OF-DRILL-BIT ?DRILL-BIT ?DRILL-BIT-DIAMETER)
			 (IS-A ?DRILL-BIT GUN-DRILL)
			 (HAS-FLUID ?MACHINE ?FLUID ?PART)
			 (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART)) 
		   (HAS-BURRS ?PART)
		   (NOT (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y))
		   (HAS-HOLE ?PART ?HOLE ?SIDE ?HOLE-DEPTH ?HOLE-DIAMETER 
			     ?LOC-X ?LOC-Y)))
  
  (:operator DRILL-WITH-CENTER-DRILL
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?DRILL-BIT-DIAMETER ?LOC-X ?LOC-Y ?HOLE-DIAMETER)
      :precondition (AND (IS-A ?PART PART) 
			 (IS-A ?MACHINE DRILL)
			 (DIAMETER-OF-DRILL-BIT ?DRILL-BIT ?DRILL-BIT-DIAMETER)
			 (EQ ?DRILL-BIT-DIAMETER ?HOLE-DIAMETER)
			 (IS-A ?DRILL-BIT CENTER-DRILL)
			 (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y))
		   (HAS-HOLE ?PART ?HOLE ?SIDE 1/8 ?HOLE-DIAMETER ?LOC-X 
			     ?LOC-Y)
		   (HAS-CENTER-HOLE ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y)))
  
  (:operator TAP
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?LOC-Y ?LOC-X ?HOLE-DIAMETER ?HOLE-DEPTH
			    ?DRILL-BIT-DIAMETER)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE DRILL)
			 (EQ ?DRILL-BIT-DIAMETER ?HOLE-DIAMETER)
			 (DIAMETER-OF-DRILL-BIT ?DRILL-BIT ?DRILL-BIT-DIAMETER)
			 (IS-A ?DRILL-BIT TAP)
			 (HAS-HOLE ?PART ?HOLE ?SIDE ?HOLE-DEPTH 
				   ?HOLE-DIAMETER ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (WHEN (IS-REAMED ?PART ?HOLE ?SIDE ?HOLE-DEPTH 
				    ?HOLE-DIAMETER ?LOC-X ?LOC-Y)
			 (NOT (IS-REAMED ?PART ?HOLE ?SIDE ?HOLE-DEPTH 
					 ?HOLE-DIAMETER ?LOC-X ?LOC-Y)))
		   (IS-TAPPED ?PART ?HOLE ?SIDE ?HOLE-DEPTH ?HOLE-DIAMETER 
			      ?LOC-X ?LOC-Y)))
  
  (:operator COUNTERSINK
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?LOC-Y ?LOC-X ?HOLE-DIAMETER ?HOLE-DEPTH ?ANGLE)
      :precondition (AND (IS-A ?PART PART) 
			 (IS-A ?MACHINE DRILL)
			 (ANGLE-OF-DRILL-BIT ?DRILL-BIT ?ANGLE)
			 (IS-A ?DRILL-BIT COUNTERSINK)
			 (HAS-HOLE ?PART ?HOLE ?SIDE ?HOLE-DEPTH
				   ?HOLE-DIAMETER ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (IS-COUNTERSINKED ?PART ?HOLE ?SIDE ?HOLE-DEPTH 
				     ?HOLE-DIAMETER ?LOC-X ?LOC-Y ?ANGLE)))
  
  (:operator COUNTERBORE
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?LOC-Y ?LOC-X ?HOLE-DIAMETER ?HOLE-DEPTH
			    ?COUNTERBORE-SIZE)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE DRILL)
			 (SIZE-OF-DRILL-BIT ?DRILL-BIT ?COUNTERBORE-SIZE)
			 (IS-A ?DRILL-BIT COUNTERBORE)
			 (HAS-HOLE ?PART ?HOLE ?SIDE ?HOLE-DEPTH 
				   ?HOLE-DIAMETER ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (IS-COUNTERBORED ?PART ?HOLE ?SIDE ?HOLE-DEPTH 
				    ?HOLE-DIAMETER ?LOC-X ?LOC-Y 
				    ?COUNTERBORE-SIZE)))
  
  (:operator REAM
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?HOLE-DEPTH ?HOLE-DIAMETER ?LOC-Y ?LOC-X ?FLUID
			    ?DRILL-BIT-DIAMETER)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE DRILL)
			 (EQ ?DRILL-BIT-DIAMETER ?HOLE-DIAMETER)
			 (DIAMETER-OF-DRILL-BIT ?DRILL-BIT ?DRILL-BIT-DIAMETER)
			 (IS-A ?DRILL-BIT REAMER)
			 (SMALLER ?HOLE-DEPTH 2)
			 (HAS-FLUID ?MACHINE ?FLUID ?PART)
			 (HAS-HOLE ?PART ?HOLE ?SIDE ?HOLE-DEPTH 
				   ?HOLE-DIAMETER ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (WHEN (IS-TAPPED ?PART ?HOLE ?SIDE ?HOLE-DEPTH 
				    ?HOLE-DIAMETER ?LOC-X ?LOC-Y)
			 (NOT (IS-TAPPED ?PART ?HOLE ?SIDE ?HOLE-DEPTH 
					 ?HOLE-DIAMETER ?LOC-X ?LOC-Y)))
		   (IS-REAMED ?PART ?HOLE ?SIDE ?HOLE-DEPTH ?HOLE-DIAMETER
			      ?LOC-X ?LOC-Y)))
  
  (:operator SIDE-MILL
      :parameters (?MACHINE ?PART ?MILLING-CUTTER ?HOLDING-DEVICE ?SIDE ?DIM
			    ?VALUE ?VALUE-OLD)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE MILLING-MACHINE)
			 (IS-OF-TYPE ?MILLING-CUTTER MILLING-CUTTER)
			 (OR (EQ ?DIM WIDTH) (EQ ?DIM LENGTH))
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (SMALLER ?VALUE ?VALUE-OLD)
			 (SMALLER-THAN-2IN ?VALUE-OLD ?VALUE)
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?MILLING-CUTTER)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-MILL) 
		   (SIZE-OF ?PART ?DIM ?VALUE)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))))
  
  (:operator FACE-MILL
      :parameters (?MACHINE ?PART ?MILLING-CUTTER ?HOLDING-DEVICE ?SIDE ?DIM
			    ?VALUE ?VALUE-OLD)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE MILLING-MACHINE) 
			 (IS-OF-TYPE ?MILLING-CUTTER MILLING-CUTTER)
			 (EQ ?DIM HEIGHT)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (SMALLER ?VALUE ?VALUE-OLD)
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?MILLING-CUTTER)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-MILL)
		   (SIZE-OF ?PART ?DIM ?VALUE)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))))
  
  (:operator DRILL-WITH-SPOT-DRILL-IN-MILLING-MACHINE
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE MILLING-MACHINE)
			 (IS-A ?DRILL-BIT SPOT-DRILL)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y)))
  
  (:operator DRILL-WITH-TWIST-DRILL-IN-MILLING-MACHINE
      :parameters (?MACHINE ?DRILL-BIT ?HOLDING-DEVICE ?PART ?HOLE ?SIDE
			    ?HOLE-DEPTH ?HOLE-DIAMETER ?LOC-Y ?LOC-X
			    ?DRILL-BIT-DIAMETER)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE MILLING-MACHINE)
			 (EQ ?DRILL-BIT-DIAMETER ?HOLE-DIAMETER)
			 (DIAMETER-OF-DRILL-BIT ?DRILL-BIT ?DRILL-BIT-DIAMETER)
			 (IS-A ?DRILL-BIT TWIST-DRILL)
			 (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y)
			 (HOLDING-TOOL ?MACHINE ?DRILL-BIT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (HAS-SPOT ?PART ?HOLE ?SIDE ?LOC-X ?LOC-Y))
		   (HAS-HOLE ?PART ?HOLE ?SIDE ?HOLE-DEPTH ?HOLE-DIAMETER 
			     ?LOC-X ?LOC-Y)))
  
  (:operator ROUGH-TURN-RECTANGULAR-PART
      :parameters (?MACHINE ?PART ?TOOLBIT ?HOLDING-DEVICE ?DIAMETER-NEW
			    ?SIDE ?W ?H)
      :precondition (AND (IS-A ?MACHINE LATHE)
			 (IS-A ?TOOLBIT ROUGH-TOOLBIT)
			 (SHAPE-OF ?PART RECTANGULAR)
			 (SIZE-OF ?PART HEIGHT ?H)
			 (SIZE-OF ?PART WIDTH ?W)
			 (SMALLER ?DIAMETER-NEW ?H)
			 (SMALLER ?DIAMETER-NEW ?W)
			 (HOLDING-TOOL ?MACHINE ?TOOLBIT)
			 (SIDE-UP-FOR-MACHINING DIAMETER ?SIDE)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SIZE-OF ?PART HEIGHT ?H))
		   (NOT (SIZE-OF ?PART WIDTH ?W))
		   (SIZE-OF ?PART DIAMETER ?DIAMETER-NEW)
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE1 ?*SURFACE-COATING))
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE2 ?*SURFACE-COATING))
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE4 ?*SURFACE-COATING))
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE5 ?*SURFACE-COATING))
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE0 ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART SIDE1 ?SF1))
		   (NOT (SURFACE-FINISH-SIDE ?PART SIDE2 ?SF2))
		   (NOT (SURFACE-FINISH-SIDE ?PART SIDE4 ?SF4))
		   (NOT (SURFACE-FINISH-SIDE ?PART SIDE5 ?SF5))
		   (SURFACE-FINISH-SIDE ?PART SIDE0 ROUGH-TURN)))
  
  (:operator ROUGH-TURN-CYLINDRICAL-PART
      :parameters (?MACHINE ?PART ?TOOLBIT ?HOLDING-DEVICE ?DIAMETER-NEW ?SIDE
			    ?DIAMETER)
      :precondition (AND (IS-A ?MACHINE LATHE)
			 (IS-A ?TOOLBIT ROUGH-TOOLBIT)
			 (SHAPE-OF ?PART CYLINDRICAL)
			 (SIZE-OF ?PART DIAMETER ?DIAMETER)
			 (SMALLER ?DIAMETER-NEW ?DIAMETER)
			 (HOLDING-TOOL ?MACHINE ?TOOLBIT)
			 (SIDE-UP-FOR-MACHINING DIAMETER ?SIDE)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SIZE-OF ?PART DIAMETER ?DIAMETER))
		   (SIZE-OF ?PART DIAMETER ?DIAMETER-NEW)
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE0 ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART SIDE0 ?SF))
		   (SURFACE-FINISH-SIDE ?PART SIDE0 ROUGH-TURN)))
  
  (:operator FINISH-TURN
      :parameters (?MACHINE ?PART ?TOOLBIT ?HOLDING-DEVICE ?DIAMETER-NEW
			    ?DIAMETER)
      :precondition (AND (IS-A ?MACHINE LATHE)
			 (IS-A ?TOOLBIT FINISH-TOOLBIT)
			 (SHAPE-OF ?PART CYLINDRICAL)
			 (SIZE-OF ?PART DIAMETER ?DIAMETER)
			 (FINISHING-SIZE ?DIAMETER ?DIAMETER-NEW)
			 (HOLDING-TOOL ?MACHINE ?TOOLBIT)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART SIDE0))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SIZE-OF ?PART DIAMETER ?DIAMETER))
		   (SIZE-OF ?PART DIAMETER ?DIAMETER-NEW)
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE0 ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART SIDE0 ?SF))
		   (SURFACE-FINISH-SIDE ?PART SIDE0 FINISH-TURN)))
  
  (:operator MAKE-THREAD-WITH-LATHE
      :parameters (?MACHINE ?PART ?HOLDING-DEVICE ?SIDE ?TOOLBIT)
      :precondition (AND (IS-A ?PART PART) 
			 (IS-A ?MACHINE LATHE)
			 (IS-A ?TOOLBIT V-THREAD)
			 (SHAPE-OF ?PART CYLINDRICAL)
			 (HOLDING-TOOL ?MACHINE ?TOOLBIT)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART SIDE0))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART) 
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE0 ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART SIDE0 ?SF))
		   (SURFACE-FINISH-SIDE ?PART SIDE0 TAPPED)))

  (:operator MAKE-KNURL-WITH-LATHE
      :parameters (?MACHINE ?PART ?HOLDING-DEVICE ?SIDE ?TOOLBIT)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE LATHE) 
			 (IS-A ?TOOLBIT KNURL)
			 (SHAPE-OF ?PART CYLINDRICAL)
			 (HOLDING-TOOL ?MACHINE ?TOOLBIT)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART SIDE0))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE0 ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART SIDE0 ?SF))
		   (SURFACE-FINISH-SIDE ?PART SIDE0 KNURLED)))
  
  (:operator FILE-WITH-LATHE
      :parameters (?MACHINE ?PART ?HOLDING-DEVICE ?LATHE-FILE ?DIAMETER-NEW
			    ?DIAMETER)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE LATHE)
			 (IS-A ?LATHE-FILE LATHE-FILE)
			 (SHAPE-OF ?PART CYLINDRICAL)
			 (SIZE-OF ?PART DIAMETER ?DIAMETER)
			 (FINISHING-SIZE ?DIAMETER ?DIAMETER-NEW)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART SIDE0))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SIZE-OF ?PART DIAMETER ?DIAMETER))
		   (SIZE-OF ?PART DIAMETER ?DIAMETER-NEW)
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE0 ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART SIDE0 ?SF))
		   (SURFACE-FINISH-SIDE ?PART SIDE0 ROUGH-GRIND)))
  
  (:operator POLISH-WITH-LATHE
      :parameters (?MACHINE ?PART ?HOLDING-DEVICE ?CLOTH ?DIAMETER-NEW)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE LATHE)
			 (IS-A ?CLOTH ABRASIVE-CLOTH)
			 (MATERIAL-OF-ABRASIVE-CLOTH ?CLOTH EMERY)
			 (SHAPE-OF ?PART CYLINDRICAL)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART SIDE0))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART SIDE0 ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART SIDE0 ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART SIDE0 POLISHED)))

  (:operator ROUGH-SHAPE
      :parameters (?MACHINE ?PART ?CUTTING-TOOL ?HOLDING-DEVICE ?SIDE ?DIM
			    ?VALUE ?VALUE-OLD)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE SHAPER)
			 (IS-A ?CUTTING-TOOL ROUGHING-CUTTING-TOOL)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (SMALLER ?VALUE ?VALUE-OLD)
			 (NOT (EQ ?DIM DIAMETER))
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?CUTTING-TOOL)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-SHAPED)
		   (SIZE-OF ?PART ?DIM ?VALUE)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))))

  (:operator FINISH-SHAPE
      :parameters (?MACHINE ?PART ?CUTTING-TOOL ?HOLDING-DEVICE ?SIDE ?DIM 
			    ?VALUE ?VALUE-OLD)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE SHAPER)
			 (IS-A ?CUTTING-TOOL FINISHING-CUTTING-TOOL)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (FINISHING-SIZE ?VALUE-OLD ?VALUE)
			 (NOT (EQ ?DIM DIAMETER))
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?CUTTING-TOOL)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE FINISH-SHAPED)
		   (SIZE-OF ?PART ?DIM ?VALUE)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))))

  (:operator ROUGH-SHAPE-WITH-PLANER
      :parameters (?MACHINE ?PART ?CUTTING-TOOL ?HOLDING-DEVICE ?SIDE ?DIM
			    ?VALUE ?VALUE-OLD)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE PLANER)
			 (IS-A ?CUTTING-TOOL ROUGHING-CUTTING-TOOL)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (SMALLER ?VALUE ?VALUE-OLD)
			 (NOT (EQ ?DIM DIAMETER))
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?CUTTING-TOOL)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-PLANED)
		   (SIZE-OF ?PART ?DIM ?VALUE)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))))

  (:operator FINISH-SHAPE-WITH-PLANER
      :parameters (?MACHINE ?PART ?CUTTING-TOOL ?HOLDING-DEVICE ?SIDE ?DIM
			    ?VALUE ?VALUE-OLD)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE PLANER)
			 (IS-A ?CUTTING-TOOL FINISHING-CUTTING-TOOL)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (FINISHING-SIZE ?VALUE-OLD ?VALUE)
			 (NOT (EQ ?DIM DIAMETER))
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?CUTTING-TOOL)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE FINISH-PLANED)
		   (SIZE-OF ?PART ?DIM ?VALUE)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))))

  (:operator ROUGH-GRIND-WITH-HARD-WHEEL
      :parameters (?MACHINE ?PART ?WHEEL ?HOLDING-DEVICE ?SIDE ?DIM ?VALUE
			    ?VALUE-OLD ?FLUID)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE GRINDER)
			 (IS-A ?WHEEL GRINDING-WHEEL)
			 (HAS-FLUID ?MACHINE ?FLUID ?PART)
			 (HARDNESS-OF-WHEEL ?WHEEL HARD)
			 (HARDNESS-OF ?PART SOFT)
			 (NOT (MATERIAL-OF ?PART BRONZE)) 
			 (NOT (MATERIAL-OF ?PART COPPER)) 
			 (GRIT-OF-WHEEL ?WHEEL COARSE-GRIT)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (SMALLER ?VALUE ?VALUE-OLD)
			 (NOT (EQ ?DIM DIAMETER))
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?WHEEL)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART)) 
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-GRIND) 
		   (SIZE-OF ?PART ?DIM ?VALUE)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))))
  
  (:operator ROUGH-GRIND-WITH-SOFT-WHEEL
      :parameters (?MACHINE ?PART ?WHEEL ?HOLDING-DEVICE ?SIDE ?DIM ?VALUE
			    ?VALUE-OLD ?FLUID)
      :precondition (AND (IS-A ?PART PART) 
			 (IS-A ?MACHINE GRINDER)
			 (IS-A ?WHEEL GRINDING-WHEEL)
			 (HAS-FLUID ?MACHINE ?FLUID ?PART)
			 (HARDNESS-OF-WHEEL ?WHEEL SOFT)
			 (HARDNESS-OF ?PART HARD)
			 (GRIT-OF-WHEEL ?WHEEL COARSE-GRIT)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (SMALLER ?VALUE ?VALUE-OLD)
			 (NOT (EQ ?DIM DIAMETER))
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?WHEEL)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART)) 
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-GRIND)
		   (SIZE-OF ?PART ?DIM ?VALUE)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))))
  
  (:operator FINISH-GRIND-WITH-HARD-WHEEL
      :parameters (?MACHINE ?PART ?WHEEL ?HOLDING-DEVICE ?SIDE ?DIM ?VALUE
			    ?VALUE-OLD ?FLUID)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE GRINDER)
			 (IS-A ?WHEEL GRINDING-WHEEL)
			 (HAS-FLUID ?MACHINE ?FLUID ?PART)
			 (HARDNESS-OF-WHEEL ?WHEEL HARD)
			 (HARDNESS-OF ?PART SOFT)
			 (NOT (MATERIAL-OF ?PART BRONZE))
			 (NOT (MATERIAL-OF ?PART COPPER))
			 (GRIT-OF-WHEEL ?WHEEL FINE-GRIT)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (FINISHING-SIZE ?VALUE-OLD ?VALUE)
			 (NOT (EQ ?DIM DIAMETER))
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?WHEEL)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE FINISH-GRIND)
		   (SIZE-OF ?PART ?DIM ?VALUE)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))))
  
  (:operator FINISH-GRIND-WITH-SOFT-WHEEL
      :parameters (?MACHINE ?PART ?WHEEL ?HOLDING-DEVICE ?SIDE ?DIM ?VALUE
			    ?VALUE-OLD ?FLUID)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE GRINDER)
			 (IS-A ?WHEEL GRINDING-WHEEL) 
			 (HAS-FLUID ?MACHINE ?FLUID ?PART)
			 (HARDNESS-OF-WHEEL ?WHEEL SOFT)
			 (HARDNESS-OF ?PART HARD)
			 (GRIT-OF-WHEEL ?WHEEL FINE-GRIT)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (FINISHING-SIZE ?VALUE-OLD ?VALUE)
			 (NOT (EQ ?DIM DIAMETER))
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?WHEEL)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE FINISH-GRIND)
		   (SIZE-OF ?PART ?DIM ?VALUE)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))))
  
  (:operator CUT-WITH-CIRCULAR-COLD-SAW
      :parameters (?MACHINE ?PART ?ATTACHMENT ?HOLDING-DEVICE ?DIM ?VALUE
			    ?SIDE ?VALUE-OLD)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE CIRCULAR-SAW)
			 (IS-A ?ATTACHMENT COLD-SAW)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (SMALLER ?VALUE ?VALUE-OLD)
			 (NOT (EQ ?DIM DIAMETER)) 
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?ATTACHMENT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE FINISH-MILL)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))
		   (SIZE-OF ?PART ?DIM ?VALUE)))
  
  (:operator CUT-WITH-CIRCULAR-FRICTION-SAW
      :parameters (?MACHINE ?PART ?ATTACHMENT ?HOLDING-DEVICE ?DIM ?VALUE
			    ?SIDE ?VALUE-OLD ?FLUID)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE CIRCULAR-SAW)
			 (IS-A ?ATTACHMENT FRICTION-SAW)
			 (HAS-FLUID ?MACHINE ?FLUID ?PART)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (SMALLER ?VALUE ?VALUE-OLD)
			 (NOT (EQ ?DIM DIAMETER))
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?ATTACHMENT)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-MILL)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))
		   (SIZE-OF ?PART ?DIM ?VALUE)))
  
  (:operator CUT-WITH-BAND-SAW
      :parameters (?MACHINE ?PART ?ATTACHMENT ?DIM ?VALUE ?SIDE ?VALUE-OLD)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE BAND-SAW)
			 (IS-A ?ATTACHMENT BAND-FILE)
			 (SIZE-OF ?PART ?DIM ?VALUE-OLD)
			 (SMALLER ?VALUE ?VALUE-OLD)
			 (NOT (EQ ?DIM DIAMETER))
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?ATTACHMENT)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (ON-TABLE ?MACHINE ?PART))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*S-Q))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE SAWCUT)
		   (NOT (SIZE-OF ?PART ?DIM ?VALUE-OLD))
		   (SIZE-OF ?PART ?DIM ?VALUE)))
  
  (:operator POLISH-WITH-BAND-SAW
      :parameters (?MACHINE ?PART ?ATTACHMENT ?SIDE ?DIM)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE BAND-SAW)
			 (IS-A ?ATTACHMENT SAW-BAND)
			 (SIDE-UP-FOR-MACHINING ?DIM ?SIDE)
			 (HOLDING-TOOL ?MACHINE ?ATTACHMENT)
			 (NOT (HAS-BURRS ?PART)) 
			 (IS-CLEAN ?PART) 
			 (ON-TABLE ?MACHINE ?PART))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (HAS-BURRS ?PART)
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE ?*SURFACE-COATING))
		   (NOT (SURFACE-FINISH-SIDE ?PART ?SIDE ?*OLD-SF-COND))
		   (SURFACE-FINISH-SIDE ?PART ?SIDE POLISHED)))
  
  (:operator WELD-CYLINDERS-METAL-ARC
      :parameters (?MACHINE ?PART1 ?PART2 ?PART ?ELECTRODE ?HOLDING-DEVICE
			    ?LENGTH ?MATERIAL2 ?MATERIAL1 ?MATERIAL ?LENGTH2
			    ?LENGTH1 ?DIAMETER2 ?DIAMETER1)
      :precondition (AND (IS-A ?PART1 PART) 
			 (IS-A ?PART2 PART)
			 (NOT (EQ ?PART1 ?PART2))
			 (IS-A ?MACHINE METAL-ARC-WELDER)
			 (IS-A ?ELECTRODE ELECTRODE)
			 (MATERIAL-OF ?PART1 ?MATERIAL1)
			 (MATERIAL-OF ?PART2 ?MATERIAL2)
			 (SHAPE-OF ?PART1 CYLINDRICAL)
			 (SHAPE-OF ?PART2 CYLINDRICAL)
			 (NOT (EXISTS (HAS-HOLE ?PART1 ?HOLE ?*SIDE ?*DEPTH 
						?*DIAMETER ?*LOC-X ?*LOC-Y)))
			 (NOT (EXISTS (HAS-HOLE ?PART2 ?HOLE ?*SIDE ?*DEPTH 
						?*DIAMETER ?*LOC-X ?*LOC-Y)))
			 (SIZE-OF ?PART1 DIAMETER ?DIAMETER1)
			 (SIZE-OF ?PART2 DIAMETER ?DIAMETER2)
			 (EQ ?DIAMETER1 ?DIAMETER2)
			 (SIZE-OF ?PART1 LENGTH ?LENGTH1)
			 (SIZE-OF ?PART2 LENGTH ?LENGTH2)
			 (NEW-SIZE ?LENGTH1 ?LENGTH2 ?LENGTH)
			 (NEW-PART ?PART ?PART1 ?PART2)
			 (NEW-MATERIAL ?MATERIAL ?MATERIAL1 ?MATERIAL2)
			 (HOLDING-TOOL ?MACHINE ?ELECTRODE)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART2 SIDE3))
      :effect (AND (NOT (IS-A ?PART1 PART))
		   (NOT (IS-A ?PART2 PART))
		   (IS-A ?PART PART)
		   (MATERIAL-OF ?PART ?MATERIAL)
		   (SIZE-OF ?PART DIAMETER ?DIAMETER1)
		   (SIZE-OF ?PART LENGTH ?LENGTH)
		   (SURFACE-FINISH-SIDE ?PART SIDE0 SAWCUT)
		   (FORALL (?SF31)
			   (WHEN (SURFACE-FINISH-SIDE ?PART1 SIDE3 ?SF31)
				 (SURFACE-FINISH-SIDE ?PART SIDE3 ?SF31)))
		   (FORALL (?SF62)
			   (WHEN (SURFACE-FINISH-SIDE ?PART2 SIDE6 ?SF62)
				 (SURFACE-FINISH-SIDE ?PART SIDE6 ?SF62)))
		   (NOT (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART2 SIDE3))
		   (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART SIDE3)
		   (NOT (SIZE-OF ?PART1 DIAMETER ?DIAMETER))
		   (NOT (SIZE-OF ?PART1 LENGTH ?LENGTH1))
		   (NOT (SIZE-OF ?PART2 DIAMETER ?DIAMETER))
		   (NOT (SIZE-OF ?PART2 LENGTH ?LENGTH2))
		   (NOT (MATERIAL-OF ?PART1 ?MATERIAL1))
		   (NOT (MATERIAL-OF ?PART2 ?MATERIAL2))
		   (NOT (IS-CLEAN ?PART1))
		   (NOT (IS-CLEAN ?PART2))
		   (FORALL (?*SIDEA ?*SURF-COATINGA)
			   (NOT (SURFACE-COATING-SIDE ?PART1 ?*SIDEA 
						      ?*SURF-COATINGA)))
		   (FORALL (?*SIDEB ?*SURF-COATINGB)
			   (NOT (SURFACE-COATING-SIDE ?PART2 ?*SIDEB 
						      ?*SURF-COATINGB)))
		   (FORALL (?*SIDEC ?*SFC)
			   (NOT (SURFACE-FINISH-SIDE ?PART1 ?*SIDEC ?*SFC)))
		   (FORALL (?*SIDED ?*SFD)
			   (NOT (SURFACE-FINISH-SIDE ?PART2 ?*SIDED ?*SFD)))))
  
  (:operator WELD-CYLINDERS-GAS
      :parameters (?MACHINE ?PART1 ?PART2 ?PART ?ROD ?HOLDING-DEVICE ?LENGTH
			    ?LENGTH2 ?LENGTH1 ?DIAMETER2 ?DIAMETER1 ?MATERIAL2
			    ?MATERIAL1 ?TORCH)
      :precondition (AND (IS-A ?PART1 PART)
			 (IS-A ?PART2 PART)
			 (NOT (EQ ?PART1 ?PART2))
			 (IS-A ?MACHINE GAS-WELDER)
			 (IS-A ?ROD WELDING-ROD)
			 (IS-A ?TORCH TORCH)
			 (MATERIAL-OF ?PART1 ?MATERIAL1)
			 (MATERIAL-OF ?PART2 ?MATERIAL2)
			 (EQ ?MATERIAL1 ?MATERIAL2)
			 (SHAPE-OF ?PART1 CYLINDRICAL)
			 (SHAPE-OF ?PART2 CYLINDRICAL)
			 (NOT (EXISTS (HAS-HOLE ?PART1 ?HOLE ?*SIDE ?*DEPTH 
						?*DIAMETER ?*LOC-X ?*LOC-Y)))
			 (NOT (EXISTS (HAS-HOLE ?PART2 ?HOLE ?*SIDE ?*DEPTH 
						?*DIAMETER ?*LOC-X ?*LOC-Y)))
			 (SIZE-OF ?PART1 DIAMETER ?DIAMETER1)
			 (SIZE-OF ?PART2 DIAMETER ?DIAMETER2)
			 (EQ ?DIAMETER1 ?DIAMETER2)
			 (SIZE-OF ?PART1 LENGTH ?LENGTH1)
			 (SIZE-OF ?PART2 LENGTH ?LENGTH2)
			 (NEW-SIZE ?LENGTH1 ?LENGTH2 ?LENGTH)
			 (NEW-PART ?PART ?PART1 ?PART2)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART2 SIDE3))
      :effect (AND (NOT (IS-A ?PART1 PART))
		   (NOT (IS-A ?PART2 PART))
		   (IS-A ?PART PART)
		   (MATERIAL-OF ?PART ?MATERIAL1)
		   (SIZE-OF ?PART DIAMETER ?DIAMETER1)
		   (SIZE-OF ?PART LENGTH ?LENGTH)
		   (SURFACE-FINISH-SIDE ?PART SIDE0 SAWCUT)
		   (FORALL (?SF31)
			   (WHEN (SURFACE-FINISH-SIDE ?PART1 SIDE3 ?SF31)
				 (SURFACE-FINISH-SIDE ?PART SIDE3 ?SF31)))
		   (FORALL (?SF62) 
			   (WHEN (SURFACE-FINISH-SIDE ?PART2 SIDE6 ?SF62)
				 (SURFACE-FINISH-SIDE ?PART SIDE6 ?SF62)))
		   (NOT (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART2 SIDE3))
		   (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART SIDE3)
		   (NOT (SIZE-OF ?PART1 DIAMETER ?DIAMETER))
		   (NOT (SIZE-OF ?PART1 LENGTH ?LENGTH1))
		   (NOT (SIZE-OF ?PART2 DIAMETER ?DIAMETER))
		   (NOT (SIZE-OF ?PART2 LENGTH ?LENGTH2))
		   (NOT (MATERIAL-OF ?PART1 ?MATERIAL1))
		   (NOT (MATERIAL-OF ?PART2 ?MATERIAL2))
		   (NOT (IS-CLEAN ?PART1))
		   (NOT (IS-CLEAN ?PART2))
		   (FORALL (?*SIDEA ?*SURF-COATINGA)
			   (NOT (SURFACE-COATING-SIDE ?PART1 ?*SIDEA 
						      ?*SURF-COATINGA)))
		   (FORALL (?*SIDEB ?*SURF-COATINGB)
			   (NOT (SURFACE-COATING-SIDE ?PART2 ?*SIDEB 
						      ?*SURF-COATINGB)))
		   (FORALL (?*SIDEC ?*SFC)
			   (NOT (SURFACE-FINISH-SIDE ?PART1 ?*SIDEC ?*SFC)))
		   (FORALL (?*SIDED ?*SFD)
			   (NOT (SURFACE-FINISH-SIDE ?PART2 ?*SIDED ?*SFD)))))
  
  (:operator METAL-SPRAY-COATING
      :parameters (?MACHINE ?WIRE ?PART ?SIDE ?ANOTHER-MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE ELECTRIC-ARC-SPRAY-GUN)
			 (IS-A ?WIRE SPRAYING-METAL-WIRE)
			 (NOT (MATERIAL-OF ?WIRE TUNGSTEN))
			 (NOT (MATERIAL-OF ?WIRE MOLYBDENUM))
			 (IS-CLEAN ?PART)
			 (NOT (HAS-BURRS ?PART))
			 (SURFACE-COATING-SIDE ?PART ?SIDE FUSED-METAL)
			 (IS-OF-TYPE ?ANOTHER-MACHINE MACHINE)
			 (HOLDING ?ANOTHER-MACHINE ?HOLDING-DEVICE ?PART 
				  ?SIDE))
      :effect (AND (WHEN (MATERIAL-OF ?WIRE STAINLESS-STEEL)
			 (SURFACE-COATING-SIDE ?PART ?SIDE 
					       CORROSION-RESISTANT))
		   (WHEN (MATERIAL-OF ?WIRE ZIRCONIUM-OXIDE)
			 (SURFACE-COATING-SIDE ?PART ?SIDE HEAT-RESISTANT))
		   (WHEN (MATERIAL-OF ?WIRE ALUMINUM-OXIDE)
			 (SURFACE-COATING-SIDE ?PART ?SIDE WEAR-RESISTANT)) 
		   (NOT (SURFACE-COATING-SIDE ?PART ?SIDE FUSED-METAL))))
  
  (:operator METAL-SPRAY-PREPARE
      :parameters (?MACHINE ?WIRE ?PART ?SIDE ?ANOTHER-MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE ELECTRIC-ARC-SPRAY-GUN)
			 (IS-A ?WIRE SPRAYING-METAL-WIRE)
			 (HAS-HIGH-MELTING-POINT ?WIRE) 
			 (IS-CLEAN ?PART)
			 (NOT (HAS-BURRS ?PART))
			 (IS-OF-TYPE ?ANOTHER-MACHINE MACHINE)
			 (HOLDING ?ANOTHER-MACHINE ?HOLDING-DEVICE ?PART 
				  ?SIDE))
      :effect (AND (SURFACE-COATING-SIDE ?PART ?SIDE FUSED-METAL)))
  
  (:operator CLEAN
      :parameters (?PART)
      :precondition (AND (IS-A ?PART PART)
			 (IS-AVAILABLE-PART ?PART))
      :effect (AND (IS-CLEAN ?PART)))
  
  (:operator REMOVE-BURRS
      :parameters (?PART ?BRUSH)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?BRUSH BRUSH)
			 (IS-AVAILABLE-PART ?PART))
      :effect (AND (NOT (IS-CLEAN ?PART))
		   (NOT (HAS-BURRS ?PART))))
  
  (:operator PUT-TOOL-ON-MILLING-MACHINE
      :parameters (?MACHINE ?ATTACHMENT)
      :precondition (AND (IS-A ?MACHINE MILLING-MACHINE)
			 (OR (IS-OF-TYPE ?ATTACHMENT MILLING-CUTTER)
			     (IS-OF-TYPE ?ATTACHMENT DRILL-BIT))
			 (IS-AVAILABLE-TOOL-HOLDER ?MACHINE)
			 (IS-AVAILABLE-TOOL ?ATTACHMENT))
      :effect (AND (HOLDING-TOOL ?MACHINE ?ATTACHMENT)))
  
  (:operator PUT-IN-DRILL-SPINDLE
      :parameters (?MACHINE ?DRILL-BIT)
      :precondition (AND (IS-A ?MACHINE DRILL)
			 (IS-OF-TYPE ?DRILL-BIT DRILL-BIT)
			 (IS-AVAILABLE-TOOL-HOLDER ?MACHINE)
			 (IS-AVAILABLE-TOOL ?DRILL-BIT))
      :effect (AND (HOLDING-TOOL ?MACHINE ?DRILL-BIT)))
  
  (:operator PUT-TOOLBIT-IN-LATHE
      :parameters (?MACHINE ?TOOLBIT)
      :precondition (AND (IS-A ?MACHINE LATHE)
			 (IS-OF-TYPE ?TOOLBIT LATHE-TOOLBIT)
			 (IS-AVAILABLE-TOOL-HOLDER ?MACHINE)
			 (IS-AVAILABLE-TOOL ?TOOLBIT))
      :effect (AND (HOLDING-TOOL ?MACHINE ?TOOLBIT)))
  
  (:operator PUT-CUTTING-TOOL-IN-SHAPER-OR-PLANER
      :parameters (?MACHINE ?CUTTING-TOOL)
      :precondition (AND (OR (IS-A ?MACHINE SHAPER)
			     (IS-A ?MACHINE PLANER))
			 (IS-OF-TYPE ?CUTTING-TOOL CUTTING-TOOL)
			 (IS-AVAILABLE-TOOL-HOLDER ?MACHINE)
			 (IS-AVAILABLE-TOOL ?CUTTING-TOOL))
      :effect (AND (HOLDING-TOOL ?MACHINE ?CUTTING-TOOL)))
  
  (:operator PUT-WHEEL-IN-GRINDER
      :parameters (?MACHINE ?WHEEL)
      :precondition (AND (IS-A ?MACHINE GRINDER)
			 (IS-A ?WHEEL GRINDING-WHEEL)
			 (IS-AVAILABLE-TOOL-HOLDER ?MACHINE)
			 (IS-AVAILABLE-TOOL ?WHEEL))
      :effect (AND (HOLDING-TOOL ?MACHINE ?WHEEL)))
  
  (:operator PUT-CIRCULAR-SAW-ATTACHMENT-IN-CIRCULAR-SAW
      :parameters (?MACHINE ?ATTACHMENT)
      :precondition (AND (IS-A ?MACHINE CIRCULAR-SAW)
			 (IS-OF-TYPE ?ATTACHMENT CIRCULAR-SAW-ATTACHMENT)
			 (IS-AVAILABLE-TOOL-HOLDER ?MACHINE)
			 (IS-AVAILABLE-TOOL ?ATTACHMENT))
      :effect (AND (HOLDING-TOOL ?MACHINE ?ATTACHMENT)))
  
  (:operator PUT-BAND-SAW-ATTACHMENT-IN-BAND-SAW
      :parameters (?MACHINE ?ATTACHMENT)
      :precondition (AND (IS-A ?MACHINE BAND-SAW)
			 (IS-OF-TYPE ?ATTACHMENT BAND-SAW-ATTACHMENT)
			 (IS-AVAILABLE-TOOL-HOLDER ?MACHINE)
			 (IS-AVAILABLE-TOOL ?ATTACHMENT))
      :effect (AND (HOLDING-TOOL ?MACHINE ?ATTACHMENT)))
  
  (:operator PUT-ELECTRODE-IN-WELDER
      :parameters (?MACHINE ?ELECTRODE)
      :precondition (AND (IS-A ?MACHINE METAL-ARC-WELDER)
			 (IS-A ?ELECTRODE ELECTRODE)
			 (IS-AVAILABLE-TOOL-HOLDER ?MACHINE)
			 (IS-AVAILABLE-TOOL ?ELECTRODE))
      :effect (AND (HOLDING-TOOL ?MACHINE ?ELECTRODE)))
  
  (:operator REMOVE-TOOL-FROM-MACHINE
      :parameters (?MACHINE ?TOOL)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-OF-TYPE ?TOOL MACHINE-TOOL)
			 (HOLDING-TOOL ?MACHINE ?TOOL))
      :effect (AND (NOT (HOLDING-TOOL ?MACHINE ?TOOL))))
  
  (:operator PUT-HOLDING-DEVICE-IN-MILLING-MACHINE
      :parameters (?MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-A ?MACHINE MILLING-MACHINE)
			 (OR (IS-A ?HOLDING-DEVICE 4-JAW-CHUCK)
			     (IS-A ?HOLDING-DEVICE V-BLOCK)
			     (IS-A ?HOLDING-DEVICE VISE)
			     (IS-A ?HOLDING-DEVICE COLLET-CHUCK)
			     (IS-A ?HOLDING-DEVICE TOE-CLAMP))
			 (IS-AVAILABLE-TABLE ?MACHINE ?HOLDING-DEVICE)
			 (IS-AVAILABLE-HOLDING-DEVICE ?HOLDING-DEVICE))
      :effect (AND (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)))
  
  (:operator PUT-HOLDING-DEVICE-IN-DRILL
      :parameters (?MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-A ?MACHINE DRILL)
			 (OR (IS-A ?HOLDING-DEVICE 4-JAW-CHUCK)
			     (IS-A ?HOLDING-DEVICE V-BLOCK)
			     (IS-A ?HOLDING-DEVICE VISE)
			     (IS-A ?HOLDING-DEVICE TOE-CLAMP))
			 (IS-AVAILABLE-TABLE ?MACHINE ?HOLDING-DEVICE)
			 (IS-AVAILABLE-HOLDING-DEVICE ?HOLDING-DEVICE))
      :effect (AND (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)))
  
  (define (operator PUT-HOLDING-DEVICE-IN-LATHE)
      :parameters (?MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-A ?MACHINE LATHE)
			 (OR (IS-A ?HOLDING-DEVICE CENTERS)
			     (IS-A ?HOLDING-DEVICE 4-JAW-CHUCK)
			     (IS-A ?HOLDING-DEVICE COLLET-CHUCK))
			 (IS-AVAILABLE-TABLE ?MACHINE ?HOLDING-DEVICE)
			 (IS-AVAILABLE-HOLDING-DEVICE ?HOLDING-DEVICE))
      :effect (AND (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)))
  
  (:operator PUT-HOLDING-DEVICE-IN-SHAPER
      :parameters (?MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-A ?MACHINE SHAPER)
			 (IS-A ?HOLDING-DEVICE VISE)
			 (IS-AVAILABLE-TABLE ?MACHINE ?HOLDING-DEVICE)
			 (IS-AVAILABLE-HOLDING-DEVICE ?HOLDING-DEVICE))
      :effect (AND (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)))
  
  (:operator PUT-HOLDING-DEVICE-IN-PLANER
      :parameters (?MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-A ?MACHINE PLANER)
			 (IS-A ?HOLDING-DEVICE TOE-CLAMP)
			 (IS-AVAILABLE-TABLE ?MACHINE ?HOLDING-DEVICE)
			 (IS-AVAILABLE-HOLDING-DEVICE ?HOLDING-DEVICE))
      :effect (AND (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)))
  
  (:operator PUT-HOLDING-DEVICE-IN-GRINDER
      :parameters (?MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-A ?MACHINE GRINDER)
			 (OR (IS-A ?HOLDING-DEVICE MAGNETIC-CHUCK)
			     (IS-A ?HOLDING-DEVICE V-BLOCK)
			     (IS-A ?HOLDING-DEVICE VISE))
			 (IS-AVAILABLE-TABLE ?MACHINE ?HOLDING-DEVICE)
			 (IS-AVAILABLE-HOLDING-DEVICE ?HOLDING-DEVICE))
      :effect (AND (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)))
  
  (:operator PUT-HOLDING-DEVICE-IN-CIRCULAR-SAW
      :parameters (?MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-A ?MACHINE CIRCULAR-SAW)
			 (OR (IS-A ?HOLDING-DEVICE VISE)
			     (IS-A ?HOLDING-DEVICE V-BLOCK))
			 (IS-AVAILABLE-TABLE ?MACHINE ?HOLDING-DEVICE)
			 (IS-AVAILABLE-HOLDING-DEVICE ?HOLDING-DEVICE))
      :effect (AND (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)))
  
  (:operator PUT-HOLDING-DEVICE-IN-WELDER
      :parameters (?MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-OF-TYPE ?MACHINE WELDER)
			 (OR (IS-A ?HOLDING-DEVICE VISE)
			     (IS-A ?HOLDING-DEVICE TOE-CLAMP))
			 (IS-AVAILABLE-TABLE ?MACHINE ?HOLDING-DEVICE)
			 (IS-AVAILABLE-HOLDING-DEVICE ?HOLDING-DEVICE))
      :effect (AND (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)))
  
  (:operator REMOVE-HOLDING-DEVICE-FROM-MACHINE
      :parameters (?MACHINE ?HOLDING-DEVICE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-OF-TYPE ?HOLDING-DEVICE HOLDING-DEVICE)
			 (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)
			 (IS-EMPTY-HOLDING-DEVICE ?HOLDING-DEVICE ?MACHINE))
      :effect (AND (NOT (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE))))
  
  (:operator ADD-SOLUBLE-OIL
      :parameters (?MACHINE ?FLUID ?PART)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (OR (MATERIAL-OF ?PART STEEL)
			     (MATERIAL-OF ?PART ALUMINUM))
			 (IS-A ?FLUID SOLUBLE-OIL))
      :effect (AND (HAS-FLUID ?MACHINE ?FLUID ?PART)))
  
  (:operator ADD-MINERAL-OIL
      :parameters (?MACHINE ?FLUID ?PART)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-A ?FLUID MINERAL-OIL)
			 (MATERIAL-OF ?PART IRON))
      :effect (AND (HAS-FLUID ?MACHINE ?FLUID ?PART)))
  
  (:operator ADD-ANY-CUTTING-FLUID
      :parameters (?MACHINE ?FLUID ?PART)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (OR (MATERIAL-OF ?PART BRASS)
			     (MATERIAL-OF ?PART BRONZE)
			     (MATERIAL-OF ?PART COPPER))
			 (IS-OF-TYPE ?FLUID CUTTING-FLUID))
      :effect (AND (HAS-FLUID ?MACHINE ?FLUID ?PART)))
  
  (:operator PUT-ON-MACHINE-TABLE
      :parameters (?MACHINE ?PART)
      :precondition (AND (IS-A ?PART PART)
			 (IS-OF-TYPE ?MACHINE MACHINE)
			 (NOT (IS-A ?MACHINE SHAPER))
			 (IS-AVAILABLE-PART ?PART)
			 (IS-AVAILABLE-MACHINE ?MACHINE))
      :effect (AND (NOT (ON-TABLE ?ANOTHER-MACHINE ?PART))
		   (ON-TABLE ?MACHINE ?PART)))
  
  (:operator PUT-ON-SHAPER-TABLE
      :parameters (?MACHINE ?PART ?SHAPER-SIZE ?PART-SIZE)
      :precondition (AND (IS-A ?PART PART)
			 (IS-A ?MACHINE SHAPER)
			 (SIZE-OF-MACHINE ?MACHINE ?SHAPER-SIZE)
			 (SIZE-OF ?PART LENGTH ?PART-SIZE)
			 (SMALLER ?PART-SIZE ?SHAPER-SIZE)
			 (IS-AVAILABLE-PART ?PART) 
			 (IS-AVAILABLE-MACHINE ?MACHINE))
      :effect (AND (NOT (ON-TABLE ?ANOTHER-MACHINE ?PART))
		   (ON-TABLE ?MACHINE ?PART)))
  
  (:operator HOLD-WITH-V-BLOCK
      :parameters (?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-A ?HOLDING-DEVICE V-BLOCK)
			 (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (ON-TABLE ?MACHINE ?PART)
			 (SHAPE-OF ?PART CYLINDRICAL)
			 (EQ ?SIDE SIDE0) 
			 (IS-EMPTY-HOLDING-DEVICE ?HOLDING-DEVICE ?MACHINE)
			 (IS-AVAILABLE-PART ?PART))
      :effect (AND (NOT (ON-TABLE ?MACHINE ?PART)) 
		   (HOLDING-WEAKLY ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)))
  
  (:operator HOLD-WITH-VISE
      :parameters (?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-A ?HOLDING-DEVICE VISE) 
			 (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (ON-TABLE ?MACHINE ?PART)
			 (IS-EMPTY-HOLDING-DEVICE ?HOLDING-DEVICE ?MACHINE)
			 (IS-AVAILABLE-PART ?PART))
      :effect (AND (NOT (ON-TABLE ?MACHINE ?PART))
		   (WHEN (SHAPE-OF ?PART CYLINDRICAL)
			 (HOLDING-WEAKLY ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
		   (WHEN (SHAPE-OF ?PART RECTANGULAR)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))))
  
  (:operator HOLD-WITH-TOE-CLAMP
      :parameters (?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-A ?HOLDING-DEVICE TOE-CLAMP) 
			 (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (OR (SHAPE-OF ?PART RECTANGULAR)
			     (EQ ?SIDE SIDE3)
			     (EQ ?SIDE SIDE6))
			 (ON-TABLE ?MACHINE ?PART)
			 (IS-EMPTY-HOLDING-DEVICE ?HOLDING-DEVICE ?MACHINE)
			 (IS-AVAILABLE-PART ?PART))
      :effect (AND (NOT (ON-TABLE ?MACHINE ?PART))
		   (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)))
  
  (:operator SECURE-WITH-TOE-CLAMP
      :parameters (?MACHINE ?HOLDING-DEVICE ?PART ?SIDE 
			    ?ANOTHER-HOLDING-DEVICE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-A ?HOLDING-DEVICE TOE-CLAMP)
			 (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (SHAPE-OF ?PART CYLINDRICAL)
			 (HOLDING-WEAKLY ?MACHINE ?ANOTHER-HOLDING-DEVICE 
					 ?PART ?SIDE)
			 (IS-EMPTY-HOLDING-DEVICE ?HOLDING-DEVICE ?MACHINE))
      :effect (AND (NOT (ON-TABLE ?MACHINE ?PART))
		   (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)))
  
  (:operator HOLD-WITH-CENTERS
      :parameters (?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-A ?HOLDING-DEVICE CENTERS)
			 (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)
			 (HAS-CENTER-HOLES ?PART)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (ON-TABLE ?MACHINE ?PART)
			 (SHAPE-OF ?PART CYLINDRICAL)
			 (IS-EMPTY-HOLDING-DEVICE ?HOLDING-DEVICE ?MACHINE)
			 (IS-AVAILABLE-PART ?PART))
      :effect (AND (NOT (ON-TABLE ?MACHINE ?PART))
		   (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)))
  
  (:operator HOLD-WITH-4-JAW-CHUCK
      :parameters (?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-A ?HOLDING-DEVICE 4-JAW-CHUCK) 
			 (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART) 
			 (ON-TABLE ?MACHINE ?PART)
			 (IS-EMPTY-HOLDING-DEVICE ?HOLDING-DEVICE ?MACHINE)
			 (IS-AVAILABLE-PART ?PART))
      :effect (AND (NOT (ON-TABLE ?MACHINE ?PART)) 
		   (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)))
  
  (:operator HOLD-WITH-COLLET-CHUCK
      :parameters (?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-A ?HOLDING-DEVICE COLLET-CHUCK)
			 (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART)
			 (ON-TABLE ?MACHINE ?PART)
			 (SHAPE-OF ?PART CYLINDRICAL) 
			 (IS-EMPTY-HOLDING-DEVICE ?HOLDING-DEVICE ?MACHINE)
			 (IS-AVAILABLE-PART ?PART))
      :effect (AND (NOT (ON-TABLE ?MACHINE ?PART))
		   (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)))
  
  (:operator HOLD-WITH-MAGNETIC-CHUCK
      :parameters (?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-A ?HOLDING-DEVICE MAGNETIC-CHUCK)
			 (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE)
			 (NOT (HAS-BURRS ?PART))
			 (IS-CLEAN ?PART) 
			 (ON-TABLE ?MACHINE ?PART)
			 (IS-EMPTY-HOLDING-DEVICE ?HOLDING-DEVICE ?MACHINE)
			 (IS-AVAILABLE-PART ?PART))
      :effect (AND (NOT (ON-TABLE ?MACHINE ?PART))
		   (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)))
  
  (:operator RELEASE-FROM-HOLDING-DEVICE
      :parameters (?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-OF-TYPE ?HOLDING-DEVICE HOLDING-DEVICE)
			 (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (HOLDING ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
		   (ON-TABLE ?MACHINE ?PART)))
  
  (:operator RELEASE-FROM-HOLDING-DEVICE-WEAK
      :parameters (?MACHINE ?HOLDING-DEVICE ?PART ?SIDE)
      :precondition (AND (IS-OF-TYPE ?MACHINE MACHINE)
			 (IS-A ?PART PART)
			 (IS-OF-TYPE ?HOLDING-DEVICE HOLDING-DEVICE)
			 (HOLDING-WEAKLY ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
      :effect (AND (NOT (HOLDING-WEAKLY ?MACHINE ?HOLDING-DEVICE ?PART ?SIDE))
		   (ON-TABLE ?MACHINE ?PART)))
  
  (:axiom HAS-CENTER-HOLES
      :context (AND (IS-A ?PART PART)
		    (OR
		     (AND 
		      (SHAPE-OF ?PART RECTANGULAR)
		      (EXISTS 
		       (SIZE-OF ?PART WIDTH ?X)
		       (EXISTS 
			(SIZE-OF ?PART HEIGHT ?Y)
			(EXISTS 
			 (HAS-CENTER-HOLE ?PART CENTER-HOLE-SIDE3 SIDE3
					  ?X2 ?Y2)
			 (AND (HALF-OF ?X ?X2)
			      (HALF-OF ?Y ?Y2)
			      (IS-COUNTERSINKED ?PART CENTER-HOLE-SIDE3 
						SIDE3 1/8 1/16 ?X2 ?Y2 60)
			      (HAS-CENTER-HOLE ?PART CENTER-HOLE-SIDE6 
					       SIDE6 ?X2 ?Y2) 
			      (IS-COUNTERSINKED ?PART CENTER-HOLE-SIDE6 
						SIDE6 1/8 1/16 ?X2 ?Y2 60))))))
		     (AND 
		      (SHAPE-OF ?PART CYLINDRICAL)
		      (EXISTS 
		       (SIZE-OF ?PART DIAMETER ?X)
		       (EXISTS 
			(HAS-CENTER-HOLE ?PART CENTER-HOLE-SIDE3 SIDE3 ?X2 ?X2)
			(AND (HALF-OF ?X ?X2)
			     (IS-COUNTERSINKED ?PART CENTER-HOLE-SIDE3 SIDE3 
					       1/8 1/16 ?X2 ?X2 60)
			     (HAS-CENTER-HOLE ?PART CENTER-HOLE-SIDE6 SIDE6 
					      ?X2 ?X2)
			     (IS-COUNTERSINKED ?PART CENTER-HOLE-SIDE6 SIDE6 
					       1/8 1/16 ?X2 ?X2 60)))))))
      :implies (HAS-CENTER-HOLES ?PART))
  
  (:axiom SIDE-UP-FOR-MACHINING-LENGTH
      :context (AND (EQ ?DIM LENGTH)
		    (OR (EQ ?SIDE SIDE3) 
			(EQ ?SIDE SIDE6)))
      :implies (SIDE-UP-FOR-MACHINING ?DIM ?SIDE))
  
  (:axiom SIDE-UP-FOR-MACHINING-WIDTH
      :context (AND (EQ ?DIM WIDTH)
		    (OR (EQ ?SIDE SIDE2)
			(EQ ?SIDE SIDE5)))
      :implies (SIDE-UP-FOR-MACHINING ?DIM ?SIDE))
  
  (:axiom SIDE-UP-FOR-MACHINING-HEIGHT
      :context (AND (EQ ?DIM HEIGHT)
		    (OR (EQ ?SIDE SIDE1)
			(EQ ?SIDE SIDE4)))
      :implies (SIDE-UP-FOR-MACHINING ?DIM ?SIDE))
  
  (:axiom SIDE-UP-FOR-MACHINING-DIAMETER
      :context (AND (EQ ?DIM DIAMETER)
		    (EQ ?SIDE SIDE0))
      :implies (SIDE-UP-FOR-MACHINING ?DIM ?SIDE))
  
  (:axiom MACHINE-AVAILABLE
      :context (AND (IS-OF-TYPE ?MACHINE MACHINE)
		    (NOT (EXISTS (ON-TABLE ?MACHINE ?OTHER-PART))))
      :implies (IS-AVAILABLE-MACHINE ?MACHINE))
  
  (:axiom TOOL-HOLDER-AVAILABLE
      :context (AND (IS-OF-TYPE ?MACHINE MACHINE)
		    (NOT (EXISTS (HOLDING-TOOL ?MACHINE ?TOOL))))
      :implies (IS-AVAILABLE-TOOL-HOLDER ?MACHINE))

  (:axiom TOOL-AVAILABLE
      :context (AND (IS-OF-TYPE ?TOOL MACHINE-TOOL)
		    (NOT (EXISTS (HOLDING-TOOL ?MACHINE ?TOOL))))
      :implies (IS-AVAILABLE-TOOL ?TOOL))
  
  (:axiom TABLE-AVAILABLE
      :context (AND (IS-OF-TYPE ?MACHINE MACHINE)
		    (IS-OF-TYPE ?HOLDING-DEVICE HOLDING-DEVICE)
		    (OR (NOT (EXISTS (HAS-DEVICE ?MACHINE 
						 ?ANOTHER-HOLDING-DEVICE)))
			(IS-A ?HOLDING-DEVICE TOE-CLAMP)))
      :implies (IS-AVAILABLE-TABLE ?MACHINE ?HOLDING-DEVICE))
  
   (:axiom HOLDING-DEVICE-AVAILABLE
       :context (AND (IS-OF-TYPE ?HOLDING-DEVICE HOLDING-DEVICE)
		     (NOT (EXISTS (HAS-DEVICE ?MACHINE ?HOLDING-DEVICE))))
       :implies (IS-AVAILABLE-HOLDING-DEVICE ?HOLDING-DEVICE))

   (:axiom PART-AVAILABLE
       :context (AND (IS-A ?PART PART)
		     (NOT (EXISTS (HOLDING-WEAKLY ?MACHINE ?*HOLDING-DEVICE 
						  ?PART ?*SIDE)))
		     (NOT (EXISTS (HOLDING ?MACHINE ?*ANOTHER-HOLDING-DEVICE 
					   ?PART ?*SIDE))))
       :implies (IS-AVAILABLE-PART ?PART))
   
   (:axiom HOLDING-DEVICE-EMPTY
       :context (AND (IS-OF-TYPE ?MACHINE MACHINE)
		     (IS-OF-TYPE ?HOLDING-DEVICE HOLDING-DEVICE)
		     (NOT (EXISTS (HOLDING-WEAKLY ?MACHINE ?HOLDING-DEVICE 
						  ?PART ?SIDE)))
		     (NOT (EXISTS (HOLDING ?MACHINE ?HOLDING-DEVICE 
					   ?ANOTHER-PART ?SIDE))))
       :implies (IS-EMPTY-HOLDING-DEVICE ?HOLDING-DEVICE ?MACHINE))
   
   (:axiom IS-RECTANGULAR
       :context (AND (IS-A ?PART PART)
		     (EXISTS (SIZE-OF ?PART LENGTH ?L))
		     (EXISTS (SIZE-OF ?PART WIDTH ?W))
		     (EXISTS (SIZE-OF ?PART HEIGHT ?H)))
       :implies (SHAPE-OF ?PART RECTANGULAR))
   
   (:axiom IS-CYLINDRICAL
       :context (AND (IS-A ?PART PART)
		     (EXISTS (SIZE-OF ?PART LENGTH ?L))
		     (EXISTS (SIZE-OF ?PART DIAMETER ?D)))
       :implies (SHAPE-OF ?PART CYLINDRICAL))
   
   (:axiom ARE-SIDES-OF-RECTANGULAR-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART RECTANGULAR))
       :implies (SIDE-OF ?PART SIDE1))
   
   (:axiom ARE-SIDES-OF-RECTANGULAR-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART RECTANGULAR))
       :implies (SIDE-OF ?PART SIDE2))
   
   (:axiom ARE-SIDES-OF-RECTANGULAR-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART RECTANGULAR))
       :implies (SIDE-OF ?PART SIDE3))
   
   (:axiom ARE-SIDES-OF-RECTANGULAR-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART RECTANGULAR))
       :implies (SIDE-OF ?PART SIDE4))
   
   (:axiom ARE-SIDES-OF-RECTANGULAR-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART RECTANGULAR))
       :implies (SIDE-OF ?PART SIDE5))
   
   (:axiom ARE-SIDES-OF-RECTANGULAR-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART RECTANGULAR))
       :implies (SIDE-OF ?PART SIDE6))
   
   (:axiom ARE-SIDES-OF-CYLINDRICAL-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART CYLINDRICAL))
       :implies (SIDE-OF ?PART SIDE0))
   
   (:axiom ARE-SIDES-OF-CYLINDRICAL-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART CYLINDRICAL))
       :implies (SIDE-OF ?PART SIDE3))
   
   (:axiom ARE-SIDES-OF-CYLINDRICAL-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART CYLINDRICAL))
       :implies (SIDE-OF ?PART SIDE6))
   
   (:axiom IS-MACHINED-SURFACE-QUALITY
       :context (AND (IS-A ?PART PART)
		     (OR (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-MILL)
			 (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-TURN) 
			 (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-SHAPED)
			 (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-PLANED)
			 (SURFACE-FINISH-SIDE ?PART ?SIDE FINISH-PLANED)
			 (SURFACE-FINISH-SIDE ?PART ?SIDE COLD-ROLLED)
			 (SURFACE-FINISH-SIDE ?PART ?SIDE FINISH-MILL)
			 (SURFACE-FINISH-SIDE ?PART ?SIDE FINISH-TURN)
			 (SURFACE-FINISH-QUALITY-SIDE ?PART ?SIDE GROUND)))
       :implies (SURFACE-FINISH-QUALITY-SIDE ?PART ?SIDE MACHINED))
   
   (:axiom IS-GROUND-SURFACE-QUALITY
       :context (AND (IS-A ?PART PART)
		     (OR (SURFACE-FINISH-SIDE ?PART ?SIDE ROUGH-GRIND)
			 (SURFACE-FINISH-SIDE ?PART ?SIDE FINISH-GRIND)))
       :implies (SURFACE-FINISH-QUALITY-SIDE ?PART ?SIDE GROUND))
   
   (:axiom HAS-SURFACE-FINISH-RECTANGULAR-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART RECTANGULAR)
		     (SURFACE-FINISH-SIDE ?PART SIDE1 ?SURFACE-FINISH)
		     (SURFACE-FINISH-SIDE ?PART SIDE2 ?SURFACE-FINISH)
		     (SURFACE-FINISH-SIDE ?PART SIDE3 ?SURFACE-FINISH)
		     (SURFACE-FINISH-SIDE ?PART SIDE4 ?SURFACE-FINISH)
		     (SURFACE-FINISH-SIDE ?PART SIDE5 ?SURFACE-FINISH)
		     (SURFACE-FINISH-SIDE ?PART SIDE6 ?SURFACE-FINISH))
       :implies (SURFACE-FINISH ?PART ?SURFACE-FINISH))
   
   (:axiom HAS-SURFACE-FINISH-CYLINDRICAL-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART CYLINDRICAL)
		     (SURFACE-FINISH-SIDE ?PART SIDE0 ?SURFACE-FINISH)
		     (SURFACE-FINISH-SIDE ?PART SIDE3 ?SURFACE-FINISH)
		     (SURFACE-FINISH-SIDE ?PART SIDE6 ?SURFACE-FINISH))
       :implies (SURFACE-FINISH ?PART ?SURFACE-FINISH))
   
   (:axiom HAS-SURFACE-COATING-RECTANGULAR-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART RECTANGULAR)
		     (SURFACE-COATING-SIDE ?PART SIDE1 ?SURFACE-COATING)
		     (SURFACE-COATING-SIDE ?PART SIDE2 ?SURFACE-COATING)
		     (SURFACE-COATING-SIDE ?PART SIDE3 ?SURFACE-COATING)
		     (SURFACE-COATING-SIDE ?PART SIDE4 ?SURFACE-COATING)
		     (SURFACE-COATING-SIDE ?PART SIDE5 ?SURFACE-COATING)
		     (SURFACE-COATING-SIDE ?PART SIDE6 ?SURFACE-COATING))
       :implies (SURFACE-COATING ?PART ?SURFACE-COATING))
   
   (:axiom HAS-SURFACE-COATING-CYLINDRICAL-PART
       :context (AND (IS-A ?PART PART)
		     (SHAPE-OF ?PART CYLINDRICAL)
		     (SURFACE-COATING-SIDE ?PART SIDE0 ?SURFACE-COATING)
		     (SURFACE-COATING-SIDE ?PART SIDE3 ?SURFACE-COATING)
		     (SURFACE-COATING-SIDE ?PART SIDE6 ?SURFACE-COATING))
       :implies (SURFACE-COATING ?PART ?SURFACE-COATING))
   
   (:axiom MATERIAL-FERROUS
       :context (AND (IS-A ?PART PART) 
		     (OR (MATERIAL-OF ?PART STEEL)
			 (MATERIAL-OF ?PART IRON)))
       :implies (ALLOY-OF ?PART FERROUS))
   
   (:axiom MATERIAL-NON-FERROUS
       :context (AND (IS-A ?PART PART)
		     (OR (MATERIAL-OF ?PART BRASS)
			 (MATERIAL-OF ?PART COPPER)
			 (MATERIAL-OF ?PART BRONZE)))
       :implies (ALLOY-OF ?PART NON-FERROUS))
   
   (:axiom HARDNESS-OF-MATERIAL-SOFT
       :context (AND (IS-A ?PART PART)
		     (OR (MATERIAL-OF ?PART ALUMINUM)
			 (ALLOY-OF ?PART NON-FERROUS)))
       :implies (HARDNESS-OF ?PART SOFT))
   
   (:axiom HARDNESS-OF-MATERIAL-HARD
       :context (AND (IS-A ?PART PART)
		     (ALLOY-OF ?PART FERROUS))
       :implies (HARDNESS-OF ?PART HARD))
   
   (:axiom HIGH-MELTING-POINT
       :context (AND (IS-A ?WIRE SPRAYING-METAL-WIRE)
		     (OR (MATERIAL-OF ?WIRE TUNGSTEN)
			 (MATERIAL-OF ?WIRE MOLYBDENUM)))
       :implies (HAS-HIGH-MELTING-POINT ?WIRE))
   
   (:axiom IS-MACHINE
       :context (OR (IS-A ?MACHINE DRILL)
		    (IS-A ?MACHINE LATHE)
		    (IS-A ?MACHINE SHAPER)
		    (IS-A ?MACHINE PLANER)
		    (IS-A ?MACHINE GRINDER)
		    (IS-A ?MACHINE BAND-SAW)
		    (IS-A ?MACHINE CIRCULAR-SAW)
		    (IS-A ?MACHINE MILLING-MACHINE)
		    (IS-OF-TYPE ?MACHINE WELDER))
       :implies (IS-OF-TYPE ?MACHINE MACHINE))
   
   (:axiom IS-WELDER
       :context (OR (IS-A ?MACHINE METAL-ARC-WELDER)
		    (IS-A ?MACHINE GAS-WELDER))
       :implies (IS-OF-TYPE ?MACHINE WELDER))
   
   (:axiom IS-TOOL
       :context (OR (IS-OF-TYPE ?TOOL MACHINE-TOOL)
		    (IS-OF-TYPE ?TOOL OPERATOR-TOOL))
       :implies (IS-OF-TYPE ?TOOL TOOL))
   
   (:axiom IS-MACHINE-TOOL
       :context (OR (IS-OF-TYPE ?ATTACHMENT DRILL-BIT)
		    (IS-OF-TYPE ?ATTACHMENT LATHE-TOOLBIT)
		    (IS-OF-TYPE ?ATTACHMENT CUTTING-TOOL)
		    (IS-A ?ATTACHMENT GRINDING-WHEEL)
		    (IS-OF-TYPE ?ATTACHMENT BAND-SAW-ATTACHMENT)
		    (IS-OF-TYPE ?ATTACHMENT CIRCULAR-SAW-ATTACHMENT)
		    (IS-OF-TYPE ?ATTACHMENT MILLING-CUTTER)
		    (IS-A ?ATTACHMENT ELECTRODE))
       :implies (IS-OF-TYPE ?ATTACHMENT MACHINE-TOOL))
   
   (:axiom IS-DRILL-BIT
       :context (OR (IS-A ?DRILL-BIT SPOT-DRILL)
		    (IS-A ?DRILL-BIT CENTER-DRILL)
		    (IS-A ?DRILL-BIT TWIST-DRILL)
		    (IS-A ?DRILL-BIT STRAIGHT-FLUTED-DRILL)
		    (IS-A ?DRILL-BIT HIGH-HELIX-DRILL)
		    (IS-A ?DRILL-BIT OIL-HOLE-DRILL)
		    (IS-A ?DRILL-BIT GUN-DRILL)
		    (IS-A ?DRILL-BIT CORE-DRILL)
		    (IS-A ?DRILL-BIT TAP)
		    (IS-A ?DRILL-BIT COUNTERSINK)
		    (IS-A ?DRILL-BIT COUNTERBORE)
		    (IS-A ?DRILL-BIT REAMER))
       :implies (IS-OF-TYPE ?DRILL-BIT DRILL-BIT))
   
   (:axiom IS-LATHE-TOOLBIT
       :context (OR (IS-A ?TOOLBIT ROUGH-TOOLBIT)
		    (IS-A ?TOOLBIT FINISH-TOOLBIT)
		    (IS-A ?TOOLBIT V-THREAD)
		    (IS-A ?TOOLBIT KNURL))
       :implies (IS-OF-TYPE ?TOOLBIT LATHE-TOOLBIT))
   
   (:axiom IS-CUTTING-TOOL
       :context (OR (IS-A ?CUTTING-TOOL ROUGHING-CUTTING-TOOL)
		    (IS-A ?CUTTING-TOOL FINISHING-CUTTING-TOOL))
       :implies (IS-OF-TYPE ?CUTTING-TOOL CUTTING-TOOL))
   
   (:axiom IS-CIRCULAR-SAW-ATTACHMENT
       :context (OR (IS-A ?ATTACHMENT COLD-SAW)
		    (IS-A ?ATTACHMENT FRICTION-SAW))
       :implies (IS-OF-TYPE ?ATTACHMENT CIRCULAR-SAW-ATTACHMENT))
   
   (:axiom IS-BAND-SAW-ATTACHMENT
       :context (OR (IS-A ?ATTACHMENT SAW-BAND)
		    (IS-A ?ATTACHMENT BAND-FILE))
       :implies (IS-OF-TYPE ?ATTACHMENT BAND-SAW-ATTACHMENT))
   
   (:axiom IS-MILLING-CUTTER
       :context (OR (IS-A ?MILLING-CUTTER PLAIN-MILL)
		    (IS-A ?MILLING-CUTTER END-MILL))
       :implies (IS-OF-TYPE ?MILLING-CUTTER MILLING-CUTTER))
   
   (:axiom IS-OPERATOR-TOOL
       :context (OR (IS-A ?TOOL LATHE-FILE)
		    (IS-A ?TOOL ABRASIVE-CLOTH)
		    (IS-A ?TOOL TORCH)
		    (IS-A ?TOOL WELDING-ROD)
		    (IS-A ?TOOL SPRAYING-METAL-WIRE)
		    (IS-A ?TOOL BRUSH))
       :implies (IS-OF-TYPE ?TOOL OPERATOR-TOOL))
   
   (:axiom IS-CUTTING-FLUID
       :context (OR (IS-A ?CUTTING-FLUID SOLUBLE-OIL)
		    (IS-A ?CUTTING-FLUID MINERAL-OIL))
       :implies (IS-OF-TYPE ?CUTTING-FLUID CUTTING-FLUID))
   
   (:axiom IS-HOLDING-DEVICE
       :context (OR (IS-A ?HOLDING-DEVICE V-BLOCK)
		    (IS-A ?HOLDING-DEVICE VISE)
		    (IS-A ?HOLDING-DEVICE TOE-CLAMP)
		    (IS-A ?HOLDING-DEVICE CENTERS)
		    (IS-A ?HOLDING-DEVICE 4-JAW-CHUCK)
		    (IS-A ?HOLDING-DEVICE COLLET-CHUCK) 
		    (IS-A ?HOLDING-DEVICE MAGNETIC-CHUCK))
       :implies (IS-OF-TYPE ?HOLDING-DEVICE HOLDING-DEVICE))
   
   (:fact (half-of x y)
      (cond ((variable? x) 
             (if (variable? y) :no-match-attempted 
               (list (setb x (* y 2)))))
            ((variable? y) 
             (list (setb y (/ x 2))))
            ((= (/ x 2) y) '(nil))
            (t nil)))
  (:fact (smaller x y)
      (cond ((variable? x) 
             (if (variable? y) :no-match-attempted 
               (list (setb x (- y .5)))))
            ((variable? y)
             (list (setb y (+ x .5))))
            ((< x y) '(nil))
            (t nil)))
  (:fact (smaller-than-2in x y)
      (cond ((variable? x) :no-match-attempted)
            ((variable? y) :no-match-attempted)
            ((<= (- x y) 2) '(nil))
            (t nil)))
  (:fact (finishing-size x y)
      (cond ((and (variable? x) (variable? y))
             :no-match-attempted)
            ((variable? x)
             (list (setb x (+ y 0.002))))
            ((variable? y) 
             (if (> (- x 0.002) 0)
                 (list (setb y (- x 0.002)))))
            ((<= (abs (- x y)) 0.003) '(nil))
            (t nil)))
  (:fact (new-size d1 d2 d)
      (cond ((variable? d1)
             :no-match-attempted)
            ((variable? d2)
             :no-match-attempted)
            ((variable? d)
             (list (setb d (+ d1 d2))))
            ((= d (+ d1 d2)) '(nil))
            (t nil)))
  (:fact (new-part part part1 part2)
      (cond ((variable? part)
             (list (setb part (new-name part1 part2))))
            (t '(nil))))
  (:fact (new-material material material1 material2)
      (if (variable? material)
          (cond ((eql material1 material2)
                 (list (setb material material1)))
                (t
                 (list (setb material (new-name material1 material2)))))
        '(nil))))

(defun new-name (name1 name2)
  (intern (concatenate 'string 
	    (symbol-name name1)
	    "-"
	    (symbol-name name2))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; These functions are for loading the problem sets

(defun load-start-state (inits)
  (setf *inits* inits))

(defun load-goal (goal)
  (setf *goal* (fix-eqn goal)))

(defun set-time-bound (n)
  (setq *search-limit* n))

(defun load-metal-prob (name)
  (load (format nil "~A~A" *p-metal-dir* name))
  (make-problem :name (intern name)
                :domain 'metal-domain
                :inits *inits*
                :goal *goal*))

(defun FIX-EQN (e)
  (case (car e)
    (and (cons :and (mapcar #'fix-eqn (cdr e))))
    (or (cons :or (mapcar #'fix-eqn (cdr e))))
    (~ (cons :not (mapcar #'fix-eqn (cdr e))))
    (same (variablize (cons :eq (cdr e))))
    (exists (list :exists (variablize (caddr e)) 
                  (when (cadddr e) (fix-eqn (cadddr e)))))
    (forall (list :forall (variablize (caddr e)) 
                  (when (cadddr e) (fix-eqn (cadddr e)))))
    (otherwise (variablize e))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    
(defun VARIABLIZE (tree)
  (cond ((consp tree) (cons (variablize (car tree))
                            (variablize (cdr tree))))
        ((null (symbolp tree)) tree)
        ((and (char= #\< (elt (symbol-name tree) 0))
              (char= #\> (elt (symbol-name tree)
                              (1- (length (symbol-name tree))))))
         (intern (format nil "?~a"
                         (subseq (symbol-name tree) 1 
                                 (1- (length (symbol-name tree)))))
                 (symbol-package tree)))
        (t tree)))

