(eval-when (compile eval load)
	(defpackage "SQCLIENT"
		(:export "START")
		))

;(in-package "CLIENT")
;

(asdf:operate 'asdf:load-op 's-xml)
(asdf:operate 'asdf:load-op 's-base64)
(asdf:operate 'asdf:load-op 's-sysdeps)
(asdf:operate 'asdf:load-op 's-xml-rpc)

;(in-package :s-xml-rpc)

(defun start ()
	"test."
	(defvar strat (get-strategy-from-file "test.lisp"))
	(register-client "uninfs")
	(loop until 
		(equal 'STOP (car output))
	do
		(send-response))
	(funcall strat output)
	(print "STOP from Server. Client quit.")
	)


(defun get-strategy-from-file (filename)
	"Read and evaluate the strategy closure from file filename."
	(with-open-file (stream filename)
		(eval (read stream))))

(defun register-client (gametype)
	"Begin communication with server, get id and starting informations."
	(defvar response
	 	(s-xml-rpc::xml-rpc-call (s-xml-rpc::encode-xml-rpc-call "squirrel.regSearch" gametype) :host "localhost" :port 8080))
	(defvar id 
		(s-xml-rpc::get-xml-rpc-struct-member response :|id|))
	(defvar output
		(read-from-string (s-xml-rpc::get-xml-rpc-struct-member response :|output|)))
	)

(defun send-response ()
	(setq out (funcall strat output))
	(setq output
		(read-from-string 
		(s-xml-rpc::xml-rpc-call (s-xml-rpc::encode-xml-rpc-call "squirrel.submitMoveSearch" id (write-to-string out)) :host "localhost" :port 8080)))
	)


(in-package :sqclient)
