/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import org.apache.log4j.Logger;

public class Squirrel
extends MapObject {
    private int teamID;
    private int capacity;
    private Type type;
    private int remainingCapacity;
    private Vector<Nut> load;
    private Position lastPos;
    private boolean accessedPosBefore;
    Logger log = Logger.getLogger(Game.class);

    Squirrel(String string, Position position, int n, Type type, int n2) {
        super(string, position);
        this.teamID = n2;
        this.capacity = n;
        this.remainingCapacity = n;
        this.load = new Vector();
        this.type = type;
        this.lastPos = new Position(position);
        this.accessedPosBefore = true;
    }

    public int getTeamID() {
        return this.teamID;
    }

    public Type getType() {
        return this.type;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getRemainingCapacity() {
        return this.remainingCapacity;
    }

    public String getPositionString() {
        return "(" + this.pos.x_s() + " " + this.pos.y_s() + ")";
    }

    public Position getPosition() {
        return this.pos;
    }

    public Position getLastPos() {
        return this.lastPos;
    }

    public boolean accessedBefore() {
        return this.accessedPosBefore;
    }

    public void setPosition(Position position, boolean bl) {
        this.lastPos = new Position(this.pos);
        this.pos.setPos(position);
        this.accessedPosBefore = bl;
    }

    public boolean addLoad(Nut nut) {
        if (nut.getCapacity() > this.remainingCapacity) {
            this.log.error("Remaining capacity smaller than capacity of nut");
            return false;
        }
        System.out.println("before take: " + this.remainingCapacity);
        this.load.add(nut);
        this.remainingCapacity -= nut.getCapacity();
        System.out.println("after take: " + this.remainingCapacity);
        return true;
    }

    public boolean removeLoad(Nut nut) {
        if (this.load.remove(nut)) {
            System.out.println("before remove: " + this.remainingCapacity);
            this.remainingCapacity += nut.getCapacity();
            System.out.println("after remove: " + this.remainingCapacity);
            return true;
        }
        this.log.error("Nut does not exist");
        return false;
    }

    public boolean hasNut(Nut nut) {
        return this.load.contains(nut);
    }

    public boolean hasNutType(String string) {
        boolean bl = false;
        for (Nut nut : this.load) {
            bl = nut.getName().equals(string);
        }
        return bl;
    }

    public Nut getNutWithType(String string) {
        for (Nut nut : this.load) {
            if (!nut.getName().equals(string)) continue;
            return nut;
        }
        return null;
    }

    public String getStringOfNuts() {
        String string = "";
        for (Nut nut : this.load) {
            string = string + nut.getName() + " ";
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FAST,
        SLOW;

    }
}

