/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Map {
    private Vector<MapObject>[][] map;
    private String[][] sPositions;
    private Costs costs = new Costs();
    private SPositions spos = new SPositions();
    private int lengthX;
    private int lengthY;
    private Random lrand = null;
    Logger log;

    Map(int n, int n2, String string) {
        this.log = Logger.getLogger(string);
        this.log.debug("Beginn");
        this.lengthX = n;
        this.lengthY = n2;
        for (Vector<MapObject>[] vectorArray : this.map = new Vector[n][n2]) {
            for (int i = 0; i < vectorArray.length; ++i) {
                vectorArray[i] = new Vector();
            }
        }
        this.log.debug("Ende");
    }

    public boolean addObject(MapObject mapObject, Position position) {
        boolean bl = this.map[position.x_i()][position.y_i()].add(mapObject);
        if (bl) {
            this.log.debug("Added object " + mapObject.getName() + " to field " + position.getPositionString());
            return true;
        }
        this.log.error("Could not add object " + mapObject.getName() + " to field " + position.getPositionString());
        return false;
    }

    public boolean removeObject(MapObject mapObject, Position position) {
        boolean bl = this.map[position.x_i()][position.y_i()].remove(mapObject);
        if (bl) {
            this.log.debug("Removed object " + mapObject.getName() + " from field " + position.getPositionString());
            return true;
        }
        this.log.error("Could not remove object " + mapObject.getName() + " from field " + position.getPositionString());
        return false;
    }

    public boolean isAccessibleField(Position position) {
        Vector<MapObject> vector = this.map[position.x_i()][position.y_i()];
        for (MapObject mapObject : vector) {
            if (!mapObject.getClass().getName().equals("GatheringPoint")) continue;
            return true;
        }
        for (MapObject mapObject : vector) {
            if (!mapObject.getClass().getName().equals("Squirrel") && !mapObject.getClass().getName().equals("Tree")) continue;
            return false;
        }
        return true;
    }

    public boolean isDropableField(Position position) {
        Vector<MapObject> vector = this.map[position.x_i()][position.y_i()];
        for (MapObject mapObject : vector) {
            if (!mapObject.getClass().getName().equals("Nut") && !mapObject.getClass().getName().equals("Tree")) continue;
            return false;
        }
        return true;
    }

    public boolean existsField(Position position) {
        return position.x_i() >= 0 && position.x_i() < this.map.length && position.y_i() >= 0 && position.y_i() < this.map[0].length;
    }

    public boolean isEmptyField(Position position) {
        return this.map[position.x_i()][position.y_i()].isEmpty();
    }

    public boolean hasNutType(String string, Position position) {
        Vector<MapObject> vector = this.map[position.x_i()][position.y_i()];
        if (vector.isEmpty()) {
            return false;
        }
        for (MapObject mapObject : vector) {
            if (!mapObject.getName().equals(string) || !mapObject.getClass().getName().equals("Nut")) continue;
            return true;
        }
        return false;
    }

    public Nut getNutWithType(String string, Position position) {
        Vector<MapObject> vector = this.map[position.x_i()][position.y_i()];
        for (MapObject mapObject : vector) {
            if (!mapObject.getName().equals(string) || !mapObject.getClass().getName().equals("Nut")) continue;
            return (Nut)mapObject;
        }
        return null;
    }

    public boolean hasGP(Position position) {
        Vector<MapObject> vector = this.map[position.x_i()][position.y_i()];
        for (MapObject mapObject : vector) {
            if (!mapObject.getClass().getName().equals("GatheringPoint")) continue;
            return true;
        }
        return false;
    }

    public boolean hasTree(Position position) {
        Vector<MapObject> vector = this.map[position.x_i()][position.y_i()];
        for (MapObject mapObject : vector) {
            if (!mapObject.getClass().getName().equals("Tree")) continue;
            return true;
        }
        return false;
    }

    public boolean hasSquirrel(Position position) {
        Vector<MapObject> vector = this.map[position.x_i()][position.y_i()];
        for (MapObject mapObject : vector) {
            if (!mapObject.getClass().getName().equals("Squirrel")) continue;
            return true;
        }
        return false;
    }

    public boolean hasNut(Position position) {
        Vector<MapObject> vector = this.map[position.x_i()][position.y_i()];
        for (MapObject mapObject : vector) {
            if (!mapObject.getClass().getName().equals("Nut")) continue;
            return true;
        }
        return false;
    }

    public GatheringPoint getGP(Position position) {
        Vector<MapObject> vector = this.map[position.x_i()][position.y_i()];
        for (MapObject mapObject : vector) {
            if (!mapObject.getClass().getName().equals("GatheringPoint")) continue;
            return (GatheringPoint)mapObject;
        }
        return null;
    }

    public boolean isAdjacentField(Position position, Position position2, Squirrel.Type type) {
        int n = position.x_i();
        int n2 = position.y_i();
        int n3 = position2.x_i();
        int n4 = position2.y_i();
        if (type == Squirrel.Type.SLOW && (n == n3 && (n2 == n4 + 1 || n2 == n4 || n2 == n4 - 1) || n2 == n4 && (n == n3 + 1 || n == n3 - 1))) {
            return true;
        }
        return type == Squirrel.Type.FAST && (n == n3 - 1 && (n2 == n4 + 1 || n2 == n4 || n2 == n4 - 1) || n == n3 && (n2 == n4 - 1 || n2 == n4 || n2 == n4 + 1) || n == n3 + 1 && (n2 == n4 - 1 || n2 == n4 || n2 == n4 + 1));
    }

    public int getLengthX() {
        return this.lengthX;
    }

    public int getLengthY() {
        return this.lengthY;
    }

    public Vector<String> getObjectNamesFromField(Position position) {
        Vector<String> vector = new Vector<String>();
        Vector<MapObject> vector2 = this.map[position.x_i()][position.y_i()];
        if (!vector2.isEmpty()) {
            for (MapObject mapObject : vector2) {
                vector.add(mapObject.getName());
            }
        }
        return vector;
    }

    public Vector<MapObject> getFieldObjects(Position position) {
        return this.map[position.x_i()][position.y_i()];
    }

    public void generateSPositions(int n) {
        double d = this.lengthX * this.lengthY;
        int n2 = 1;
        while (d / 26.0 > 0.7) {
            d /= 26.0;
            ++n2;
        }
        this.lrand = n == 0 ? new Random() : new Random(n);
        for (int i = 0; i < this.lengthY; ++i) {
            for (int j = 0; j < this.lengthX; ++j) {
                String string = this.generateRandomLetters(n2).toLowerCase();
                while (this.spos.contains(string)) {
                    string = this.generateRandomLetters(n2).toLowerCase();
                }
                this.spos.add(j, i, string);
            }
        }
    }

    private String generateRandomLetters(int n) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        boolean bl2 = false;
        Object var6_6 = null;
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw new IllegalArgumentException("Requested random string length " + n + " is less than 0.");
        }
        if (n2 == 0 && n3 == 0) {
            n3 = 123;
            n2 = 32;
            if (!bl && !bl2) {
                n2 = 0;
                n3 = Integer.MAX_VALUE;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n3 - n2;
        while (n-- != 0) {
            char c = var6_6 == null ? (char)(this.lrand.nextInt(n4) + n2) : var6_6[this.lrand.nextInt(n4) + n2];
            if (bl && bl2 && Character.isLetterOrDigit(c) || bl && Character.isLetter(c) || bl2 && Character.isDigit(c) || !bl && !bl2) {
                stringBuffer.append(c);
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void generateCosts(int n) {
        Random random = n == 0 ? new Random() : new Random(n);
        for (int i = 0; i < this.lengthY; ++i) {
            for (int j = 0; j < this.lengthX; ++j) {
                if (j != this.lengthX - 1 && i != this.lengthY - 1) {
                    this.costs.add(j, i, j + 1, i, random.nextInt(10) + 1);
                    this.costs.add(j, i, j, i + 1, random.nextInt(10) + 1);
                    continue;
                }
                if (j != this.lengthX - 1 && i == this.lengthY - 1) {
                    this.costs.add(j, i, j + 1, i, random.nextInt(10) + 1);
                    continue;
                }
                if (j == this.lengthX - 1 && i != this.lengthY - 1) {
                    this.costs.add(j, i, j, i + 1, random.nextInt(11));
                    continue;
                }
                if (j != this.lengthX - 1 || i != this.lengthY - 1) continue;
                return;
            }
        }
    }

    public int getCost(Position position, Position position2) {
        return this.costs.get(position, position2);
    }

    public String getSPos(Position position) {
        if (!this.spos.contains(position.getPositionString())) {
            return "";
        }
        return this.spos.getSPos(position);
    }

    public Position getPosFromSPos(String string) {
        if (!this.spos.contains(string)) {
            return null;
        }
        return this.spos.getPos(string);
    }
}

