/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Game {
    private String paragraph = "[params]";
    private Hashtable<String, String[]> parsedSquirrels = new Hashtable();
    private Vector<String> parsedSquirrelsList = new Vector();
    private Hashtable<String, String[]> parsedGPs = new Hashtable();
    int lengthX = -9;
    int lengthY = -9;
    private int numberTeams = -9;
    private int numberSquirrels = -9;
    private int numberRounds = -9;
    private int numberPoints = -9;
    private int sight = -9;
    private boolean jump = false;
    private int mapView = -9;
    private final boolean withCost = false;
    private final GameGoal gameGoal = GameGoal.CLEARMAP;
    private Map map;
    private final String filename;
    private int currentRoundCount = 1;
    private Vector<String> canMove = new Vector();
    private int teamAllowed;
    private int teamNotAllowed;
    private final int teamID1;
    private final int teamID2;
    private boolean starting = true;
    private boolean gameFinished = false;
    private boolean softError = false;
    private Error error = null;
    private Error errorTeam1 = null;
    private Error errorTeam2 = null;
    JButton[][] gfield;
    JFrame frame;
    JTextPane textPane = new JTextPane();
    JTextPane textPane2 = new JTextPane();
    SimpleAttributeSet set = new SimpleAttributeSet();
    StyledDocument doc = this.textPane.getStyledDocument();
    StyledDocument doc2 = this.textPane2.getStyledDocument();
    JTextArea textArea = new JTextArea(2, 25);
    boolean gui;
    Logger log;
    String logtime;
    private Vector<String> nutTypesList = new Vector();
    private Vector<String> treeTypesList = new Vector();
    private Hashtable<Integer, String> teamGP = new Hashtable();
    private Hashtable<Integer, Vector<String>> teamSquirrels = new Hashtable();
    private Hashtable<String, MapObject> mapObjects = new Hashtable();
    private Hashtable<String, Nut> nutTypes = new Hashtable();
    private Hashtable<String, Tree> treeTypes = new Hashtable();
    private Hashtable<Integer, TreeSet<Position>> alreadyExplored = new Hashtable();
    private Hashtable<Integer, TreeSet<Position>> alreadyAccessed = new Hashtable();
    private Hashtable<Integer, TreeSet<Position>> alreadyAccessedThisRound = new Hashtable();

    Game(String string, int[] nArray, boolean bl) throws ParserException {
        this.teamID1 = nArray[0];
        this.teamID2 = nArray[1];
        this.teamAllowed = this.teamID1;
        this.filename = string;
        this.gui = bl;
        this.teamNotAllowed = this.teamID1;
        this.alreadyExplored.put(this.teamID1, new TreeSet());
        this.alreadyExplored.put(this.teamID2, new TreeSet());
        this.alreadyAccessed.put(this.teamID1, new TreeSet());
        this.alreadyAccessed.put(this.teamID2, new TreeSet());
        this.alreadyAccessedThisRound.put(this.teamID1, new TreeSet());
        this.alreadyAccessedThisRound.put(this.teamID2, new TreeSet());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd - HH:mm:ss");
        this.logtime = simpleDateFormat.format(new Date());
        this.log = Logger.getLogger(this.logtime);
        this.startLogger();
        this.parseMap();
        this.mapView = 0;
        if (bl) {
            this.startGui();
        }
        this.canMove = (Vector)this.teamSquirrels.get(this.teamAllowed).clone();
        this.log.debug("Ende");
    }

    private void startLogger() {
        PatternLayout patternLayout = new PatternLayout("%m\n");
        FileAppender fileAppender = null;
        ConsoleAppender consoleAppender = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd - HH:mm:ss");
            fileAppender = this.teamID2 != 0 ? new FileAppender((Layout)patternLayout, "logs/" + this.teamID1 + " - " + this.teamID2 + " | " + simpleDateFormat.format(new Date()) + ".log") : new FileAppender((Layout)patternLayout, "logs/" + this.teamID1 + " | " + simpleDateFormat.format(new Date()) + ".log");
            consoleAppender = new ConsoleAppender(patternLayout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.addAppender(fileAppender);
        this.log.setLevel(Level.INFO);
    }

    private void startGui() {
        int n;
        int n2;
        this.frame = new JFrame();
        this.gfield = new JButton[this.lengthX][this.lengthY];
        GridLayout gridLayout = new GridLayout(this.lengthY, this.lengthX);
        JPanel jPanel = new JPanel();
        this.textPane.setEditable(false);
        this.textArea.setEditable(false);
        jPanel.setLayout(gridLayout);
        this.frame.setLayout(new FlowLayout());
        for (n2 = 0; n2 < this.lengthY; ++n2) {
            for (n = 0; n < this.lengthX; ++n) {
                this.gfield[n][n2] = new JButton("");
                jPanel.add(this.gfield[n][n2]);
                this.gfield[n][n2].setBackground(Color.green);
                this.gfield[n][n2].setPreferredSize(new Dimension(65, 65));
            }
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        JScrollPane jScrollPane2 = new JScrollPane(this.textPane);
        JScrollPane jScrollPane3 = new JScrollPane(this.textPane2);
        JScrollPane jScrollPane4 = new JScrollPane(this.textArea);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane2, jScrollPane3);
        jSplitPane.setPreferredSize(new Dimension(520, 250));
        jSplitPane.setDividerLocation(255);
        jSplitPane.setOneTouchExpandable(true);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, jScrollPane4);
        jSplitPane2.setPreferredSize(new Dimension(520, 350));
        jSplitPane2.setDividerLocation(265);
        jSplitPane2.setOneTouchExpandable(true);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("Team 1"));
        jScrollPane2.setMinimumSize(new Dimension(150, 150));
        jScrollPane2.setPreferredSize(new Dimension(260, 250));
        jScrollPane3.setBorder(BorderFactory.createTitledBorder("Team 2"));
        jScrollPane3.setPreferredSize(new Dimension(260, 250));
        jScrollPane3.setMinimumSize(new Dimension(150, 150));
        jScrollPane4.setBorder(BorderFactory.createTitledBorder("Game Informations"));
        jScrollPane4.setMinimumSize(new Dimension(500, 50));
        jScrollPane4.setPreferredSize(new Dimension(500, 100));
        n2 = this.lengthX > 7 ? 8 : this.lengthX;
        n = this.lengthY > 7 ? 8 : this.lengthY;
        if (n2 == 8 && n == 8) {
            jScrollPane.setPreferredSize(new Dimension((n2 - 1) * 65 + 18, (n - 1) * 65 + 18));
        } else if (n2 == 8) {
            jScrollPane.setPreferredSize(new Dimension((n2 - 1) * 65 + 3, n * 65 + 18));
        } else if (n == 8) {
            jScrollPane.setPreferredSize(new Dimension(n2 * 65 + 18, (n - 1) * 65 + 3));
        } else {
            jScrollPane.setPreferredSize(new Dimension(n2 * 65 + 3, n * 65 + 3));
        }
        JCheckBox jCheckBox = new JCheckBox("Full view");
        jCheckBox.setMnemonic(77);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (Game.this.mapView == 1) {
                    Game.this.mapView = 0;
                } else {
                    Game.this.mapView = 1;
                }
                Game.this.draw();
            }
        });
        this.frame.add(jScrollPane);
        this.frame.add(jSplitPane2);
        this.frame.add(jCheckBox);
        this.frame.setIconImage(new ImageIcon("pics/nutcropped.png").getImage());
        this.frame.setTitle("AIchhoernchen");
        this.frame.pack();
        if (this.teamID1 != 12345 && this.gui) {
            this.frame.setVisible(true);
        }
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = this.doc.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "SansSerif");
        Style style3 = this.doc.addStyle("italic", style2);
        Style style4 = this.doc2.addStyle("italic", style2);
        StyleConstants.setItalic(style3, true);
        StyleConstants.setItalic(style4, true);
        style3 = this.doc.addStyle("bold", style2);
        style4 = this.doc2.addStyle("bold", style2);
        StyleConstants.setBold(style3, true);
        StyleConstants.setBold(style4, true);
        style3 = this.doc.addStyle("small", style2);
        style4 = this.doc2.addStyle("small", style2);
        StyleConstants.setFontSize(style3, 10);
        StyleConstants.setFontSize(style4, 10);
        style3 = this.doc.addStyle("large", style2);
        style4 = this.doc2.addStyle("large", style2);
        StyleConstants.setFontSize(style3, 16);
        StyleConstants.setFontSize(style4, 16);
        style3 = this.doc.addStyle("icon", style2);
        style4 = this.doc2.addStyle("icon", style2);
    }

    private void parseMap() throws ParserException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.filename)));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim().toLowerCase()).equals("") || string.startsWith("//")) continue;
                if (string.startsWith("[nuts]")) {
                    if (this.numberTeams == -9 || this.numberSquirrels == -9 || this.numberRounds == -9 || this.numberPoints == -9 || this.sight == -9 || this.mapView == -9) {
                        throw new ParserException("\nError: A parameter is not defined properly yet");
                    }
                    if (this.numberTeams == 1 && this.teamID2 != 0) {
                        throw new ParserException("\nError: 1 player game but 2 players registered");
                    }
                    this.paragraph = "[nuts]";
                }
                if (string.startsWith("[trees]")) {
                    this.paragraph = "[trees]";
                }
                if (string.startsWith("[squirrels]")) {
                    this.paragraph = "[squirrels]";
                }
                if (string.startsWith("[gathering points]")) {
                    if (this.parsedSquirrelsList.isEmpty()) {
                        throw new ParserException("\nError: No Squirrels defined");
                    }
                    this.paragraph = "[gathering points]";
                }
                if (string.startsWith("[map params]")) {
                    if (this.numberTeams == 1) {
                        if (!this.parsedGPs.containsKey("1")) {
                            throw new ParserException("\nError: GP for team 1 not defined");
                        }
                        if (this.parsedGPs.containsKey("2")) {
                            throw new ParserException("\nError: Too much GPs defined");
                        }
                    }
                    if (!(this.numberTeams != 2 || this.parsedGPs.containsKey("1") && this.parsedGPs.containsKey("2"))) {
                        throw new ParserException("\nError: GP for team 1 or 2 not defined");
                    }
                    this.paragraph = "[map params]";
                }
                if (string.startsWith("[fields]")) {
                    if (this.lengthX == -9 | this.lengthY == -9) {
                        throw new ParserException("\nError: lengthX or lengthY not defined");
                    }
                    this.map = new Map(this.lengthX, this.lengthY, this.logtime);
                    this.paragraph = "[fields]";
                }
                if (string.startsWith("[")) continue;
                if (this.paragraph.equals("[params]")) {
                    this.parseParams(string);
                }
                if (this.paragraph.equals("[nuts]")) {
                    this.parseNuts(string);
                }
                if (this.paragraph.equals("[trees]")) {
                    this.parseTrees(string);
                }
                if (this.paragraph.equals("[squirrels]")) {
                    this.parseSquirrels(string);
                }
                if (this.paragraph.equals("[gathering points]")) {
                    this.parseGPs(string);
                }
                if (this.paragraph.equals("[map params]")) {
                    this.parseMapParams(string);
                }
                if (!this.paragraph.equals("[fields]")) continue;
                this.parseFields(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Exception: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
        this.teamSquirrels.put(this.teamID1, new Vector());
        this.teamSquirrels.put(this.teamID2, new Vector());
        this.parseAddSquirrels();
        if (this.numberTeams == 1) {
            if (this.teamSquirrels.get(this.teamID1).size() != this.numberSquirrels) {
                throw new ParserException("\nError: Not same number of squirrels as in numberSquirrels defined added");
            }
            return;
        }
        if (this.teamSquirrels.get(this.teamID1).size() != this.numberSquirrels || this.teamSquirrels.get(this.teamID2).size() != this.numberSquirrels) {
            throw new ParserException("\nError: Not same number of squirrels as in numberSquirrels defined added");
        }
    }

    private void parseParams(String string) throws ParserException {
        String[] stringArray = string.split("[ \\s]+");
        if (stringArray.length < 2) {
            throw new ParserException("\nLine: " + string + "\nError: Not enough arguments");
        }
        if (stringArray[0].equals("numberteams")) {
            if (this.numberTeams == -9) {
                if (stringArray[1].equals("1") || stringArray[1].equals("2")) {
                    this.numberTeams = new Integer(stringArray[1]);
                    return;
                }
                throw new ParserException("\nLine: " + string + "\nError: Value must be 1 or 2");
            }
            throw new ParserException("\nLine: " + string + "\nError: Parameter already defined");
        }
        if (stringArray[0].equals("numbersquirrels")) {
            if (this.numberSquirrels == -9) {
                if (stringArray[1].matches("[1-9][0-9]*")) {
                    this.numberSquirrels = new Integer(stringArray[1]);
                    return;
                }
                throw new ParserException("\nLine: " + string + "\nError: Value must be a positive Integer");
            }
            throw new ParserException("\nLine: " + string + "\nError: Parameter already defined");
        }
        if (stringArray[0].equals("numberrounds")) {
            if (this.numberRounds == -9) {
                if (stringArray[1].matches("[0-9][0-9]*")) {
                    this.numberRounds = new Integer(stringArray[1]);
                    return;
                }
                throw new ParserException("\nLine: " + string + "\nError: Value must be a positive Integer or Zero");
            }
            throw new ParserException("\nLine: " + string + "\nError: Parameter already defined");
        }
        if (stringArray[0].equals("numberpoints")) {
            if (this.numberPoints == -9) {
                if (stringArray[1].matches("[0-9][0-9]*")) {
                    this.numberPoints = new Integer(stringArray[1]);
                    return;
                }
                throw new ParserException("\nLine: " + string + "\nError: Value must be a positive Integer or Zero");
            }
            throw new ParserException("\nLine: " + string + "\nError: Parameter already defined");
        }
        if (stringArray[0].equals("jump")) {
            if (stringArray[1].matches("true")) {
                this.jump = true;
                return;
            }
            if (stringArray[1].matches("false")) {
                this.jump = false;
                return;
            }
            throw new ParserException("\nLine: " + string + "\nError: Value must be true or false");
        }
        if (stringArray[0].equals("view")) {
            if (this.sight == -9) {
                if (stringArray[1].matches("[0-9][0-9]*") || stringArray[1].equals("-1")) {
                    this.sight = new Integer(stringArray[1]);
                    return;
                }
                throw new ParserException("\nLine: " + string + "\nError: Value must be a positive Integer, zero or -1");
            }
            throw new ParserException("\nLine: " + string + "\nError: Parameter already defined");
        }
        if (stringArray[0].equals("mapview")) {
            if (this.mapView == -9) {
                if (stringArray[1].equals("0") || stringArray[1].equals("1")) {
                    this.mapView = new Integer(stringArray[1]);
                    return;
                }
                throw new ParserException("\nLine: " + string + "\nError: Value must be 0 or 1");
            }
            throw new ParserException("\nLine: " + string + "\nError: Parameter already defined");
        }
        this.log.debug("numberPoints: " + this.numberPoints + "  numberRounds: " + this.numberRounds + "  numberSqirrels: " + this.numberSquirrels + "  numberTeams: " + this.numberTeams + "  jump: " + this.jump + "  sight: " + this.sight);
        throw new ParserException("\nLine: " + string + "\nError: No Parameter");
    }

    private void parseNuts(String string) throws ParserException {
        String[] stringArray = string.split("[ \\s]+");
        if (stringArray.length < 3) {
            throw new ParserException("\nLine: " + string + "\nError: Not enough arguments");
        }
        if (!stringArray[0].matches("n[0-9]*")) {
            throw new ParserException("\nLine: " + string + "\nError: name must be nx, where x is a positive Integer");
        }
        if (!stringArray[1].matches("0") && !stringArray[1].matches("[1-9][0-9]*")) {
            throw new ParserException("\nLine: " + string + "\nError: name must be a positive Integer");
        }
        if (!stringArray[1].matches("[1-9][0-9]*")) {
            throw new ParserException("\nLine: " + string + "\nError: name must be a positive Integer");
        }
        this.mapAddNutType(stringArray[0], new Integer(stringArray[1]), new Integer(stringArray[2]));
    }

    private void parseTrees(String string) throws ParserException {
        String[] stringArray = string.split("[ \\s]+");
        if (stringArray.length < 2) {
            throw new ParserException("\nLine: " + string + "\nError: Not enough arguments");
        }
        if (!stringArray[0].matches("t[0-9]+")) {
            throw new ParserException("\nLine: " + string + "\nError: name must be tx, where x is a positive Integer");
        }
        this.mapAddTreeType(stringArray[0], stringArray[1]);
    }

    private void parseSquirrels(String string) throws ParserException {
        String[] stringArray = string.split("[ \\s]+");
        if (stringArray.length != 4) {
            throw new ParserException("\nLine: " + string + "\nError: Not enough arguments");
        }
        if (!stringArray[0].matches("s[0-9]+")) {
            throw new ParserException("\nLine: " + string + "\nError: Name must be sx, where x is a positive Integer");
        }
        if (!stringArray[1].matches("[1-9][0-9]*")) {
            throw new ParserException("\nLine: " + string + "\nError: Capacity must be a positive Integer");
        }
        if (!stringArray[2].matches("slow") && !stringArray[2].matches("fast")) {
            throw new ParserException("\nLine: " + string + "\nError: Type must be SLOW or FAST");
        }
        if (!stringArray[3].matches("1") && !stringArray[3].matches("2")) {
            throw new ParserException("\nLine: " + string + "\nError: Team must be 1 or 2");
        }
        if (this.parsedSquirrels.containsKey(stringArray[0])) {
            throw new ParserException("\nLine: " + string + "\nError: Squirrel already defined");
        }
        this.parsedSquirrels.put(stringArray[0], stringArray);
        this.parsedSquirrelsList.add(stringArray[0]);
    }

    private void parseGPs(String string) throws ParserException {
        String[] stringArray = string.split("[ \\s]+");
        if (stringArray.length != 2) {
            throw new ParserException("\nLine: " + string + "\nError: Not enough or too much arguments");
        }
        if (!stringArray[0].matches("gp[0-9]+")) {
            throw new ParserException("\nLine: " + string + "\nError: Name must be gpx, where x is a positive Integer");
        }
        if (!stringArray[1].matches("1") && !stringArray[1].matches("2")) {
            throw new ParserException("\nLine: " + string + "\nError: Team must be 1 or 2");
        }
        if (this.parsedGPs.containsKey(stringArray[0]) || this.parsedGPs.containsKey(stringArray[1])) {
            throw new ParserException("\nLine: " + string + "\nError: GP already defined");
        }
        this.parsedGPs.put(stringArray[0], stringArray);
        this.parsedGPs.put(stringArray[1], stringArray);
    }

    private void parseMapParams(String string) throws ParserException {
        String[] stringArray = string.split("[ \\s]+");
        if (stringArray[0].equals("lengthx")) {
            if (this.lengthX == -9) {
                this.lengthX = new Integer(stringArray[1]);
                return;
            }
            throw new ParserException("\nLine: " + string + "\nError: LenghtX already defined");
        }
        if (stringArray[0].equals("lengthy")) {
            if (this.lengthY == -9) {
                this.lengthY = new Integer(stringArray[1]);
                return;
            }
            throw new ParserException("\nLine: " + string + "\nError: LenghtY already defined");
        }
        throw new ParserException("\nLine: " + string + "\nError: No map parameter");
    }

    private void parseFields(String string) throws ParserException {
        String[] stringArray = string.split("[ \\s]+");
        if (stringArray.length != 4) {
            throw new ParserException("\nLine: " + string + "\nError: Not enough or too much arguments");
        }
        if (!stringArray[0].matches("field")) {
            throw new ParserException("\nLine: " + string + "\nError: line in [Fields] must begin with \"field\"");
        }
        if (!stringArray[1].matches("[0-9]+")) {
            throw new ParserException("\nLine: " + string + "\nError: X value of field must be a positive Integer");
        }
        int n = new Integer(stringArray[1]);
        if (!stringArray[2].matches("[0-9]+")) {
            throw new ParserException("\nLine: " + string + "\nError: Y value of field must be a positive Integer");
        }
        int n2 = new Integer(stringArray[2]);
        if (n >= this.lengthX) {
            throw new ParserException("\nLine: " + string + "\nError: X value must not be greater than map length");
        }
        if (n2 >= this.lengthY) {
            throw new ParserException("\nLine: " + string + "\nError: Y value must not be greater than map length");
        }
        if (stringArray[3].matches("n[0-9]+")) {
            this.mapAddNut(stringArray[3], new Position(n, n2));
            return;
        }
        if (stringArray[3].matches("t[0-9]+")) {
            this.mapAddTree(stringArray[3], new Position(n, n2));
            return;
        }
        if (stringArray[3].matches("gp[0-9]+")) {
            if (this.parsedGPs.containsKey(stringArray[3])) {
                String[] stringArray2 = this.parsedGPs.get(stringArray[3]);
                int n3 = stringArray2[1].equals("1") ? this.teamID1 : this.teamID2;
                if (n3 == 0) {
                    throw new ParserException("\nLine: " + string + "\nError: 1 Player Game");
                }
                this.mapAddGP(stringArray2[0], new Position(n, n2), n3);
                return;
            }
            throw new ParserException("\nLine: " + string + "\nError: Gathering point not defined");
        }
        throw new ParserException("\nLine: " + string + "\nError: Not a defined object");
    }

    private void parseAddSquirrels() throws ParserException {
        for (String string : this.parsedSquirrelsList) {
            Squirrel.Type type;
            String string2;
            String[] stringArray = this.parsedSquirrels.get(string);
            if (stringArray[3].equals("1")) {
                string2 = this.teamGP.get(this.teamID1);
                type = stringArray[2].equals("fast") ? Squirrel.Type.FAST : Squirrel.Type.SLOW;
                this.log.debug("gp: " + string2);
                if (this.mapObjects.containsKey(string2)) {
                    this.mapAddSquirrel(stringArray[0], new Position(((GatheringPoint)this.mapObjects.get(string2)).getPosition()), new Integer(stringArray[1]), type, this.teamID1);
                    continue;
                }
                throw new ParserException("\nError: GP not found");
            }
            if (!this.teamGP.containsKey(this.teamID2)) {
                throw new ParserException("\nError: Team number 2 not allowed");
            }
            string2 = this.teamGP.get(this.teamID2);
            type = stringArray[2].equals("fast") ? Squirrel.Type.FAST : Squirrel.Type.SLOW;
            if (this.mapObjects.containsKey(string2)) {
                this.mapAddSquirrel(stringArray[0], new Position(((GatheringPoint)this.mapObjects.get(string2)).getPosition()), new Integer(stringArray[1]), type, this.teamID2);
                continue;
            }
            throw new ParserException("\nError: GP not found");
        }
    }

    private boolean mapAddNutType(String string, int n, int n2) throws ParserException {
        Nut nut = new Nut(string, n, n2);
        if (!this.nutTypes.containsKey(nut.getName())) {
            this.nutTypesList.add(nut.getName());
            this.nutTypes.put(nut.getName(), nut);
            this.log.debug("Added Nut type " + nut.getName());
            return true;
        }
        throw new ParserException("\nLine:\nError: Nut type" + string + " already exists");
    }

    private boolean mapAddTreeType(String string, String string2) throws ParserException {
        if (!this.nutTypes.containsKey(string2)) {
            throw new ParserException("\nLine: \nError: Nut type" + string + " does not exist");
        }
        if (!this.treeTypes.containsKey(string)) {
            Tree tree = new Tree(string, string2);
            this.treeTypesList.add(tree.getName());
            this.treeTypes.put(tree.getName(), tree);
            this.log.debug("Added tree type " + tree.getName());
            return true;
        }
        throw new ParserException("\nLine: \nError: Tree type" + string + " already defined");
    }

    private boolean mapAddSquirrel(String string, Position position, int n, Squirrel.Type type, int n2) throws ParserException {
        if (this.mapObjects.containsKey(string)) {
            throw new ParserException("Squirrel " + string + "already added to map");
        }
        TreeSet<Position> treeSet = this.alreadyExplored.get(n2);
        treeSet.add(new Position(position));
        Squirrel squirrel = new Squirrel(string, position, n, type, n2);
        squirrel.setPosition(squirrel.getPosition(), true);
        this.mapObjects.put(squirrel.getName(), squirrel);
        Vector<String> vector = this.teamSquirrels.get(n2);
        vector.add(squirrel.getName());
        return this.map.addObject(squirrel, position);
    }

    private boolean mapAddNut(String string, Position position) throws ParserException {
        Nut nut = this.nutTypes.get(string);
        if (nut == null) {
            throw new ParserException("Nut type " + string + " not defined");
        }
        if (this.map.hasGP(position)) {
            throw new ParserException("Cannot add nut to field with gathering point");
        }
        if (this.map.hasNut(position)) {
            throw new ParserException("Cannot add nut to field with nut");
        }
        if (this.map.hasTree(position)) {
            throw new ParserException("Cannot add nut to field with nut");
        }
        return this.map.addObject(nut, position);
    }

    private boolean mapAddTree(String string, Position position) throws ParserException {
        Tree tree = this.treeTypes.get(string);
        if (tree == null) {
            throw new ParserException("Tree type " + string + " not defined");
        }
        if (!this.map.isEmptyField(position)) {
            throw new ParserException("Cannot add tree to non-empty field");
        }
        return this.map.addObject(tree, position);
    }

    private boolean mapAddGP(String string, Position position, int n) throws ParserException {
        if (this.teamGP.get(n) != null) {
            throw new ParserException("GP for team already existing");
        }
        if (this.mapObjects.containsKey(string)) {
            throw new ParserException("GP already added to map");
        }
        GatheringPoint gatheringPoint = new GatheringPoint(n, string, position);
        this.teamGP.put(n, string);
        this.mapObjects.put(string, gatheringPoint);
        return this.map.addObject(gatheringPoint, position);
    }

    public String getStartingInfosFirst() {
        String string = this.getObjectDescription(this.teamID1, this.teamID2);
        String string2 = this.getMapString(this.teamID1);
        String string3 = "(" + string + " " + string2 + ")";
        this.log.info(this.teamID1 + ": Generated starting infos for player 1");
        this.log.info("..........................................\n" + string3 + "\n..........................................");
        return string3;
    }

    public String getStartingInfosSecond() {
        String string = this.getObjectDescription(this.teamID2, this.teamID1);
        String string2 = this.getMapString(this.teamID2);
        String string3 = "(" + string + " " + string2 + ")";
        this.log.info(this.teamID2 + ": Generated starting infos for player 2");
        this.log.info("..........................................\n" + string3 + "\n..........................................");
        return string3;
    }

    private String getObjectDescription(int n, int n2) {
        Object object;
        String string = "(ObjDesc ";
        String string2 = "(OwnObj ";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        Vector<String> vector = this.teamSquirrels.get(n);
        String string9 = this.teamGP.get(n);
        for (String object3 : vector) {
            Squirrel squirrel = (Squirrel)this.mapObjects.get(object3);
            object = "(Squirrel " + squirrel.getName() + " " + squirrel.getCapacity() + " " + (Object)((Object)squirrel.getType()) + " " + squirrel.getPositionString() + ")";
            string3 = string3 + (String)object;
        }
        GatheringPoint gatheringPoint = (GatheringPoint)this.mapObjects.get(string9);
        string4 = "(OwnGP  " + gatheringPoint.getName() + " " + gatheringPoint.getPositionString() + ")";
        string2 = string2 + string3 + string4 + ")";
        if (this.numberTeams == 2) {
            string5 = "(OppObj ";
            Vector<String> vector2 = this.teamSquirrels.get(n2);
            String string10 = this.teamGP.get(n2);
            for (String string11 : vector2) {
                Squirrel squirrel = (Squirrel)this.mapObjects.get(string11);
                String string12 = "(Squirrel " + squirrel.getName() + " " + (Object)((Object)squirrel.getType()) + ")";
                string6 = string6 + string12;
            }
            object = (GatheringPoint)this.mapObjects.get(string10);
            string7 = "(OppGP " + ((MapObject)object).getName() + ")";
            string5 = string5 + string6 + string7 + ")";
        }
        if (!this.nutTypesList.isEmpty()) {
            string8 = "(MiscObj ";
        }
        for (String string13 : this.nutTypesList) {
            object = this.nutTypes.get(string13);
            string8 = string8 + "(Nut " + ((MapObject)object).getName() + " " + ((Nut)object).getCapacity() + " " + ((Nut)object).getValue() + ")";
        }
        if (!this.treeTypesList.isEmpty()) {
            if (string8.equals("")) {
                string8 = "(MiscObj ";
            }
            for (String string14 : this.treeTypesList) {
                object = this.treeTypes.get(string14);
                string8 = string8 + "(Tree " + ((MapObject)object).getName() + " " + ((Tree)object).getType() + ")";
            }
        }
        if (!string8.equals("")) {
            string8 = string8 + ")";
        }
        string = string + string2 + " " + string5 + " " + string8 + ")";
        return string;
    }

    private String getMapString(int n) {
        String string = "(Map ";
        TreeSet<Position> treeSet = this.getVisibleFields(n);
        for (Position position : treeSet) {
            Vector<String> vector = this.map.getObjectNamesFromField(position);
            string = string + "(" + position.getPositionString();
            if (vector.isEmpty()) {
                string = string + " nil";
            } else {
                string = string + "(";
                for (String string2 : vector) {
                    string = string + " " + string2;
                }
                string = string + ")";
            }
            string = string + ")";
        }
        string = string + ")";
        return string;
    }

    public String generateEndInfos(int n) {
        if (this.numberRounds == 0) {
            if (this.numberTeams == 1) {
                return "(Stop \"Win\")";
            }
            if (this.reachedPointsGoal(this.teamID1) && this.reachedPointsGoal(this.teamID2)) {
                return "(Stop \"Tie\")";
            }
            if (this.reachedPointsGoal(n)) {
                return "(Stop \"Win\")";
            }
            if (this.reachedPointsGoal(this.getOppID(n))) {
                return "(Stop \"Loss\")";
            }
        }
        GatheringPoint gatheringPoint = (GatheringPoint)this.mapObjects.get(this.teamGP.get(n));
        GatheringPoint gatheringPoint2 = (GatheringPoint)this.mapObjects.get(this.teamGP.get(this.getOppID(n)));
        this.log.info((gatheringPoint == null) + " " + (gatheringPoint2 == null));
        if (this.numberPoints == 0) {
            if (this.numberTeams == 1) {
                return "(Stop \"Win\")";
            }
            if (gatheringPoint.getSumValue() > gatheringPoint2.getSumValue()) {
                return "(Stop \"Win\")";
            }
            if (gatheringPoint.getSumValue() < gatheringPoint2.getSumValue()) {
                return "(Stop \"Loss\")";
            }
            if (gatheringPoint.getSumValue() == gatheringPoint2.getSumValue()) {
                return "(Stop \"Tie\")";
            }
        }
        if (this.numberTeams == 1) {
            if (this.reachedPointsGoal(n)) {
                return "(Stop \"Win\")";
            }
            return "(Stop \"Tie\")";
        }
        if (this.reachedPointsGoal(this.teamID1) && this.reachedPointsGoal(this.teamID2)) {
            return "(Stop \"Tie\")";
        }
        if (this.reachedPointsGoal(n)) {
            return "(Stop \"Win\")";
        }
        if (this.reachedPointsGoal(this.getOppID(n))) {
            return "(Stop \"Loss\")";
        }
        if (gatheringPoint.getSumValue() > gatheringPoint2.getSumValue()) {
            return "(Stop \"Win\")";
        }
        if (gatheringPoint.getSumValue() < gatheringPoint2.getSumValue()) {
            return "(Stop \"Loss\")";
        }
        if (gatheringPoint.getSumValue() == gatheringPoint2.getSumValue()) {
            return "(Stop \"Tie\")";
        }
        return "(Stop \"No goal reached\")";
    }

    private boolean reachedPointsGoal(int n) {
        GatheringPoint gatheringPoint = null;
        if (n == this.teamID1 || n == this.teamID2) {
            gatheringPoint = (GatheringPoint)this.mapObjects.get(this.teamGP.get(n));
        } else {
            this.log.error(n + ": No such teamid");
        }
        return gatheringPoint.getSumValue() >= this.numberPoints;
    }

    private boolean isFinishedGame() {
        if (this.currentRoundCount >= this.numberRounds && this.numberRounds != 0) {
            return true;
        }
        if (this.numberPoints != 0) {
            if (this.reachedPointsGoal(this.teamID1)) {
                return true;
            }
            if (this.teamID2 != 0 && this.reachedPointsGoal(this.teamID2)) {
                return true;
            }
        }
        return false;
    }

    public void draw() {
        int n = this.map.getLengthX();
        int n2 = this.map.getLengthY();
        if (!this.gui) {
            return;
        }
        String string = "";
        Vector<MapObject> vector = null;
        String string2 = "";
        String string3 = "....";
        String string4 = ".";
        String string5 = "****";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.map.isEmptyField(new Position(j, i))) {
                    vector = this.map.getFieldObjects(new Position(j, i));
                    for (MapObject mapObject : vector) {
                        String string10 = mapObject.getClass().getName();
                        if (string10.equals("Squirrel")) {
                            string6 = mapObject.getName();
                        }
                        if (string10.equals("Tree")) {
                            string8 = mapObject.getName();
                        }
                        if (string10.equals("Nut")) {
                            string7 = mapObject.getName();
                        }
                        if (!string10.equals("GatheringPoint")) continue;
                        string9 = mapObject.getName();
                    }
                    if (this.isVisibleField(new Position(j, i), this.teamAllowed) || this.mapView == 1) {
                        if (!string9.equals("")) {
                            if (!string6.equals("")) {
                                this.gfield[j][i].setIcon(new ImageIcon("pics/gpsq.png"));
                            } else {
                                this.gfield[j][i].setIcon(new ImageIcon("pics/gp.png"));
                            }
                        } else if (!string6.equals("")) {
                            if (!string7.equals("")) {
                                this.gfield[j][i].setIcon(new ImageIcon("pics/sqnut.png"));
                            } else {
                                this.gfield[j][i].setIcon(new ImageIcon("pics/sq.png"));
                            }
                        } else if (!string7.equals("")) {
                            this.gfield[j][i].setIcon(new ImageIcon("pics/nut.png"));
                        } else {
                            this.gfield[j][i].setIcon(new ImageIcon("pics/tree.png"));
                        }
                    } else if (this.isExplored(new Position(j, i), this.teamAllowed)) {
                        if (!string9.equals("")) {
                            this.gfield[j][i].setIcon(new ImageIcon("pics/swgp.png"));
                        } else if (!string8.equals("")) {
                            this.gfield[j][i].setIcon(new ImageIcon("pics/swtree.png"));
                        } else {
                            this.gfield[j][i].setIcon(new ImageIcon("pics/swgras.png"));
                        }
                    } else {
                        this.gfield[j][i].setIcon(new ImageIcon("pics/black.png"));
                    }
                } else if (this.isVisibleField(new Position(j, i), this.teamAllowed) || this.mapView == 1) {
                    this.gfield[j][i].setIcon(new ImageIcon("pics/gras.png"));
                } else if (this.isExplored(new Position(j, i), this.teamAllowed)) {
                    this.gfield[j][i].setIcon(new ImageIcon("pics/swgras.png"));
                } else {
                    this.gfield[j][i].setIcon(new ImageIcon("pics/black.png"));
                }
                string6 = "";
                string8 = "";
                string7 = "";
                string9 = "";
            }
        }
        try {
            this.doc.remove(0, this.doc.getLength());
            this.doc2.remove(0, this.doc2.getLength());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.drawInfos(1, this.teamID1, this.doc);
        if (this.numberTeams == 2) {
            this.drawInfos(2, this.teamID2, this.doc2);
        }
        string = string + "  Maximum number of rounds: ";
        string = this.numberRounds == 0 ? string + "No limit" : string + this.numberRounds;
        string = string + "\n";
        string = string + "  Points to reach: ";
        string = this.numberPoints == 0 ? string + "  No goal" : string + this.numberPoints;
        string = string + "\n";
        string = string + "  Current round: " + this.currentRoundCount;
        this.textArea.setText(string);
    }

    public void drawold() {
        for (int i = 0; i < 35; ++i) {
            System.out.println("\n");
        }
        this.drawMap(0, 0);
        this.drawMap(1, this.teamID1);
        if (this.numberTeams == 2) {
            this.drawMap(1, this.teamID2);
        }
        String string = "";
        if (this.numberTeams == 2) {
            string = string + "***Game Details***\n";
        }
        string = string + "  Maximum number of rounds: ";
        string = this.numberRounds == 0 ? string + "No limit" : string + this.numberRounds;
        string = string + "\n";
        string = string + "  Points to reach: ";
        string = this.numberPoints == 0 ? string + "  No goal" : string + this.numberPoints;
        string = string + "\n";
        string = string + "  Current round: " + this.currentRoundCount;
        System.out.println(string);
    }

    private void drawLine(String string, String string2, StyledDocument styledDocument) {
        try {
            Style style = styledDocument.getStyle(string2);
            if (string2.equals("icon")) {
                StyleConstants.setIcon(style, new ImageIcon(string));
            }
            styledDocument.insertString(styledDocument.getLength(), string, style);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void drawInfos(int n, int n2, StyledDocument styledDocument) {
        GatheringPoint gatheringPoint = (GatheringPoint)this.mapObjects.get(this.teamGP.get(n2));
        Vector<MapObject> vector = this.map.getFieldObjects(gatheringPoint.getPosition());
        boolean bl = false;
        String string = "";
        this.drawLine("pics/minigp.png", "icon", styledDocument);
        this.drawLine(" Squirrels currently at GP\n", "regular", styledDocument);
        this.drawLine("             ", "regular", styledDocument);
        for (MapObject object : vector) {
            if (!object.getClass().getName().equals("Squirrel")) continue;
            this.drawLine(object.getName() + " ", "bold", styledDocument);
            bl = true;
        }
        if (!bl) {
            this.drawLine("---", "regular", styledDocument);
        }
        this.drawLine("\n", "regular", styledDocument);
        this.drawLine("pics/mininut.png", "icon", styledDocument);
        this.drawLine("Nuts dropped\n", "regular", styledDocument);
        this.drawLine("             ", "regular", styledDocument);
        if (gatheringPoint.getStringOfNuts().equals("")) {
            this.drawLine("---\n", "bold", styledDocument);
        } else {
            this.drawLine(gatheringPoint.getStringOfNuts() + "\n", "regular", styledDocument);
        }
        this.drawLine("pics/minisum.png", "icon", styledDocument);
        this.drawLine("Total Points\n", "regular", styledDocument);
        this.drawLine("             ", "regular", styledDocument);
        this.drawLine(gatheringPoint.getSumValue() + "\n", "bold", styledDocument);
        this.drawLine("pics/minisq.png", "icon", styledDocument);
        this.drawLine("Squirrel   ", "regular", styledDocument);
        this.drawLine("Position   ", "regular", styledDocument);
        this.drawLine("pics/mininut.png", "icon", styledDocument);
        this.drawLine("Holds Nuts\n", "regular", styledDocument);
        for (String string2 : this.teamSquirrels.get(n2)) {
            Squirrel squirrel = (Squirrel)this.mapObjects.get(string2);
            if (squirrel.getStringOfNuts().equals("")) {
                this.drawLine("          " + squirrel.getName() + "        " + squirrel.getPositionString() + "             ---\n", "bold", styledDocument);
                continue;
            }
            this.drawLine("          " + squirrel.getName() + "        " + squirrel.getPositionString() + "            " + squirrel.getStringOfNuts() + "\n", "bold", styledDocument);
        }
    }

    private void drawMap(int n, int n2) {
        int n3;
        int n4 = this.map.getLengthX();
        int n5 = this.map.getLengthY();
        String string = "";
        Vector<MapObject> vector = null;
        String string2 = "";
        String string3 = "";
        String string4 = "....";
        String string5 = ".";
        String string6 = "****";
        for (n3 = 0; n3 <= n4 * 5; ++n3) {
            string = string + "-";
        }
        string = string + "\n";
        for (n3 = 0; n3 < n5; ++n3) {
            String string7;
            String string8;
            int n6;
            string = string + "|";
            for (n6 = 0; n6 < n4; ++n6) {
                if (!this.map.isEmptyField(new Position(n6, n3))) {
                    vector = this.map.getFieldObjects(new Position(n6, n3));
                    string8 = "    ";
                    for (MapObject mapObject : vector) {
                        string7 = mapObject.getClass().getName();
                        if (string7.equals("Squirrel")) {
                            string8 = " " + mapObject.getName() + " ";
                            continue;
                        }
                        if (string7.equals("Tree")) {
                            string8 = " " + mapObject.getName() + " ";
                            continue;
                        }
                        if (!string7.equals("GatheringPoint")) continue;
                        string2 = mapObject.getName() + " ";
                    }
                    string3 = string2.equals("") ? string8 + "|" : string2 + "|";
                    string2 = "";
                } else {
                    string3 = "    |";
                }
                if (n == 0) {
                    string = string + string3;
                }
                if (n != 1) continue;
                if (string3.startsWith("gp")) {
                    string = this.isVisibleField(new Position(n6, n3), n2) ? string + string3 : (this.isExplored(new Position(n6, n3), n2) ? string + string3.replaceAll(" ", string5) : string + string6 + "|");
                }
                if (string3.startsWith(" t")) {
                    string = this.isVisibleField(new Position(n6, n3), n2) ? string + string3 : (this.isExplored(new Position(n6, n3), n2) ? string + string3.replaceAll(" ", string5) : string + string6 + "|");
                }
                if (string3.startsWith(" s")) {
                    string = this.isVisibleField(new Position(n6, n3), n2) ? string + string3 : (this.isExplored(new Position(n6, n3), n2) ? string + string4 + "|" : string + string6 + "|");
                }
                if (!string3.startsWith("  ")) continue;
                string = this.isVisibleField(new Position(n6, n3), n2) ? string + string3 : (this.isExplored(new Position(n6, n3), n2) ? string + string4 + "|" : string + string6 + "|");
            }
            string = string + "\n|";
            for (n6 = 0; n6 < n4; ++n6) {
                if (!this.map.isEmptyField(new Position(n6, n3))) {
                    vector = this.map.getFieldObjects(new Position(n6, n3));
                    string8 = "    ";
                    for (MapObject mapObject : vector) {
                        string7 = mapObject.getClass().getName();
                        if (string7.equals("Nut")) {
                            string8 = " " + mapObject.getName() + " ";
                            continue;
                        }
                        if (!string7.equals("GatheringPoint")) continue;
                        string2 = "    ";
                    }
                    string3 = string2.equals("") ? string8 + "|" : string2 + "|";
                    string2 = "";
                } else {
                    string3 = "    |";
                }
                if (n == 0) {
                    string = string + string3;
                }
                if (n != 1) continue;
                if (string3.startsWith(" n")) {
                    string = this.isVisibleField(new Position(n6, n3), n2) ? string + string3 : (this.isExplored(new Position(n6, n3), n2) ? string + string4 + "|" : string + string6 + "|");
                }
                if (!string3.startsWith("  ")) continue;
                string = this.isVisibleField(new Position(n6, n3), n2) ? string + string3 : (this.isExplored(new Position(n6, n3), n2) ? string + string4 + "|" : string + string6 + "|");
            }
            string = string + "\n";
            for (n6 = 0; n6 <= n4 * 5; ++n6) {
                string = string + "-";
            }
            string = string + "\n";
        }
        System.out.println(string.substring(0, string.length() - 1));
    }

    private boolean isExplored(Position position, int n) {
        TreeSet<Position> treeSet = this.getExploredFields(n);
        return treeSet.contains(position);
    }

    public String moveInput(int n, String string) {
        this.log.debug("******************************************************************************************");
        this.log.debug(n + ": Received move from player ");
        this.log.debug("numberPoints: " + this.numberPoints + "  numberRounds: " + this.numberRounds + "  gameFinished: " + this.gameFinished + "  currentRoundCount: " + this.currentRoundCount + "  teamID1: " + this.teamID1 + "  teamID2: " + this.teamID2 + "  teamAllowed: " + this.teamAllowed + "  teamError1 null?: " + (this.errorTeam1 == null) + "  teamError2 null?: " + (this.errorTeam2 == null) + "  softError: " + this.softError);
        this.log.info("#####################");
        this.log.info(n + ": Move from player");
        this.log.info("\n" + string + "\n");
        if (this.teamAllowed != n) {
            this.log.error(n + ": Player not allowed to move");
            this.draw();
            return new Error(4, 0).getStringFromError();
        }
        this.log.debug(n + ": Player allowed to move");
        this.log.debug(n + ": Setting error to null and filling canMove");
        this.error = null;
        this.canMove = (Vector)this.teamSquirrels.get(this.teamAllowed).clone();
        Vector<Move> vector = null;
        this.log.info(n + ": Parsing move, checking for syntax and converting into Move object(s)");
        try {
            vector = this.parseMoveList(string);
        }
        catch (ParseException parseException) {
            if (this.numberTeams == 1) {
                ++this.currentRoundCount;
            }
            this.log.error(n + ": No matching brackets or forbidden chars in movelist");
            this.error = new Error(1, 0);
        }
        if (!this.softError) {
            this.log.debug(n + ": softError false, resetting aatr");
            this.alreadyAccessedThisRound.put(n, new TreeSet());
        }
        this.softError = false;
        if (this.numberTeams == 1) {
            if (this.error != null) {
                this.log.info("Sending response to player: " + this.error.getStringFromError());
                this.draw();
                return this.error.getStringFromError();
            }
            this.log.info("Processing Move");
            boolean bl = this.processMovelist(vector);
            if (!bl) {
                this.reverseMoves(vector);
            }
            if (!this.softError) {
                ++this.currentRoundCount;
            }
            if (this.isFinishedGame() && !this.softError) {
                this.gameFinished = true;
                this.draw();
                return this.generateEndInfos(n);
            }
            if (!bl) {
                this.log.info("Sending response to player: " + this.error.getStringFromError());
                this.draw();
                return this.error.getStringFromError();
            }
            this.log.info("Sending response to player: " + this.getMapString(n));
            this.draw();
            return this.getMapString(n);
        }
        if (this.error == null) {
            this.log.info("Processing Movelist");
            boolean bl = this.processMovelist(vector);
            if (!bl) {
                this.log.debug("Error while processing");
                this.reverseMoves(vector);
            }
        }
        if (this.starting) {
            this.starting = false;
            this.teamAllowed = this.teamID2;
            this.teamNotAllowed = this.teamID1;
            if (this.error != null) {
                this.errorTeam1 = new Error(this.error.id(), this.error.moveNumber());
            }
            this.draw();
            return this.getStartingInfosSecond();
        }
        if (this.isFinishedGame() && !this.softError && this.teamAllowed == this.teamID2) {
            this.gameFinished = true;
            this.draw();
            return this.generateEndInfos(this.getOppID(n));
        }
        if (this.error == null || this.error.type() == Error.ErrorType.HARD) {
            if (this.teamAllowed == this.teamID1) {
                this.teamAllowed = this.teamID2;
                this.teamNotAllowed = this.teamID1;
                if (this.error != null) {
                    this.errorTeam1 = new Error(this.error.id(), this.error.moveNumber());
                }
                String string2 = this.generateOutput(n);
                this.errorTeam2 = null;
                this.error = null;
                if (!this.softError && n == this.teamID2) {
                    ++this.currentRoundCount;
                }
                this.draw();
                return string2;
            }
            this.teamAllowed = this.teamID1;
            this.teamNotAllowed = this.teamID2;
            if (this.error != null) {
                this.errorTeam2 = new Error(this.error.id(), this.error.moveNumber());
            }
            String string3 = this.generateOutput(n);
            this.errorTeam1 = null;
            this.error = null;
            if (!this.softError && n == this.teamID2) {
                ++this.currentRoundCount;
            }
            this.draw();
            return string3;
        }
        this.draw();
        return this.error.getStringFromError();
    }

    private String generateOutput(int n) {
        if (n == this.teamID1) {
            String string = this.getMapString(this.teamID2);
            if (this.errorTeam2 != null) {
                string = "(" + string + this.errorTeam2.getStringFromError() + ")";
            }
            return string;
        }
        String string = this.getMapString(this.teamID1);
        if (this.errorTeam1 != null) {
            string = "(" + string + this.errorTeam1.getStringFromError() + ")";
        }
        return string;
    }

    private void reverseMoves(Vector<Move> vector) {
        if (this.error == null) {
            this.log.error("error NULL");
            return;
        }
        int n = this.error.moveNumber();
        for (int i = n - 2; i >= 0; --i) {
            this.reverseMove(vector.get(i));
        }
    }

    private void reverseMove(Move move) {
        Object object;
        Object object2;
        Squirrel squirrel;
        if (move.command().equals("go")) {
            this.log.debug("Reversing go move");
            squirrel = (Squirrel)this.mapObjects.get(move.squirrel());
            object2 = this.alreadyExplored.get(squirrel.getTeamID());
            object = new Position(move.param1(), move.param2());
            Position position = squirrel.getLastPos();
            if (!squirrel.accessedBefore()) {
                ((TreeSet)object2).remove(object);
            }
            this.map.removeObject(squirrel, squirrel.getPosition());
            squirrel.setPosition(position, true);
            this.map.addObject(squirrel, squirrel.getPosition());
            this.log.debug("Reversed");
        }
        if (move.command().equals("take")) {
            this.log.debug("Reversing take move");
            squirrel = (Squirrel)this.mapObjects.get(move.squirrel());
            object2 = squirrel.getNutWithType(move.param1());
            squirrel.removeLoad((Nut)object2);
            this.map.addObject((MapObject)object2, squirrel.getPosition());
            this.log.debug("Reversed");
        }
        if (move.command().equals("drop")) {
            this.log.debug("Reversing drop move");
            squirrel = (Squirrel)this.mapObjects.get(move.squirrel());
            if (this.map.hasGP(squirrel.getPosition())) {
                object2 = this.map.getGP(squirrel.getPosition());
                object = this.nutTypes.get(move.param1());
                this.log.info("REVERSE MOVE: REMOVED NUT: " + ((GatheringPoint)object2).removeNut((Nut)object));
                squirrel.addLoad((Nut)object);
                return;
            }
            object2 = this.map.getNutWithType(move.param1(), squirrel.getPosition());
            this.map.removeObject((MapObject)object2, squirrel.getPosition());
            squirrel.addLoad((Nut)object2);
            this.log.debug("Reversed");
        }
        if (move.command().equals("give")) {
            this.log.debug("Reversing give move");
            squirrel = (Squirrel)this.mapObjects.get(move.squirrel());
            object2 = (Squirrel)this.mapObjects.get(move.param2());
            object = ((Squirrel)object2).getNutWithType(move.param1());
            ((Squirrel)object2).removeLoad((Nut)object);
            squirrel.addLoad((Nut)object);
            this.log.debug("Reversed");
        }
    }

    private boolean processMovelist(Vector<Move> vector) {
        for (Move move : vector) {
            if (!this.isAllowedToMove(move)) {
                this.error = new Error(5, move.moveNumber());
                this.log.debug(move.squirrel() + " not allowed to move");
                return false;
            }
            if (this.isValidMove(move)) {
                this.log.debug("Zug " + move.moveNumber() + " ist valid");
                this.execMove(move);
                continue;
            }
            return false;
        }
        this.log.info("Movelist processed successfully");
        return true;
    }

    private boolean isAllowedToMove(Move move) {
        if (this.mapObjects == null || !this.mapObjects.containsKey(move.squirrel())) {
            this.error = new Error(6, move.moveNumber());
            return false;
        }
        MapObject mapObject = this.mapObjects.get(move.squirrel());
        if (!mapObject.getClass().getName().equals("Squirrel")) {
            this.error = new Error(6, move.moveNumber());
            return false;
        }
        if (!this.canMove.contains(move.squirrel())) {
            this.error = new Error(7, move.moveNumber());
            return false;
        }
        return true;
    }

    private boolean isValidMove(Move move) {
        if (move.command().equals("go")) {
            return this.isValidGo(move);
        }
        if (move.command().equals("take")) {
            return this.isValidTake(move);
        }
        if (move.command().equals("drop")) {
            return this.isValidDrop(move);
        }
        if (move.command().equals("give")) {
            return this.isValidGive(move);
        }
        return false;
    }

    private boolean isValidGo(Move move) {
        Position position = new Position(move.param1(), move.param2());
        Squirrel squirrel = (Squirrel)this.mapObjects.get(move.squirrel());
        if (!this.map.existsField(position)) {
            this.error = new Error(14, move.moveNumber());
            return false;
        }
        if (position.equals(squirrel.getPosition())) {
            return true;
        }
        if (this.jump) {
            if (this.isVisibleField(position, squirrel.getTeamID())) {
                if (this.map.isAccessibleField(position)) {
                    return true;
                }
                this.error = new Error(15, move.moveNumber());
                return false;
            }
            if (this.isAdjacentToExploredFields(position, squirrel.getTeamID(), squirrel.getType())) {
                if (this.map.isAccessibleField(position)) {
                    return true;
                }
                this.log.debug("HIER SOFT / HARD");
                this.softOrHardError(squirrel, position, move.moveNumber());
                return false;
            }
            this.error = new Error(16, move.moveNumber());
            return false;
        }
        if (this.map.isAdjacentField(squirrel.getPosition(), position, squirrel.getType())) {
            if (this.map.isAccessibleField(position)) {
                return true;
            }
            if (this.sight == 0) {
                this.softOrHardError(squirrel, position, move.moveNumber());
                return false;
            }
            this.error = new Error(15, move.moveNumber());
            return false;
        }
        this.error = new Error(17, move.moveNumber());
        return false;
    }

    private boolean isValidTake(Move move) {
        Squirrel squirrel = (Squirrel)this.mapObjects.get(move.squirrel());
        if (this.map.hasNutType(move.param1(), squirrel.getPosition())) {
            Nut nut = this.map.getNutWithType(move.param1(), squirrel.getPosition());
            if (nut.getCapacity() <= squirrel.getCapacity()) {
                return true;
            }
            this.error = new Error(9, move.moveNumber());
            return false;
        }
        this.error = new Error(8, move.moveNumber());
        return false;
    }

    private boolean isValidDrop(Move move) {
        Squirrel squirrel = (Squirrel)this.mapObjects.get(move.squirrel());
        if (this.map.isDropableField(squirrel.getPosition())) {
            if (squirrel.hasNutType(move.param1())) {
                return true;
            }
            this.log.debug("Squirrel has no nut with this type");
            this.error = new Error(10, move.moveNumber());
            return false;
        }
        this.log.debug("Nut not dropable at field");
        this.error = new Error(11, move.moveNumber());
        return false;
    }

    private boolean isValidGive(Move move) {
        Squirrel squirrel = (Squirrel)this.mapObjects.get(move.squirrel());
        if (!this.mapObjects.containsKey(move.param2()) || !this.mapObjects.get(move.param2()).getClass().getName().equals("Squirrel")) {
            this.error = new Error(6, move.moveNumber());
            return false;
        }
        if (!squirrel.hasNutType(move.param1())) {
            this.error = new Error(10, move.moveNumber());
            return false;
        }
        Squirrel squirrel2 = (Squirrel)this.mapObjects.get(move.param2());
        Nut nut = this.nutTypes.get(move.param1());
        if (squirrel.getTeamID() != squirrel2.getTeamID()) {
            this.error = new Error(12, move.moveNumber());
            return false;
        }
        if (!this.map.isAdjacentField(squirrel.getPosition(), squirrel2.getPosition(), squirrel.getType())) {
            this.error = new Error(13, move.moveNumber());
            return false;
        }
        if (squirrel2.getCapacity() < nut.getCapacity()) {
            this.error = new Error(9, move.moveNumber());
            return false;
        }
        return true;
    }

    private void execMove(Move move) {
        Object object;
        Iterator<Position> iterator;
        Object object2;
        if (move.command().equals("go")) {
            object2 = (Squirrel)this.mapObjects.get(move.squirrel());
            iterator = this.alreadyExplored.get(((Squirrel)object2).getTeamID());
            object = new Position(move.param1(), move.param2());
            boolean bl = false;
            if (((TreeSet)((Object)iterator)).contains(object)) {
                bl = true;
            }
            this.map.removeObject((MapObject)object2, ((Squirrel)object2).getPosition());
            ((Squirrel)object2).setPosition((Position)object, bl);
            this.map.addObject((MapObject)object2, ((Squirrel)object2).getPosition());
            ((TreeSet)((Object)iterator)).add(new Position(new Position(((Squirrel)object2).getPosition())));
            this.log.debug("Executed Go move: " + move.getStringFromMove());
        }
        if (move.command().equals("take")) {
            object2 = (Squirrel)this.mapObjects.get(move.squirrel());
            iterator = this.map.getNutWithType(move.param1(), ((Squirrel)object2).getPosition());
            this.map.removeObject((MapObject)((Object)iterator), ((Squirrel)object2).getPosition());
            ((Squirrel)object2).addLoad((Nut)((Object)iterator));
            this.log.debug("Executed Take move: " + move.getStringFromMove());
        }
        if (move.command().equals("drop")) {
            object2 = (Squirrel)this.mapObjects.get(move.squirrel());
            iterator = ((Squirrel)object2).getNutWithType(move.param1());
            ((Squirrel)object2).removeLoad((Nut)((Object)iterator));
            if (this.map.hasGP(((Squirrel)object2).getPosition())) {
                object = this.map.getGP(((Squirrel)object2).getPosition());
                ((GatheringPoint)object).addNut((Nut)((Object)iterator));
                this.log.debug("Nut added to GP");
            } else {
                this.map.addObject((MapObject)((Object)iterator), ((Squirrel)object2).getPosition());
            }
            this.log.debug("Executed Drop move: " + move.getStringFromMove());
        }
        if (move.command().equals("give")) {
            object2 = (Squirrel)this.mapObjects.get(move.squirrel());
            iterator = (Squirrel)this.mapObjects.get(move.param2());
            object = ((Squirrel)object2).getNutWithType(move.param1());
            ((Squirrel)object2).removeLoad((Nut)object);
            ((Squirrel)((Object)iterator)).addLoad((Nut)object);
            this.log.debug("Executed Give move: " + move.getStringFromMove());
        }
        object2 = this.getExploredFields(this.teamAllowed);
        iterator = ((TreeSet)object2).iterator();
        while (iterator.hasNext()) {
            object = (Position)iterator.next();
            this.log.debug(((Position)object).getPositionString());
        }
        this.canMove.remove(move.squirrel());
        iterator = ((TreeSet)object2).iterator();
        while (iterator.hasNext()) {
            object = (Position)iterator.next();
            this.log.debug(((Position)object).getPositionString());
        }
    }

    private void softOrHardError(Squirrel squirrel, Position position, int n) {
        TreeSet<Position> treeSet = this.alreadyAccessed.get(squirrel.getTeamID());
        TreeSet<Position> treeSet2 = this.alreadyAccessedThisRound.get(squirrel.getTeamID());
        TreeSet<Position> treeSet3 = this.getExploredFields(squirrel.getTeamID());
        for (Position position2 : treeSet2) {
            if (!position.equals(position2)) continue;
            this.error = new Error(18, n);
            return;
        }
        if (this.map.hasSquirrel(position)) {
            this.softError = true;
            this.error = new Error(20, n);
            treeSet2.add(new Position(position));
            return;
        }
        if (this.map.hasTree(position)) {
            for (Position position2 : treeSet) {
                if (!position.equals(position2)) continue;
                this.error = new Error(19, n);
                return;
            }
            for (Position position2 : treeSet3) {
                if (!position.equals(position2)) continue;
                this.error = new Error(19, n);
                return;
            }
        }
        this.softError = true;
        this.error = new Error(21, n);
        treeSet2.add(new Position(position));
        treeSet.add(new Position(position));
    }

    private boolean isVisibleField(Position position, int n) {
        TreeSet<Position> treeSet = this.getVisibleFields(n);
        for (Position position2 : treeSet) {
            if (!position2.equals(position)) continue;
            return true;
        }
        return false;
    }

    private TreeSet<Position> getExploredFields(int n) {
        TreeSet<Position> treeSet = this.alreadyExplored.get(n);
        TreeSet<Position> treeSet2 = new TreeSet<Position>();
        TreeSet<Position> treeSet3 = this.alreadyAccessed.get(n);
        int n2 = this.map.getLengthX();
        int n3 = this.map.getLengthY();
        if (this.sight != -1) {
            for (Position position : treeSet) {
                int n4 = position.x_i() - this.sight;
                int n5 = position.y_i() - this.sight;
                int n6 = position.x_i() + this.sight;
                int n7 = position.y_i() + this.sight;
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n6 >= n2) {
                    n6 = n2 - 1;
                }
                if (n7 >= n3) {
                    n7 = n3 - 1;
                }
                for (int i = n4; i <= n6; ++i) {
                    for (int j = n5; j <= n7; ++j) {
                        treeSet2.add(new Position(i, j));
                    }
                }
            }
            for (Position position : treeSet3) {
                treeSet2.add(new Position(position));
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    treeSet2.add(new Position(i, j));
                }
            }
        }
        return treeSet2;
    }

    private boolean isAdjacentToExploredFields(Position position, int n, Squirrel.Type type) {
        TreeSet<Position> treeSet = this.getExploredFields(n);
        for (Position position2 : treeSet) {
            if (!this.map.isAdjacentField(position2, position, type)) continue;
            return true;
        }
        return false;
    }

    private TreeSet<Position> getVisibleFields(int n) {
        TreeSet<Position> treeSet = new TreeSet<Position>();
        Vector<String> vector = this.teamSquirrels.get(n);
        int n2 = this.map.getLengthX();
        int n3 = this.map.getLengthY();
        if (this.sight != -1) {
            for (String string : vector) {
                Squirrel squirrel = (Squirrel)this.mapObjects.get(string);
                Position position = new Position(squirrel.getPos());
                int n4 = position.x_i() - this.sight;
                int n5 = position.y_i() - this.sight;
                int n6 = position.x_i() + this.sight;
                int n7 = position.y_i() + this.sight;
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n6 >= n2) {
                    n6 = n2 - 1;
                }
                if (n7 >= n3) {
                    n7 = n3 - 1;
                }
                for (int i = n4; i <= n6; ++i) {
                    for (int j = n5; j <= n7; ++j) {
                        treeSet.add(new Position(i, j));
                    }
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    treeSet.add(new Position(i, j));
                }
            }
        }
        return treeSet;
    }

    private Vector<Move> parseMoveList(String string) throws ParseException {
        int n;
        string = string.toLowerCase();
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        Simple3.ReInit(bufferedReader);
        Simple3.Input();
        String[] stringArray = string.split("\\)+ *");
        String[][] stringArrayArray = new String[stringArray.length][];
        for (n = 0; n < stringArray.length; ++n) {
            stringArrayArray[n] = stringArray[n].replaceFirst("[( ]+", "").split("[( )]+");
        }
        n = 0;
        Vector<Move> vector = new Vector<Move>();
        for (String[] stringArray2 : stringArrayArray) {
            if (!this.syntacticallyCorrect(stringArray2, ++n)) continue;
            vector.add(this.convertMove(stringArray2, n));
        }
        return vector;
    }

    private boolean syntacticallyCorrect(String[] stringArray, int n) {
        if (stringArray.length != 3 && stringArray.length != 4) {
            if (this.error == null) {
                this.error = new Error(2, n);
            }
            return false;
        }
        if (stringArray[0].matches("s[0-9]+")) {
            if (stringArray[1].equals("go") && stringArray.length == 4 && stringArray[2].matches("[0-9]+") && stringArray[3].matches("[0-9]+")) {
                return true;
            }
            if (stringArray[1].equals("take") && stringArray.length == 3 && stringArray[2].matches("n[0-9]+")) {
                return true;
            }
            if (stringArray[1].equals("drop") && stringArray.length == 3 && stringArray[2].matches("n[0-9]+")) {
                return true;
            }
            if (stringArray[1].equals("give") && stringArray.length == 4 && stringArray[2].matches("n[0-9]+") && stringArray[3].matches("s[0-9]+")) {
                return true;
            }
            if (this.error == null) {
                this.error = new Error(3, n);
            }
            return false;
        }
        if (this.error == null) {
            this.error = new Error(3, n);
        }
        return false;
    }

    private Move convertMove(String[] stringArray, int n) {
        if (stringArray.length == 3) {
            return new Move(n, stringArray[0], stringArray[1], stringArray[2]);
        }
        return new Move(n, stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
    }

    public int getOppID(int n) {
        if (this.teamID1 == n) {
            return this.teamID2;
        }
        return this.teamID1;
    }

    public boolean gameFinished() {
        return this.gameFinished;
    }

    public boolean softErrorOccured() {
        return this.softError;
    }

    public void resetSoftError() {
        this.softError = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameGoal {
        CLEARMAP,
        MOREPOINTS;

    }
}

