/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.xmlrpc.WebServer;

public class Server {
    private static String conf = "server.conf";
    private static String paragraph = "[Enabled Game Types]";
    private static int port = 8080;
    private static String file1P = null;
    private static String file2P = null;
    private static String fileInfS = null;
    private static String fileUninfS = null;
    private static boolean allowed1P = false;
    private static boolean allowed2P = false;
    private static boolean allowedInfS = false;
    private static boolean allowedUninfS = false;
    private static boolean gui = false;
    private static Logger log = Logger.getLogger(Server.class);
    private static StringReader sr = new StringReader("()");
    private static Reader r = new BufferedReader(sr);
    public static Simple3 parser = new Simple3(r);
    private Hashtable<Integer, Game> runningGames = new Hashtable();
    private Hashtable<Integer, GameSearch> runningSearchGames = new Hashtable();
    private Vector<Integer> occupiedIDs = new Vector();
    private Vector<Integer> waitingPlayers = new Vector();
    private Hashtable<Integer, String> readyToMove = new Hashtable();
    private String searchHelp = "(\"In Uninformed and Informed Search games there exists one type of commands. In Uninformed Search the command consists of the letter of the position you want to jump to, e.g. (u). In Informed Search the command consists of the X- and Y-coordinates of the position you want to jump to, e.g. (2 5) \")";
    private String pHelp = "(\"In this version exist four types of commands. In every command you have to submit the name of the squirrel you want to command, the command it should perform and the parameters:\n\n- Go: Moves the squirrel to a field. Example: (s1 go 3 2)\n- Take: Let the squirrel take a nut. Example: (s2 take n1)\n- Drop: Let the squirrel drop a nut. Example: (s2 drop n2)\n- Give: Let the squirrel give a nut to a squirral at an adjacent field. Example: (s2 give n1 s1)\")";

    public Server() {
        this.startLogger();
    }

    private void startLogger() {
        PatternLayout patternLayout = new PatternLayout("%m\n");
        FileAppender fileAppender = null;
        ConsoleAppender consoleAppender = null;
        try {
            fileAppender = new FileAppender((Layout)patternLayout, "logs/server.log");
            consoleAppender = new ConsoleAppender((Layout)patternLayout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.addAppender(fileAppender);
        log.setLevel(Level.ALL);
    }

    public Hashtable regSearch(String string) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (!allowedUninfS && string.equals("uis")) {
            hashtable.put("id", new Integer(0));
            hashtable.put("output", "(Stop \"uninformed search game not enabled\")");
            return hashtable;
        }
        if (!allowedInfS && string.equals("is")) {
            hashtable.put("id", new Integer(0));
            hashtable.put("output", "(Stop \"informed search game not enabled\")");
            return hashtable;
        }
        int n = this.getFreeID();
        log.info((Object)(n + ": New player registered for informed/uninformed search game"));
        int[] nArray = new int[]{n, 0};
        try {
            GameSearch gameSearch = null;
            if (string.equals("is")) {
                log.info((Object)(n + ": Creating informed search game"));
                gameSearch = new GameSearch(fileInfS, nArray, "infs", gui);
            } else if (string.equals("uis")) {
                log.info((Object)(n + ": Creating uninformed search game"));
                gameSearch = new GameSearch(fileUninfS, nArray, "uninfs", gui);
            } else {
                this.occupiedIDs.removeElement(n);
                log.error((Object)(n + ": No such gametype: " + string));
                hashtable.put("id", n);
                hashtable.put("output", "(Stop \"No such gametype\")");
            }
            gameSearch.draw();
            String string2 = gameSearch.getStartingInfosFirst();
            hashtable.put("id", new Integer(n));
            hashtable.put("output", string2);
            if (this.runningSearchGames.containsKey(n)) {
                log.error((Object)(n + ": Id already existing in runningiSearchGames"));
                hashtable.put("output", "(Stop \"Internal server error. Please restart the game!\")");
            } else {
                this.runningSearchGames.put(n, gameSearch);
            }
        }
        catch (ParserException parserException) {
            System.out.println(n + "PARSER ERROR: " + parserException);
            hashtable.put("output", "(Stop \"Internal server error. Please restart the game!\")");
            this.occupiedIDs.removeElement(n);
            return hashtable;
        }
        log.info((Object)(n + ": Sending register response to player"));
        return hashtable;
    }

    public Hashtable reg1P() {
        System.out.println("REG BEGINN");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (!allowed1P) {
            hashtable.put("id", new Integer(0));
            hashtable.put("output", "(Stop \"1-Player game not enabled\")");
            return hashtable;
        }
        int n = this.getFreeID();
        log.info((Object)(n + ": New player registered for 1-Player game"));
        int[] nArray = new int[]{n, 0};
        try {
            log.info((Object)(n + ": Creating 1-Player game"));
            Game game = new Game(file1P, nArray, gui);
            game.draw();
            String string = game.getStartingInfosFirst();
            hashtable.put("id", new Integer(n));
            hashtable.put("output", string);
            if (this.runningGames.containsKey(n)) {
                log.error((Object)(n + ": Id already existing in runningGames"));
                hashtable.put("output", "(Stop \"Internal server error. Please restart the game!\")");
            } else {
                this.runningGames.put(n, game);
            }
        }
        catch (ParserException parserException) {
            hashtable.put("output", "(Stop \"Internal server error. Please restart the game!\")");
            System.out.println(n + "PARSER ERROR: " + parserException);
            this.occupiedIDs.removeElement(n);
        }
        log.error((Object)(n + ": Sending register response to player"));
        return hashtable;
    }

    public Hashtable reg2P(boolean bl) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (!allowed2P) {
            hashtable.put("id", new Integer(0));
            hashtable.put("output", "(Stop \"2-Player game not enabled\")");
            return hashtable;
        }
        int n = this.getFreeID();
        log.info((Object)(n + ": New player registered "));
        if (bl) {
            log.info((Object)(n + ": Player wants to create game - Joining waiting list"));
            this.waitingPlayers.add(n);
            int n2 = 0;
            while (!this.runningGames.containsKey(n)) {
                try {
                    if (++n2 == 10) {
                        hashtable.put("id", new Integer(n));
                        hashtable.put("output", "(Stop Reconnect)");
                        this.occupiedIDs.removeElement(n);
                        this.waitingPlayers.removeElement(n);
                        log.debug((Object)(n + ": No opponent found -> Sending \"Reconnect\" to player (Checks if player is still connected)"));
                        return hashtable;
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    System.out.println("error " + exception);
                }
            }
            log.info((Object)(n + ": Found opponent"));
            Game game = this.runningGames.get(n);
            game.draw();
            String string = game.getStartingInfosFirst();
            log.info((Object)(n + ": Getting starting infos for player"));
            hashtable.put("id", new Integer(n));
            hashtable.put("output", string);
            log.info((Object)(n + ": Sending starting infos to player"));
            return hashtable;
        }
        log.info((Object)(n + ": Waiting for opponent"));
        int n3 = 0;
        while (this.waitingPlayers.isEmpty()) {
            try {
                if (++n3 == 10) {
                    hashtable.put("id", new Integer(n));
                    hashtable.put("output", "(Stop Reconnect)");
                    this.occupiedIDs.removeElement(n);
                    this.waitingPlayers.removeElement(n);
                    log.debug((Object)(n + ": No opponent found -> Sending \"Reconnect\" to player (Checks if player is still connected)"));
                    return hashtable;
                }
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                System.out.println("error " + exception);
            }
        }
        if (this.waitingPlayers.isEmpty()) {
            log.error((Object)(n + ": Wanted oppid not present in waitingPlayers anymore (concurrency?)"));
            this.occupiedIDs.removeElement(n);
            hashtable.put("output", "(Stop \"Internal server error. Please restart the game!\")");
            return hashtable;
        }
        int n4 = this.waitingPlayers.remove(0);
        log.info((Object)(n + ": Opponent found: " + n4));
        int[] nArray = new int[]{n4, n};
        log.info((Object)(n + ": Creating game with " + n4));
        try {
            Game game = new Game(file2P, nArray, gui);
            log.info((Object)(n + ": Notifying " + n4));
            if (this.runningGames.containsKey(n) || this.runningGames.containsKey(n4)) {
                log.error((Object)("id " + n4 + " or " + n + " already exist in runningGames (concurrency issue?)"));
                this.occupiedIDs.removeElement(n);
                this.occupiedIDs.removeElement(n4);
                hashtable.put("output", "(Stop \"Internal server error. Please restart the game!\")");
                return hashtable;
            }
            this.runningGames.put(n, game);
            this.runningGames.put(n4, game);
        }
        catch (ParserException parserException) {
            hashtable.put("output", "(Stop \"Internal server error. Please restart the game!\")");
            System.out.println(n + "PARSER ERROR: " + parserException);
            this.occupiedIDs.removeElement(n);
            this.occupiedIDs.removeElement(n4);
            return hashtable;
        }
        this.readyToMove.put(n, "");
        this.readyToMove.put(n4, "");
        log.info((Object)(n + ": Waiting for " + n4 + " making his first move"));
        n3 = 0;
        while (this.readyToMove.get(n).equals("")) {
            try {
                Thread.sleep(1000L);
                if (++n3 != 60) continue;
                hashtable.put("id", new Integer(n));
                hashtable.put("output", "(Stop Reconnect \"Opponent disconnected or timeout\")");
                this.occupiedIDs.removeElement(n);
                this.occupiedIDs.removeElement(n4);
                this.runningGames.remove(n);
                this.runningGames.remove(n4);
                return hashtable;
            }
            catch (Exception exception) {
                System.out.println("error " + exception);
            }
        }
        hashtable.put("id", new Integer(n));
        hashtable.put("output", this.readyToMove.get(n));
        this.readyToMove.put(n, "");
        log.info((Object)(n + ": Sending response to player "));
        return hashtable;
    }

    public String submitMoveSearch(int n, String string) {
        log.info((Object)(n + ": Move from player"));
        if (!this.runningSearchGames.containsKey(n)) {
            log.info((Object)(n + " No match for id existing"));
            return "(Stop \"No such game available\")";
        }
        if (string.toLowerCase().startsWith("(help)")) {
            return this.searchHelp;
        }
        GameSearch gameSearch = this.runningSearchGames.get(n);
        String string2 = gameSearch.moveInput(n, string.toLowerCase());
        if (string2.startsWith("(Stop")) {
            this.runningSearchGames.remove(n);
            this.occupiedIDs.removeElement(n);
        }
        log.info((Object)(n + ": Sending response to player"));
        return string2;
    }

    public String submitMove1P(int n, String string) {
        log.info((Object)(n + ": Move from player"));
        if (!this.runningGames.containsKey(n)) {
            log.info((Object)(n + " No match for id existing"));
            return "(Stop \"No such game available\")";
        }
        if (string.toLowerCase().startsWith("(help)")) {
            return this.pHelp;
        }
        Game game = this.runningGames.get(n);
        String string2 = game.moveInput(n, string.toLowerCase());
        if (string2.startsWith("(Stop")) {
            log.info((Object)(n + ": Removing game and making id available"));
            this.runningGames.remove(n);
            this.occupiedIDs.removeElement(n);
        }
        log.info((Object)(n + ": Sending response to player"));
        return string2;
    }

    public String submitMove2P(int n, String string) {
        log.info((Object)(n + ": Move from player"));
        if (!this.runningGames.containsKey(n)) {
            log.info((Object)(n + " No match for id existing"));
            return "(Stop \"No such game available\")";
        }
        if (string.toLowerCase().startsWith("(help)")) {
            return this.pHelp;
        }
        Game game = this.runningGames.get(n);
        String string2 = game.moveInput(n, string.toLowerCase());
        int n2 = game.getOppID(n);
        if (string2.startsWith("(Error 4")) {
            return string2;
        }
        if (string2.startsWith("(Error 20") || string2.startsWith("Error 21")) {
            log.info((Object)(n + ": Soft error occured, rerequesting move"));
            return string2;
        }
        if (string2.startsWith("(Stop")) {
            String string3 = game.generateEndInfos(n);
            this.occupiedIDs.removeElement(n);
            this.occupiedIDs.removeElement(n2);
            this.runningGames.remove(n);
            this.runningGames.remove(n2);
            this.readyToMove.put(n2, string2);
            return string3;
        }
        log.info((Object)(n2 + ": Sending response to player"));
        this.readyToMove.put(n2, string2);
        log.info((Object)(n + ": Waiting for answer from Server"));
        int n3 = 0;
        while (this.readyToMove.get(n).equals("")) {
            try {
                Thread.sleep(1000L);
                if (++n3 != 100) continue;
                this.occupiedIDs.removeElement(n);
                this.occupiedIDs.removeElement(n2);
                this.runningGames.remove(n);
                this.runningGames.remove(n2);
                return "(Stop \"Opponent disconnected or timeout\")";
            }
            catch (Exception exception) {
                System.out.println("error " + exception);
            }
        }
        String string4 = this.readyToMove.get(n);
        this.readyToMove.put(n, "");
        log.info((Object)(n + ": Sending response to player"));
        return string4;
    }

    private int getFreeID() {
        int n;
        Random random = new Random();
        do {
            if ((n = random.nextInt() % 1000) >= 0) continue;
            n = -n;
        } while (this.occupiedIDs.contains(n));
        this.occupiedIDs.add(n);
        return n;
    }

    private static void parseConf() throws ParserException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(conf)));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).equals("") || string.startsWith("//")) continue;
                if (string.startsWith("[Files]")) {
                    paragraph = "[Files]";
                }
                if (string.startsWith("[")) continue;
                if (paragraph.equals("[Enabled Game Types]")) {
                    Server.parseGameTypes(string);
                }
                if (!paragraph.equals("[Files]")) continue;
                Server.parseFiles(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Exception: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
        if (allowedUninfS && fileUninfS == null) {
            throw new ParserException("\nError: No file for enabled uninformed search game specified");
        }
        if (allowedInfS && fileInfS == null) {
            throw new ParserException("\nError: No file for enabled informed search game specified");
        }
        if (allowed1P && file1P == null) {
            throw new ParserException("\nError: No file for enabled 1-Player game specified");
        }
        if (allowed2P && file2P == null) {
            throw new ParserException("\nError: No file for enabled 2-Player game specified");
        }
    }

    private static void parseGameTypes(String string) throws ParserException {
        String[] stringArray = string.split("[ \\s]+");
        if (stringArray.length != 2) {
            throw new ParserException("\nLine: " + string + "\nError: Too much or too few arguments");
        }
        if (stringArray[0].equals("UninformedSearch")) {
            if (stringArray[1].equals("true")) {
                allowedUninfS = true;
            } else if (stringArray[1].equals("false")) {
                allowedUninfS = false;
            } else {
                throw new ParserException("\nLine: " + string + "\nError: Value must be true or false");
            }
        }
        if (stringArray[0].equals("InformedSearch")) {
            if (stringArray[1].equals("true")) {
                allowedInfS = true;
            } else if (stringArray[1].equals("false")) {
                allowedInfS = false;
            } else {
                throw new ParserException("\nLine: " + string + "\nError: Value must be true or false");
            }
        }
        if (stringArray[0].equals("OnePlayer")) {
            if (stringArray[1].equals("true")) {
                allowed1P = true;
            } else if (stringArray[1].equals("false")) {
                allowed1P = false;
            } else {
                throw new ParserException("\nLine: " + string + "\nError: Value must be true or false");
            }
        }
        if (stringArray[0].equals("TwoPlayer")) {
            if (stringArray[1].equals("true")) {
                allowed2P = true;
            } else if (stringArray[1].equals("false")) {
                allowed2P = false;
            } else {
                throw new ParserException("\nLine: " + string + "\nError: Value must be true or false");
            }
        }
    }

    private static void parseFiles(String string) throws ParserException {
        String[] stringArray = string.split("[ \\s]+");
        if (stringArray.length != 2) {
            throw new ParserException("\nLine: " + string + "\nError: Too much or too few arguments");
        }
        if (stringArray[0].equals("UninformedSearch")) {
            fileUninfS = stringArray[1];
        }
        if (stringArray[0].equals("InformedSearch")) {
            fileInfS = stringArray[1];
        }
        if (stringArray[0].equals("OnePlayer")) {
            file1P = stringArray[1];
        }
        if (stringArray[0].equals("TwoPlayer")) {
            file2P = stringArray[1];
        }
        if (stringArray[0].equals("Port") && stringArray[1].matches("[1-9][0-9]*")) {
            port = new Integer(stringArray[1]);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length == 1) {
            if (stringArray[0].equals("gui")) {
                gui = true;
            } else {
                System.out.println("Unknown Argument");
                return;
            }
        }
        try {
            GameSearch gameSearch;
            Game game;
            System.out.print("Parsing server.conf...");
            Server.parseConf();
            System.out.println("OK");
            object = new int[]{12345, 0};
            int[] nArray = new int[]{12345, 54321};
            System.out.println("Testing enabled games");
            if (allowed1P) {
                System.out.print("Testing 1-Player game...");
                game = new Game(file1P, (int[])object, gui);
                System.out.println("OK");
            }
            if (allowed2P) {
                System.out.print("Testing 2-Player game...");
                game = new Game(file2P, nArray, gui);
                System.out.println("OK");
            }
            if (allowedInfS) {
                System.out.print("Testing informed search game...");
                gameSearch = new GameSearch(fileInfS, (int[])object, "infs", gui);
                System.out.println("OK");
            }
            if (allowedUninfS) {
                System.out.print("Testing uninformed search game...");
                gameSearch = new GameSearch(fileUninfS, (int[])object, "uninfs", gui);
                System.out.println("OK");
            }
            System.out.println("All tests ok!");
        }
        catch (ParserException parserException) {
            System.out.println("PARSER ERRROR: " + parserException);
            return;
        }
        object = new WebServer(port);
        object.addHandler("squirrel", (Object)new Server());
        System.out.print("Starte Server...");
        object.start();
        System.out.print("gestartet\n");
    }
}

