/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class GatheringPoint
extends MapObject {
    private final int teamID;
    private Vector<Nut> gatheredNuts;
    private int sumValue;

    GatheringPoint(int n, String string, Position position) {
        super(string, position);
        this.teamID = n;
        this.sumValue = 0;
        this.gatheredNuts = new Vector();
    }

    public int getTeamID() {
        return this.teamID;
    }

    public int getSumValue() {
        return this.sumValue;
    }

    public String getPositionString() {
        return "(" + this.pos.x_s() + " " + this.pos.y_s() + ")";
    }

    public Position getPosition() {
        return this.pos;
    }

    boolean hasNut(Nut nut) {
        return this.gatheredNuts.contains(nut);
    }

    boolean addNut(Nut nut) {
        this.sumValue += nut.getValue();
        return this.gatheredNuts.add(nut);
    }

    boolean removeNut(Nut nut) {
        this.sumValue -= nut.getValue();
        return this.gatheredNuts.remove(nut);
    }

    public String getStringOfNuts() {
        String string = "";
        for (Nut nut : this.gatheredNuts) {
            string = string + nut.getName() + " ";
        }
        return string;
    }
}

