/*
 * Decompiled with CFR 0.152.
 */
public class Error {
    private int id;
    private int moveNumber;
    private String description;
    private ErrorType type;

    Error(int n, int n2) {
        this.id = n;
        this.moveNumber = n2;
        switch (this.id) {
            case 1: {
                this.description = "No bracket matching or forbidden chars in movelist";
                this.type = ErrorType.HARD;
                break;
            }
            case 2: {
                this.description = "Wrong number of arguments in move";
                this.type = ErrorType.HARD;
                break;
            }
            case 3: {
                this.description = "One or move move arguments wrong";
                this.type = ErrorType.HARD;
                break;
            }
            case 4: {
                this.description = "Player not allowed to move";
                this.type = ErrorType.HARD;
                break;
            }
            case 5: {
                this.description = "Squirrel not allowed to move";
                this.type = ErrorType.HARD;
                break;
            }
            case 6: {
                this.description = "Squirrel could not be found";
                this.type = ErrorType.HARD;
                break;
            }
            case 7: {
                this.description = "Squirrel already moved this round";
                this.type = ErrorType.HARD;
                break;
            }
            case 8: {
                this.description = "Nut Type not existing on field";
                this.type = ErrorType.HARD;
                break;
            }
            case 9: {
                this.description = "Not enough capacity to take nut";
                this.type = ErrorType.HARD;
                break;
            }
            case 10: {
                this.description = "Squirrel has no nut with this type";
                this.type = ErrorType.HARD;
                break;
            }
            case 11: {
                this.description = "Nut not dropable at field";
                this.type = ErrorType.HARD;
                break;
            }
            case 12: {
                this.description = "Squirrel not in your team";
                this.type = ErrorType.HARD;
                break;
            }
            case 13: {
                this.description = "Squirrel not at adjacent field";
                this.type = ErrorType.HARD;
                break;
            }
            case 14: {
                this.description = "Field does not exist";
                this.type = ErrorType.HARD;
                break;
            }
            case 15: {
                this.description = "Field not accessible";
                this.type = ErrorType.HARD;
                break;
            }
            case 16: {
                this.description = "Field not adjacent to explored fields";
                this.type = ErrorType.HARD;
                break;
            }
            case 17: {
                this.description = "Field not adjacent to squirrel";
                this.type = ErrorType.HARD;
                break;
            }
            case 18: {
                this.description = "Already accessed or explored occupied field this round -> You could have known that this field is not accessible";
                this.type = ErrorType.HARD;
                break;
            }
            case 19: {
                this.description = "Already accessed or explored field occupied with a tree before. You could have known that.";
                this.type = ErrorType.HARD;
                break;
            }
            case 20: {
                this.description = "Field is occupied by a Squirrel but you could not know that. Move again";
                this.type = ErrorType.SOFT;
                break;
            }
            case 21: {
                this.description = "Field is occupied by a Tree but you could not know that. Move again";
                this.type = ErrorType.SOFT;
                break;
            }
            case 30: {
                this.description = "No such symbolic Position";
                this.type = ErrorType.HARD;
                break;
            }
            default: {
                this.description = "Undefined Error";
                this.type = ErrorType.HARD;
            }
        }
    }

    Error(int n, ErrorType errorType, int n2, String string) {
        this.type = errorType;
        this.id = n;
        this.description = string;
        this.moveNumber = n2;
    }

    public int id() {
        return this.id;
    }

    public String description() {
        return this.description;
    }

    public ErrorType type() {
        return this.type;
    }

    public int moveNumber() {
        return this.moveNumber;
    }

    public String getStringFromError() {
        return "(Error " + this.id + " " + this.moveNumber + " " + (Object)((Object)this.type) + " " + "\"" + this.description + "\")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorType {
        HARD,
        SOFT;

    }
}

