/*
 * MainGUI.java
 *
 * Created on 18. Mai 2005, 16:59
 */

package ISSearch;

import java.net.*;
import java.io.*;
import java.lang.*;
import javax.swing.*;

/**
 *
 * @author  jhd
 */
public class MainGUI extends javax.swing.JFrame {
    
    static ISCrawler c = new ISCrawler();
    static ISDBCrawler dbcrawler = new ISDBCrawler();
    static ISDB isdb = new ISDB();
    static MainGUI m = new MainGUI();
    
    
    /** Creates new form MainGUI */
    public MainGUI() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        startURLTextField = new javax.swing.JTextField();
        startURLLabel = new javax.swing.JLabel();
        crawlingDepthLabel = new javax.swing.JLabel();
        crawlingDepthTextField = new javax.swing.JTextField();
        maxQueueSizeLabel = new javax.swing.JLabel();
        maxQueueSizeTextField = new javax.swing.JTextField();
        maxTimeoutLabel = new javax.swing.JLabel();
        maxTimeoutTextField = new javax.swing.JTextField();
        crawlerControlLabel = new javax.swing.JLabel();
        applyHintLabel = new javax.swing.JLabel();
        crawlerStateLabel = new javax.swing.JLabel();
        informationList = new java.awt.List();
        informationLabel = new javax.swing.JLabel();
        currentJobLabel = new javax.swing.JLabel();
        databaseInformationLabel = new javax.swing.JLabel();
        usernameLabel = new javax.swing.JLabel();
        usernameTextField = new javax.swing.JTextField();
        passwordLabel = new javax.swing.JLabel();
        passwordTextField = new javax.swing.JPasswordField();
        hostnameLabel = new javax.swing.JLabel();
        hostnameTextField = new javax.swing.JTextField();
        portLabel = new javax.swing.JLabel();
        portTextField = new javax.swing.JTextField();
        servicenameLabel = new javax.swing.JLabel();
        servicenameTextField = new javax.swing.JTextField();
        mainProgressBar = new javax.swing.JProgressBar();
        searchQueryLabel = new javax.swing.JLabel();
        searchQueryTextField = new javax.swing.JTextField();
        sendQueryButton = new javax.swing.JButton();
        separatorBeforSearchQueryLabel = new javax.swing.JLabel();
        progressLabel = new javax.swing.JLabel();
        separatorAfterSearchQueryLabel = new javax.swing.JLabel();
        urlComboBox = new javax.swing.JComboBox();
        gotoURLButton = new javax.swing.JButton();
        separatorAfterGotoURLLabel = new javax.swing.JLabel();
        searchResultLabel = new javax.swing.JLabel();
        browserLauncherHintLabel = new javax.swing.JLabel();
        mainMenuBar = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        setDefaultsMenuItem = new javax.swing.JMenuItem();
        beforeClearSeparator = new javax.swing.JSeparator();
        clearSearchItemsMenuItem = new javax.swing.JMenuItem();
        clearLogMenuItem = new javax.swing.JMenuItem();
        beforeCloseSeparator = new javax.swing.JSeparator();
        exitMenuItem = new javax.swing.JMenuItem();
        crawlerMenu = new javax.swing.JMenu();
        crawlerstartMenuItem = new javax.swing.JMenuItem();
        crawlerstopMenuItem = new javax.swing.JMenuItem();
        crawlerresetMenuItem = new javax.swing.JMenuItem();
        beforeCreateFeaturesSeparator = new javax.swing.JSeparator();
        createFeaturesMenuItem = new javax.swing.JMenuItem();
        createFeaturesCheckBoxMenuItem = new javax.swing.JCheckBoxMenuItem();
        databaseMenu = new javax.swing.JMenu();
        createSchemaMenuItem = new javax.swing.JMenuItem();
        dropSchemaMenuItem = new javax.swing.JMenuItem();

        getContentPane().setLayout(null);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setResizable(false);
        startURLTextField.setText("http://www.mpi-sb.mpg.de/units/ag5/teaching/ss05/is05/links.htm");
        startURLTextField.setToolTipText("Start-URL of the crawler.");
        getContentPane().add(startURLTextField);
        startURLTextField.setBounds(90, 18, 510, 20);

        startURLLabel.setText("Start URL:");
        getContentPane().add(startURLLabel);
        startURLLabel.setBounds(20, 20, 80, 14);

        crawlingDepthLabel.setText("Crawling Depth:");
        getContentPane().add(crawlingDepthLabel);
        crawlingDepthLabel.setBounds(20, 70, 90, 14);

        crawlingDepthTextField.setText("2");
        crawlingDepthTextField.setToolTipText("Sets the maximum crawling depth of the crawler.");
        getContentPane().add(crawlingDepthTextField);
        crawlingDepthTextField.setBounds(120, 68, 40, 20);

        maxQueueSizeLabel.setText("Maximum Queue Size:");
        getContentPane().add(maxQueueSizeLabel);
        maxQueueSizeLabel.setBounds(190, 70, 140, 14);

        maxQueueSizeTextField.setText("500");
        maxQueueSizeTextField.setToolTipText("Sets the maximum queue size of the crawler.");
        getContentPane().add(maxQueueSizeTextField);
        maxQueueSizeTextField.setBounds(330, 68, 40, 20);

        maxTimeoutLabel.setText("Maximum Timeout (in ms):");
        getContentPane().add(maxTimeoutLabel);
        maxTimeoutLabel.setBounds(400, 70, 160, 14);

        maxTimeoutTextField.setText("2000");
        maxTimeoutTextField.setToolTipText("Sets the maximum timeout (in ms) for a website.");
        getContentPane().add(maxTimeoutTextField);
        maxTimeoutTextField.setBounds(560, 68, 40, 20);

        crawlerControlLabel.setText("Crawler:");
        getContentPane().add(crawlerControlLabel);
        crawlerControlLabel.setBounds(30, 550, 70, 14);

        applyHintLabel.setText("IMPORTANT: To apply your settings for the crawler click \"Reset / Apply\" from the Crawler menu.");
        getContentPane().add(applyHintLabel);
        applyHintLabel.setBounds(20, 110, 560, 14);

        crawlerStateLabel.setText("---");
        getContentPane().add(crawlerStateLabel);
        crawlerStateLabel.setBounds(90, 550, 150, 14);

        informationList.setFont(new java.awt.Font("Tahoma", 1, 12));
        getContentPane().add(informationList);
        informationList.setBounds(20, 170, 580, 330);

        getContentPane().add(informationLabel);
        informationLabel.setBounds(110, 144, 490, 20);

        currentJobLabel.setText("Current Job:");
        getContentPane().add(currentJobLabel);
        currentJobLabel.setBounds(20, 144, 100, 20);

        databaseInformationLabel.setText("Login information:  (Oracle Database)");
        getContentPane().add(databaseInformationLabel);
        databaseInformationLabel.setBounds(660, 20, 220, 20);

        usernameLabel.setText("Username:");
        getContentPane().add(usernameLabel);
        usernameLabel.setBounds(660, 60, 80, 14);

        usernameTextField.setText("IR2031259");
        usernameTextField.setToolTipText("Database user.");
        getContentPane().add(usernameTextField);
        usernameTextField.setBounds(750, 60, 230, 20);

        passwordLabel.setText("Password:");
        getContentPane().add(passwordLabel);
        passwordLabel.setBounds(660, 100, 80, 14);

        passwordTextField.setFont(new java.awt.Font("Tahoma", 0, 11));
        passwordTextField.setText("18041982");
        passwordTextField.setToolTipText("Database password for specified user.");
        getContentPane().add(passwordTextField);
        passwordTextField.setBounds(750, 100, 230, 20);

        hostnameLabel.setText("Hostname:");
        getContentPane().add(hostnameLabel);
        hostnameLabel.setBounds(660, 140, 80, 14);

        hostnameTextField.setText("mpiat5400.ag5.mpi-sb.mpg.de");
        hostnameTextField.setToolTipText("Hostname which hosts the database.");
        getContentPane().add(hostnameTextField);
        hostnameTextField.setBounds(750, 140, 230, 20);

        portLabel.setText("Port:");
        getContentPane().add(portLabel);
        portLabel.setBounds(660, 180, 80, 14);

        portTextField.setText("1521");
        portTextField.setToolTipText("Port which listens to database connections.");
        getContentPane().add(portTextField);
        portTextField.setBounds(750, 180, 230, 20);

        servicenameLabel.setText("Servicename:");
        getContentPane().add(servicenameLabel);
        servicenameLabel.setBounds(660, 220, 80, 14);

        servicenameTextField.setText("students");
        servicenameTextField.setToolTipText("Servicename for the database.");
        getContentPane().add(servicenameTextField);
        servicenameTextField.setBounds(750, 220, 230, 20);

        getContentPane().add(mainProgressBar);
        mainProgressBar.setBounds(20, 520, 580, 16);

        searchQueryLabel.setText("Search Query:");
        getContentPane().add(searchQueryLabel);
        searchQueryLabel.setBounds(640, 300, 120, 14);

        searchQueryTextField.setToolTipText("Enter your query here.");
        getContentPane().add(searchQueryTextField);
        searchQueryTextField.setBounds(640, 330, 340, 20);

        sendQueryButton.setText("Go");
        sendQueryButton.setToolTipText("Submit your query.");
        sendQueryButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sendQueryButtonActionPerformed(evt);
            }
        });

        getContentPane().add(sendQueryButton);
        sendQueryButton.setBounds(640, 360, 340, 23);

        separatorBeforSearchQueryLabel.setText("________________________________________________");
        getContentPane().add(separatorBeforSearchQueryLabel);
        separatorBeforSearchQueryLabel.setBounds(640, 280, 360, 14);

        progressLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        progressLabel.setText("0 / 0");
        getContentPane().add(progressLabel);
        progressLabel.setBounds(450, 540, 150, 14);

        separatorAfterSearchQueryLabel.setText("________________________________________________");
        getContentPane().add(separatorAfterSearchQueryLabel);
        separatorAfterSearchQueryLabel.setBounds(640, 400, 360, 14);

        getContentPane().add(urlComboBox);
        urlComboBox.setBounds(640, 450, 340, 22);

        gotoURLButton.setText("Go to URL");
        gotoURLButton.setToolTipText("Go to the selected URL.");
        gotoURLButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                gotoURLButtonActionPerformed(evt);
            }
        });

        getContentPane().add(gotoURLButton);
        gotoURLButton.setBounds(640, 490, 340, 23);

        separatorAfterGotoURLLabel.setText("________________________________________________");
        getContentPane().add(separatorAfterGotoURLLabel);
        separatorAfterGotoURLLabel.setBounds(640, 550, 360, 14);

        searchResultLabel.setText("Search Result:");
        getContentPane().add(searchResultLabel);
        searchResultLabel.setBounds(640, 420, 140, 14);

        browserLauncherHintLabel.setText("Uses code from http://browserlauncher.sourceforge.net/");
        browserLauncherHintLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                browserLauncherHintLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                browserLauncherHintLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                browserLauncherHintLabelMouseExited(evt);
            }
        });

        getContentPane().add(browserLauncherHintLabel);
        browserLauncherHintLabel.setBounds(640, 530, 350, 20);

        fileMenu.setMnemonic('F');
        fileMenu.setText("File");
        setDefaultsMenuItem.setMnemonic('d');
        setDefaultsMenuItem.setText("Set Defaults");
        setDefaultsMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setDefaultsMenuItemActionPerformed(evt);
            }
        });

        fileMenu.add(setDefaultsMenuItem);

        fileMenu.add(beforeClearSeparator);

        clearSearchItemsMenuItem.setMnemonic('R');
        clearSearchItemsMenuItem.setText("Clear Search");
        clearSearchItemsMenuItem.setToolTipText("Clears the \"Search Query\" textbox and the \"Search Results\" dropdown list.");
        clearSearchItemsMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearSearchItemsMenuItemActionPerformed(evt);
            }
        });

        fileMenu.add(clearSearchItemsMenuItem);

        clearLogMenuItem.setMnemonic('L');
        clearLogMenuItem.setText("Clear Log");
        clearLogMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearLogMenuItemActionPerformed(evt);
            }
        });

        fileMenu.add(clearLogMenuItem);

        fileMenu.add(beforeCloseSeparator);

        exitMenuItem.setMnemonic('C');
        exitMenuItem.setText("Close");
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuItemActionPerformed(evt);
            }
        });

        fileMenu.add(exitMenuItem);

        mainMenuBar.add(fileMenu);

        crawlerMenu.setMnemonic('C');
        crawlerMenu.setText("Crawler");
        crawlerstartMenuItem.setMnemonic('S');
        crawlerstartMenuItem.setText("Start");
        crawlerstartMenuItem.setToolTipText("Starts the crawler.");
        crawlerstartMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                crawlerstartMenuItemActionPerformed(evt);
            }
        });

        crawlerMenu.add(crawlerstartMenuItem);

        crawlerstopMenuItem.setMnemonic('T');
        crawlerstopMenuItem.setText("Stop");
        crawlerstopMenuItem.setToolTipText("Stops the crawler.");
        crawlerstopMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                crawlerstopMenuItemActionPerformed(evt);
            }
        });

        crawlerMenu.add(crawlerstopMenuItem);

        crawlerresetMenuItem.setMnemonic('R');
        crawlerresetMenuItem.setText("Reset / Apply");
        crawlerresetMenuItem.setToolTipText("Stops and resets the crawler and applies the settings fom the textfields.");
        crawlerresetMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                crawlerresetMenuItemActionPerformed(evt);
            }
        });

        crawlerMenu.add(crawlerresetMenuItem);

        crawlerMenu.add(beforeCreateFeaturesSeparator);

        createFeaturesMenuItem.setMnemonic('F');
        createFeaturesMenuItem.setText("(Re)Create Features");
        createFeaturesMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                createFeaturesMenuItemActionPerformed(evt);
            }
        });

        crawlerMenu.add(createFeaturesMenuItem);

        createFeaturesCheckBoxMenuItem.setMnemonic('A');
        createFeaturesCheckBoxMenuItem.setSelected(true);
        createFeaturesCheckBoxMenuItem.setText("Automatically Create Features");
        createFeaturesCheckBoxMenuItem.setToolTipText("Sets if the features should be created automatically after a crawl.");
        crawlerMenu.add(createFeaturesCheckBoxMenuItem);

        mainMenuBar.add(crawlerMenu);

        databaseMenu.setMnemonic('D');
        databaseMenu.setText("Database");
        createSchemaMenuItem.setMnemonic('C');
        createSchemaMenuItem.setText("Create Scheme");
        createSchemaMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                createSchemaMenuItemActionPerformed(evt);
            }
        });

        databaseMenu.add(createSchemaMenuItem);

        dropSchemaMenuItem.setMnemonic('D');
        dropSchemaMenuItem.setText("Drop Scheme");
        dropSchemaMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dropSchemaMenuItemActionPerformed(evt);
            }
        });

        databaseMenu.add(dropSchemaMenuItem);

        mainMenuBar.add(databaseMenu);

        setJMenuBar(mainMenuBar);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents

    private void clearLogMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearLogMenuItemActionPerformed
// TODO add your handling code here:
        if(JOptionPane.showConfirmDialog(m, "Do you really want to clear the log?", m.getTitle(), JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION) {
            m.informationList.removeAll();
            m.informationLabel.setText("");
        }
    }//GEN-LAST:event_clearLogMenuItemActionPerformed

    private void browserLauncherHintLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_browserLauncherHintLabelMouseExited
// TODO add your handling code here:
        m.browserLauncherHintLabel.setForeground(java.awt.Color.BLACK);
    }//GEN-LAST:event_browserLauncherHintLabelMouseExited

    private void browserLauncherHintLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_browserLauncherHintLabelMouseEntered
// TODO add your handling code here:
        m.browserLauncherHintLabel.setForeground(java.awt.Color.BLUE);
    }//GEN-LAST:event_browserLauncherHintLabelMouseEntered

    private void browserLauncherHintLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_browserLauncherHintLabelMouseClicked
// TODO add your handling code here:
        BrowserLauncher b = new BrowserLauncher();
        try {
            b.openURL("http://browserlauncher.sourceforge.net/");
        } catch(IOException e) {
            System.err.println(e.toString());
        }
    }//GEN-LAST:event_browserLauncherHintLabelMouseClicked

    private void clearSearchItemsMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearSearchItemsMenuItemActionPerformed
// TODO add your handling code here:
        if(JOptionPane.showConfirmDialog(m, "Do you really want to clear the Search fields?", m.getTitle(), JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION) {
            m.searchQueryTextField.setText("");
            m.urlComboBox.removeAllItems();
        }
    }//GEN-LAST:event_clearSearchItemsMenuItemActionPerformed

    private void gotoURLButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_gotoURLButtonActionPerformed
// TODO add your handling code here:
        String url = null;
        try {
            url = m.urlComboBox.getItemAt(m.urlComboBox.getSelectedIndex()).toString();
        } catch(NullPointerException e) {
            return;
        }
        try {
            BrowserLauncher b = new BrowserLauncher();
            b.openURL(url);
        } catch(IOException e) {
            System.err.println(e.toString());
        }
    }//GEN-LAST:event_gotoURLButtonActionPerformed

    private void setDefaultsMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setDefaultsMenuItemActionPerformed
// TODO add your handling code here:
        m.setDefaults();
    }//GEN-LAST:event_setDefaultsMenuItemActionPerformed

    private void createFeaturesMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_createFeaturesMenuItemActionPerformed
// TODO add your handling code here:
        ISDBCrawler dbcrawler = new ISDBCrawler();
        ISDB isdb = new ISDB();
        m.addInformation("Opening connection to database...");
        boolean dbopen_success = dbcrawler.openDB();
        if (!dbopen_success)
        {
            System.err.println("openDB failed!");
            m.addInformation("openDB failed!");
            return;
        } else {
            m.addInformation("Connection established.");
        }
        isdb = dbcrawler.isdb;
        m.enableItems(false);
        isdb.createFeatures();
        dbcrawler.closeDB();
        m.addInformation("Closing connection to database...");
        m.enableItems(true);
    }//GEN-LAST:event_createFeaturesMenuItemActionPerformed

    private void sendQueryButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sendQueryButtonActionPerformed
// TODO add your handling code here:
        ISQueryProcessor qp = new ISQueryProcessor();
        URL[] urls = new URL[10];
        String query = m.searchQueryTextField.getText().toString();
        
        try {
            if(query.equals("")) return;
        } catch (NullPointerException e) {
            return;
        }
        
        urls = qp.executeQuery(query);
        
        m.urlComboBox.removeAllItems();

        m.addInformation("");
        m.addInformation("Result(s) for query '" + query + "':");
        try {
            for(int i=0; i<urls.length; i++) {
                m.addInformation(urls[i].toString());
            }
        } catch (NullPointerException e) {
            //nix
        }
        
        try {
            for(int i=0; i<urls.length; i++) {
                m.urlComboBox.addItem(urls[i].toString());
            }
        } catch (NullPointerException e) {
            //nix
        }
        
        m.informationLabel.setText("");
        
    }//GEN-LAST:event_sendQueryButtonActionPerformed

    private void crawlerresetMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_crawlerresetMenuItemActionPerformed
// TODO add your handling code here:
            c.reset();
            m.init();
            m.crawlerStateLabel.setText("Reset / Apply");
            m.enableItems(true);
            m.enableItems(true);
    }//GEN-LAST:event_crawlerresetMenuItemActionPerformed

    private void crawlerstopMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_crawlerstopMenuItemActionPerformed
// TODO add your handling code here:
            c.stop();
            m.crawlerStateLabel.setText("Stop");
    }//GEN-LAST:event_crawlerstopMenuItemActionPerformed

    private void crawlerstartMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_crawlerstartMenuItemActionPerformed
// TODO add your handling code here:
            c.start();
            m.crawlerStateLabel.setText("Start");
            m.enableItems(false);
    }//GEN-LAST:event_crawlerstartMenuItemActionPerformed

    private void dropSchemaMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dropSchemaMenuItemActionPerformed
// TODO add your handling code here:
        if(JOptionPane.showConfirmDialog(m, "Do you really want to drop the scheme?", m.getTitle(), JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION) {
            ISDBCrawler dbcrawler = new ISDBCrawler();
            m.addInformation("Opening connection to database...");
            boolean dbopen_success = dbcrawler.openDB();
            if (!dbopen_success)
            {
                System.err.println("openDB failed!");
                m.addInformation("openDB failed!");
                return;
            } else {
                m.addInformation("Connection established.");
            }
            m.addInformation("Dropping scheme...");
        
            ISDB isdb = new ISDB();
            isdb = dbcrawler.isdb;
        
            isdb.dropSchema();
        
            dbcrawler.closeDB();
            m.addInformation("Closing connection to database...");
        }
    }//GEN-LAST:event_dropSchemaMenuItemActionPerformed

    private void createSchemaMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_createSchemaMenuItemActionPerformed
// TODO add your handling code here:
        if(JOptionPane.showConfirmDialog(m, "Do you really want to create a scheme?", m.getTitle(), JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION) {
            ISDBCrawler dbcrawler = new ISDBCrawler();
            m.addInformation("Opening connection to database...");
            boolean dbopen_success = dbcrawler.openDB();
            if (!dbopen_success)
            {
                System.err.println("openDB failed!");
                m.addInformation("openDB failed!");
                return;
            } else {
                m.addInformation("Connection established.");
            }
            m.addInformation("Creating scheme...");
            
            ISDB isdb = new ISDB();
            isdb = dbcrawler.isdb;
            
            isdb.createSchema();
        
            dbcrawler.closeDB();
            m.addInformation("Closing connection to database...");
            m.crawlerresetMenuItemActionPerformed(evt);
        }
    }//GEN-LAST:event_createSchemaMenuItemActionPerformed

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
// TODO add your handling code here:
        System.exit(0);
    }//GEN-LAST:event_exitMenuItemActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                //initializing GUI elements
                addInformation("Loading GUI... Please wait.");
                               
                m.setSize(1005,650);
                m.setLocationRelativeTo(null);
                m.setTitle("Search Engine Project - Informationssysteme SS05 - Uni Saarland");
                m.setVisible(true);
                init();
            }
        });
    }
    
    static void init() {       
            try {
                URL url = new URL(m.startURLTextField.getText());
                c.addLink(url);
                c.setCrawlingDepth(new Integer(m.crawlingDepthTextField.getText()));
                c.setQueueMaxSize(new Integer(m.maxQueueSizeTextField.getText()));
                c.setTimeout(new Integer(m.maxTimeoutTextField.getText()));
                m.updateProgressBar(0,0);
            } catch (MalformedURLException e) {
                //nix
            }
    }
    
    public static void setDefaults() {
        m.startURLTextField.setText("http://www.mpi-sb.mpg.de/units/ag5/teaching/ss05/is05/links.htm");
        m.crawlingDepthTextField.setText("2");
        m.maxQueueSizeTextField.setText("500");
        m.maxTimeoutTextField.setText("2000");
        m.hostnameTextField.setText("mpiat5400.ag5.mpi-sb.mpg.de");
        m.portTextField.setText("1521");
        m.servicenameTextField.setText("students");
    }
    
    public static void addInformation(String s) {
        m.informationLabel.setText(s);
        m.informationList.add(s);
        m.informationList.makeVisible(m.informationList.getItemCount()-1);
    }
    
    public String getUsername() {
        return m.usernameTextField.getText();
    }
    
    public String getPassword() {
        return m.passwordTextField.getText();
    }
    
    public String getHostname() {
        return m.hostnameTextField.getText();
    }
    
    public int getPort() {
        return (new Integer(m.portTextField.getText()));
    }
    
    public String getServicename() {
        return m.servicenameTextField.getText();
    }
    
    public void setInformationLabelText(String s) {
        m.informationLabel.setText(s);
    }
    
    public void setCrawlerStateLabelText(String s) {
        m.crawlerStateLabel.setText(s);
    }
    
    public void enableItems(boolean enabled) {
        m.createSchemaMenuItem.setEnabled(enabled);
        m.dropSchemaMenuItem.setEnabled(enabled);
        m.crawlerstartMenuItem.setEnabled(enabled);
        m.sendQueryButton.setEnabled(enabled);
        m.gotoURLButton.setEnabled(enabled);
        m.usernameTextField.setEnabled(enabled);
        m.passwordTextField.setEnabled(enabled);
        m.hostnameTextField.setEnabled(enabled);
        m.portTextField.setEnabled(enabled);
        m.servicenameTextField.setEnabled(enabled);
        m.createFeaturesMenuItem.setEnabled(enabled);
        m.setDefaultsMenuItem.setEnabled(enabled);
    }      
    
    public boolean getAutomaticCreation() {
        return m.createFeaturesCheckBoxMenuItem.isSelected();
    }
    
    public void setAutomaticCreation(boolean b) {
        m.createFeaturesCheckBoxMenuItem.setSelected(b);
    }
    
    public void updateProgressBar(int value, int maximum) {
        m.mainProgressBar.setMaximum(maximum);
        m.mainProgressBar.setValue(value);
        if ((value == 0) && (maximum == 0)) {
            m.progressLabel.setVisible(false);
        } else {
            m.progressLabel.setVisible(true);
        }
        m.progressLabel.setText(value + " / " + maximum);
    }
   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel applyHintLabel;
    private javax.swing.JSeparator beforeClearSeparator;
    private javax.swing.JSeparator beforeCloseSeparator;
    private javax.swing.JSeparator beforeCreateFeaturesSeparator;
    private javax.swing.JLabel browserLauncherHintLabel;
    private javax.swing.JMenuItem clearLogMenuItem;
    private javax.swing.JMenuItem clearSearchItemsMenuItem;
    private javax.swing.JLabel crawlerControlLabel;
    private javax.swing.JMenu crawlerMenu;
    private javax.swing.JLabel crawlerStateLabel;
    private javax.swing.JMenuItem crawlerresetMenuItem;
    private javax.swing.JMenuItem crawlerstartMenuItem;
    private javax.swing.JMenuItem crawlerstopMenuItem;
    private javax.swing.JLabel crawlingDepthLabel;
    private javax.swing.JTextField crawlingDepthTextField;
    private javax.swing.JCheckBoxMenuItem createFeaturesCheckBoxMenuItem;
    private javax.swing.JMenuItem createFeaturesMenuItem;
    private javax.swing.JMenuItem createSchemaMenuItem;
    private javax.swing.JLabel currentJobLabel;
    private javax.swing.JLabel databaseInformationLabel;
    private javax.swing.JMenu databaseMenu;
    private javax.swing.JMenuItem dropSchemaMenuItem;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JButton gotoURLButton;
    private javax.swing.JLabel hostnameLabel;
    private javax.swing.JTextField hostnameTextField;
    private javax.swing.JLabel informationLabel;
    private java.awt.List informationList;
    private javax.swing.JMenuBar mainMenuBar;
    private javax.swing.JProgressBar mainProgressBar;
    private javax.swing.JLabel maxQueueSizeLabel;
    private javax.swing.JTextField maxQueueSizeTextField;
    private javax.swing.JLabel maxTimeoutLabel;
    private javax.swing.JTextField maxTimeoutTextField;
    private javax.swing.JLabel passwordLabel;
    private javax.swing.JPasswordField passwordTextField;
    private javax.swing.JLabel portLabel;
    private javax.swing.JTextField portTextField;
    private javax.swing.JLabel progressLabel;
    private javax.swing.JLabel searchQueryLabel;
    private javax.swing.JTextField searchQueryTextField;
    private javax.swing.JLabel searchResultLabel;
    private javax.swing.JButton sendQueryButton;
    private javax.swing.JLabel separatorAfterGotoURLLabel;
    private javax.swing.JLabel separatorAfterSearchQueryLabel;
    private javax.swing.JLabel separatorBeforSearchQueryLabel;
    private javax.swing.JLabel servicenameLabel;
    private javax.swing.JTextField servicenameTextField;
    private javax.swing.JMenuItem setDefaultsMenuItem;
    private javax.swing.JLabel startURLLabel;
    private javax.swing.JTextField startURLTextField;
    private javax.swing.JComboBox urlComboBox;
    private javax.swing.JLabel usernameLabel;
    private javax.swing.JTextField usernameTextField;
    // End of variables declaration//GEN-END:variables
    
}
