package ISSearch;

import java.net.*;
import java.util.*;
import java.sql.*;
import java.lang.Math;
import oracle.jdbc.*;
import oracle.sql.*;
import javax.swing.*;

/**
 * This class is used to open and close the database connection, to prepare
 * the DB schema (tables and indexes) for storage, and to store crawled data into this schema.
 * @see Connection
 * @see ResultSet
 * @see Statement
 * @see PreparedStatement
 * @see OracleConnection
 * @see DriverManager
 */
public class ISDB implements ISDBinterface
{
    Connection connection = null;
    boolean openDatabase = false;
    
    MainGUI m = new MainGUI();
    
    public ISDB()
    {
    }
    
   /**
    * Opens the Database connection to the Oracle instance specified by input parameters.
    * @param user the Oracle user name
    * @param password the database password
    * @param hostname the hostname (or IP address) of the Oracle server
    * @param port the port of the Oracle listener for connections over a TCP/IP network (standard is 1521)
    * @param service_name the name of the requested Oracle service 
    * @return true, if the connect was succesful; false otherwise.
    */
   public boolean openConnection(String user, String password, String hostname, int port, String service_name)
   {
       Connection con = null;
       Statement stmt = null;
       
       String driver = "oracle.jdbc.driver.OracleDriver";
       try {
           Class.forName(driver);
       } catch (Exception e) {
           System.err.println("error while loading jdbc driver");
           connection = con;
           return false;
       }
       
       try {
           String jdbcURL = "jdbc:oracle:thin:";
           String db = "(DESCRIPTION = (ADDRESS_LIST = (ADDRESS = " +
                   "(PROTOCOL = TCP)(HOST = " + hostname + ")(PORT = " + port + ")))" +
                   "(CONNECT_DATA = (SERVICE_NAME = " + service_name + ")))";
           
           con = DriverManager.getConnection(jdbcURL + "@" + db, user, password);
           con.setAutoCommit(false);
           connection = con;
           
           stmt = con.createStatement();
       } catch (Exception e) {
           System.err.println("error with jdbc connection");
           connection = con;
           openDatabase = false;
           return false;
       }
       openDatabase = true;
       return true;
   }
   
    /**
    * Closes the open database connection.
    */
   public void closeConnection()
   {
       try {
           connection.close();
           openDatabase = false;
       } catch (SQLException e) {
           while (e != null) {
               System.err.println(e.toString());
               m.addInformation(e.toString());
               System.err.println("SQL-State: " + e.getSQLState());
               m.addInformation("SQL-State: " + e.getSQLState());
               System.err.println("ErrorCode: " + e.getErrorCode());
               m.addInformation("ErrorCode: " + e.getErrorCode());
               e = e.getNextException();
           }
       } catch (NullPointerException e) {
           //nix
       }
   }
   
   /** Returns the current state of the database connection
    * @return true, if the database was successfully opened and is currently not yet closed.
    */
   public boolean isOpen()
   {
       return openDatabase;
   }
   
   /**
    * Returns the internal database connection of the database interface (only when it is open and valid). 
    * This method must return the current internal database connection (when available),  
    * it should NOT open any additional connections.
    * @return the database connection (when open and valid); null otherwise.
    */
   public Connection getConnection()
   {
       return connection;
   }
   
   public void setConnection(Connection con)
   {
       connection = con;
   }
   
   /** Stores the content of an ISDocument and its URL into the database. At least stems of all words
    * from the ISDocument and the absolute URL of the source Web document are required for the search engine; the storage of other available
    * informations (original words and positions, links) is optional.
    * @return true, if the storage attempt was successful; false otherwise.
    */
   public boolean store(URL url, ISDocumentInterface doc)
   {
       try {
           //getting a docid
           int docid = 0;
           Statement temp_stmt = connection.createStatement();
           ResultSet results_docid = temp_stmt.executeQuery("SELECT * FROM documents");
           while(results_docid.next()) docid++;
           System.out.println("docid: " + docid);
           results_docid.close();
           temp_stmt.close();
           
           //checking if the docid is already in the database
           temp_stmt = connection.createStatement();
           ResultSet isThere_docid = temp_stmt.executeQuery("SELECT * FROM documents WHERE url='" + url.toString() + "'");
           if (isThere_docid.next()) {
               System.out.println("URL already in database documents...");
               Statement temp_stmt2 = connection.createStatement();
               temp_stmt2.executeUpdate("DELETE FROM terms WHERE docid=(SELECT docid FROM documents WHERE url='" + url.toString() + "')");
               temp_stmt2.close();
               connection.commit();
           } else {
               m.addInformation("DBINFO: ADDING URL " + url.toString() + " TO TABLE documents...");
               Statement temp_stmt2 = connection.createStatement();
               temp_stmt2.executeUpdate("INSERT INTO documents VALUES('" + docid + "','" + url.toString() +"')");
               temp_stmt2.close();
               connection.commit();
           }
           isThere_docid.close();
           temp_stmt.close();
           
           String stem = null;
           String term = null;
           String doc_url = null;
           int pos = 0;
           ISParser p = new ISParser();
           
           for(int i=0; i<doc.getTerms().length; i++) {
               stem = doc.getTerms()[i].getStem();
               term = doc.getTerms()[i].getWord();
               doc_url = doc.getLink();
               pos = doc.getTerms()[i].getPos();
               ResultSet temp_rs_for_terms = null;
               
               //getting the docid for add the stem to table terms
               temp_stmt = connection.createStatement();
               temp_rs_for_terms = temp_stmt.executeQuery("SELECT docid FROM documents WHERE url='" + doc_url +"'");
               if(temp_rs_for_terms.next()) {
                   docid = temp_rs_for_terms.getInt(1);
               }
               temp_rs_for_terms.close();
               temp_stmt.close();
               
               //adding the stem to table terms if it is no stopword and not null. stem must have minimum length 3
               if((stem != null) && (!(p.isStopword(stem))) && (stem.length() > 2)) {
                   m.addInformation("DBINFO: ADDING TERM " + stem + " TO TABLE terms...");
                   temp_stmt = connection.createStatement();
                   temp_stmt.executeUpdate("INSERT INTO terms VALUES('" + docid + "','" + stem + "','" + term + "','" + pos + "')");
                   temp_stmt.close();
                   connection.commit();
               }
           }
       } catch (SQLException e) {           
           while (e != null) {
               System.err.println(e.toString());
               m.addInformation(e.toString());
               System.err.println("SQL-State: " + e.getSQLState());
               m.addInformation("SQL-State: " + e.getSQLState());
               System.err.println("ErrorCode: " + e.getErrorCode());
               m.addInformation("ErrorCode: " + e.getErrorCode());
               e = e.getNextException();
           }
           return false;
       }
       return true;
   }

   /** This method creates the database infrastructure that is required for storage of crawled information: relations (tables), 
    * index structures, and integrity constraints. At least stems of all words
    * from the ISDocument and the absolute URL of the source Web document are required for the search engine. Additionally, you should provide
    * data structures for document features (stem, RTF weight, TF*IDF weight) that will be computed from stored word stems after the crawl.
    * Of course, the schema must also contain information about associations between features, terms, and URLs (e.g. using unique Doc-IDs) to   
    * allow the keyword-based search on stored data.
    * @return true, if the schema was created successfully; false otherwise.
    */
   public boolean createSchema()
   {
       try {
           Statement temp_stmt = connection.createStatement();
           temp_stmt.executeUpdate("CREATE TABLE documents(docid INT NOT NULL PRIMARY KEY, url VARCHAR(255) NOT NULL)");
           temp_stmt.close();
           temp_stmt = connection.createStatement();
           temp_stmt.executeUpdate("CREATE TABLE terms(docid INT NOT NULL, stem VARCHAR(255) NOT NULL, word VARCHAR(255) NOT NULL, position INT NOT NULL)");
           temp_stmt.close();
           temp_stmt = connection.createStatement();
           temp_stmt.executeUpdate("CREATE TABLE features(docid INT NOT NULL, stem VARCHAR(255) NOT NULL, rtf FLOAT NOT NULL, tf FLOAT NOT NULL, idf FLOAT NOT NULL, tfidf FLOAT NOT NULL, PRIMARY KEY (docid, stem))");
           temp_stmt.close();
           connection.commit();
           
           m.addInformation("Scheme successfully created.");
           JOptionPane.showMessageDialog(m, "Scheme successfully created.", "Create Scheme", JOptionPane.INFORMATION_MESSAGE);
           return true;           
       } catch (SQLException e) {
           while (e != null) {
               System.err.println(e.toString());
               m.addInformation(e.toString());
               System.err.println("SQL-State: " + e.getSQLState());
               m.addInformation("SQL-State: " + e.getSQLState());
               System.err.println("ErrorCode: " + e.getErrorCode());
               m.addInformation("ErrorCode: " + e.getErrorCode());
               e = e.getNextException();
           }
           JOptionPane.showMessageDialog(m, "Error occured while creating scheme.", "Create Scheme", JOptionPane.ERROR_MESSAGE);
           return false;
       }
   }
   
   /**
    * This method drops all previously created schema elements (tables, associated indexes, and integrity contraints) to fully cleanup the database account 
    * for next experiment.
    */
   public void dropSchema()
   {
       try {
           Statement temp_stmt = connection.createStatement();
           temp_stmt.executeUpdate("DROP TABLE documents");
           temp_stmt.close();
           temp_stmt = connection.createStatement();
           temp_stmt.executeUpdate("DROP TABLE terms");
           temp_stmt.close();
           temp_stmt = connection.createStatement();
           temp_stmt.executeUpdate("DROP TABLE features");
           temp_stmt.close();
           connection.commit();
           
           m.addInformation("Scheme dropped.");
           JOptionPane.showMessageDialog(m, "Scheme dropped.", "Drop Scheme", JOptionPane.INFORMATION_MESSAGE);
       } catch (SQLException e) {           
           while (e != null) {
               System.err.println(e.toString());
               m.addInformation(e.toString());
               System.err.println("SQL-State: " + e.getSQLState());
               m.addInformation("SQL-State: " + e.getSQLState());
               System.err.println("ErrorCode: " + e.getErrorCode());
               m.addInformation("ErrorCode: " + e.getErrorCode());
               e = e.getNextException();
           }
           JOptionPane.showMessageDialog(m, "Error occured while dropping scheme.", "Drop Scheme", JOptionPane.ERROR_MESSAGE);
       }
   }
   
   /** This method creates document features from previously stored word stems and stores them (as well as associated feature weights) 
    * into additional schema tables. At least, the string of the word stem, the RTF weight, and the TF*IDF weight must be stored for each 
    * feature and document. Of course, the schema must also contain information about associations between features, terms, and URLs (e.g. using unique Doc-IDs) 
    * to allow keyword-based search on stored data.
    */
   public boolean createFeatures()
   {
       try {
           int N = 0;
           float rtf = 0; //relative term frequency
           float tf = 0; //term frequency (used for tf*idf)
           float df = 0; //document frequency (used for tf*idf where idf=N/df)
           int now = 0; //number of words
           
           ResultSet getting_terms = null;
           ResultSet temp = null;
           
           int temp_docid = 0;
           String temp_stem = null;
           
           boolean already_seen = false;
           
           //cleaning table features
           Statement temp_stmt = connection.createStatement();
           temp_stmt.executeUpdate("DELETE FROM features");
           temp_stmt.close();
           
           //getting N (total number of documents)
           temp_stmt = connection.createStatement();
           temp = temp_stmt.executeQuery("SELECT COUNT(*) FROM documents");
           temp.next();
           N = temp.getInt(1);
           System.out.println("Calculating N: " + N);
           temp.close();
           temp_stmt.close();
           
           temp_stmt = connection.createStatement();
           getting_terms = temp_stmt.executeQuery("SELECT * FROM terms ORDER BY docid");
           while(getting_terms.next()) {
               temp_docid = getting_terms.getInt("docid");
               temp_stem = getting_terms.getString("stem");
               
               temp_stmt = connection.createStatement();
               temp = temp_stmt.executeQuery("SELECT * FROM features WHERE docid=" + temp_docid + " AND stem='" + temp_stem + "'");
               if(temp.next()) {
                   already_seen = true;
               } else {
                   already_seen = false;
               }
               temp.close();
               temp_stmt.close();
               
               if(!already_seen) {
                   //getting tf
                   temp_stmt = connection.createStatement();
                   temp = temp_stmt.executeQuery("SELECT COUNT(*) FROM terms WHERE docid=" + temp_docid + " AND stem='" + temp_stem + "'");
                   temp.next();
                   tf = temp.getInt("COUNT(*)");
                   m.addInformation("Calculating tf for term " + temp_stem + ": " + tf);
                   System.out.println("Calculating tf for term " + temp_stem + ": " + tf);
                   temp.close();
                   temp_stmt.close();
               
                   //getting df
                   temp_stmt = connection.createStatement();
                   temp = temp_stmt.executeQuery("SELECT COUNT(*) FROM (SELECT DISTINCT docid FROM terms WHERE stem='" + temp_stem + "')");
                   temp.next();
                   df = temp.getInt("COUNT(*)");
                   m.addInformation("Calculating df for term " + temp_stem + ": " + df);
                   System.out.println("Calculating df for term " + temp_stem + ": " + df);
                   temp.close();
                   temp_stmt.close();
               
                   //getting now (number of words)
                   temp_stmt = connection.createStatement();
                   temp = temp_stmt.executeQuery("SELECT COUNT(*) FROM terms WHERE docid=" + temp_docid);
                   temp.next();
                   now = temp.getInt(1);
                   m.addInformation("Calculating number of words in document: " + now);
                   System.out.println("Calculating number of words in document: " + now);
                   temp.close();
                   temp_stmt.close();
               
                   rtf = tf / now;
               
                   m.addInformation("CREATING FEATURES...");
                   System.out.println("CREATING FEATURES...");
                   m.addInformation("DBINFO: INSERT INTO features VALUES(" + temp_docid + ", '" + temp_stem + "', " + rtf + ", " + tf + ", log(2," + N + "/" + df + "), " + tf + "*log(2," + N + "/" + df + "))");
                   System.out.println("DBINFO: INSERT INTO features VALUES(" + temp_docid + ", '" + temp_stem + "', " + rtf + ", " + tf + ", log(2," + N + "/" + df + "), " + tf + "*log(2," + N + "/" + df + "))");
                   temp_stmt = connection.createStatement();
                   temp_stmt.executeUpdate("INSERT INTO features VALUES(" + temp_docid + ", '" + temp_stem + "', " + rtf + ", " + tf + ", log(2," + N + "/" + df + "), " + tf + "*log(2," + N + "/" + df + "))");
                   connection.commit();
                   temp_stmt.close();
               }               
           }
           getting_terms.close();
           temp_stmt.close();

       } catch (SQLException e) {
           while (e != null) {
               System.err.println(e.toString());
               m.addInformation(e.toString());
               System.err.println("SQL-State: " + e.getSQLState());
               m.addInformation("SQL-State: " + e.getSQLState());
               System.err.println("ErrorCode: " + e.getErrorCode());
               m.addInformation("ErrorCode: " + e.getErrorCode());
               e = e.getNextException();
           }
           return false;
       }
       return true;
   }
}