/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.PlsqlTTCColumn;
import oracle.jdbc.ttc7.TTCDataSet;

public class PlsqlTTCDataSet
extends TTCDataSet {
    private PlsqlTTCColumn[] columns;
    private byte[] userIOVector;
    private byte[] realIOVector;

    protected PlsqlTTCDataSet(PlsqlTTCColumn[] plsqlTTCColumnArray, byte[] byArray) {
        super(plsqlTTCColumnArray, plsqlTTCColumnArray.length == 0 ? 0 : 1);
        this.columns = plsqlTTCColumnArray != null ? plsqlTTCColumnArray : new PlsqlTTCColumn[]{};
        this.userIOVector = byArray;
    }

    protected void marshalRow() throws SQLException, IOException {
        if (this.realIOVector == null) {
            DBError.check_error(423);
        }
        int n = 0;
        while (n < this.realIOVector.length) {
            if ((this.realIOVector[n] & 0x20) != 0) {
                this.columns[n].marshal();
            }
            ++n;
        }
        this.marshaledRows = 1;
    }

    protected boolean next() {
        return this.realIOVector != null;
    }

    protected void print(int n, int n2, int n3) {
        int n4;
        OracleLog.print(this, n, n2, n3, " \n   ---- Enter: PlsqlTTCDataSet.print --- ");
        super.print(n, n2, n3);
        OracleLog.print(this, n, n2, n3, "\n      +++ userIOVector info +++++++ ");
        if (this.userIOVector == null) {
            OracleLog.print(this, n, n2, n3, " User IOVector is NULL ");
        } else {
            OracleLog.print(this, n, n2, n3, "      userIOVector.length = " + this.userIOVector.length);
            n4 = 0;
            while (n4 < this.userIOVector.length) {
                OracleLog.print(this, n, n2, n3, "      userIOVector[" + n4 + "] = " + this.userIOVector[n4]);
                ++n4;
            }
        }
        OracleLog.print(this, n, n2, n3, "      +++ End of userIOVector Info +++++++");
        OracleLog.print(this, n, n2, n3, "\n      +++ realIOVector info +++++++");
        if (this.realIOVector == null) {
            OracleLog.print(this, n, n2, n3, " Real IOVector is NULL ");
        } else {
            OracleLog.print(this, n, n2, n3, "      realIOVector.length = " + this.realIOVector.length);
            n4 = 0;
            while (n4 < this.realIOVector.length) {
                OracleLog.print(this, n, n2, n3, "       realIOVector[" + n4 + "] = " + this.realIOVector[n4]);
                ++n4;
            }
        }
        OracleLog.print(this, n, n2, n3, "      +++ End of realIOVector Info +++++++ ");
        OracleLog.print(this, n, n2, n3, "    ---- Exit: PlsqlTTCDataSet.print --- \n");
    }

    protected void setIOVector(byte[] byArray) {
        this.realIOVector = byArray;
    }

    protected boolean unmarshalRow() throws SQLException, IOException {
        if (this.realIOVector == null) {
            DBError.check_error(423);
        }
        int n = 0;
        while (n < this.realIOVector.length) {
            if ((this.realIOVector[n] & 0x10) != 0) {
                this.columns[n].unmarshal();
            }
            ++n;
        }
        this.unmarshaledRows = 1;
        return false;
    }
}

