/*
 * Decompiled with CFR 0.152.
 */
package ISSearch;

import ISSearch.ISDocument;
import ISSearch.ISDocumentInterface;
import ISSearch.ISParserInterface;
import ISSearch.ISTerm;
import ISSearch.ISTermInterface;
import ISSearch.MainGUI;
import ISSearch.Stemmer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class ISParser
implements ISParserInterface {
    static MainGUI m = new MainGUI();

    public boolean isStopword(String who) {
        Vector<String> v = new Vector<String>();
        try {
            String s;
            BufferedReader f = new BufferedReader(new FileReader("STOPWORDS"));
            while ((s = f.readLine()) != null) {
                v.addElement(s.toLowerCase());
            }
            f.close();
        }
        catch (IOException e) {
            System.out.println("Fehler beim \u00d6ffnen der Datei!");
            System.err.println(e.toString());
            return false;
        }
        for (int i = 0; i < v.size(); ++i) {
            if (!who.equals(v.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public ISDocumentInterface parse(Reader input) {
        final Vector v = new Vector();
        final Vector wordlist = new Vector();
        final ISParser checkword = new ISParser();
        try {
            HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){

                public void handleText(char[] data, int pos) {
                    String w = new String(data);
                    StringTokenizer token = new StringTokenizer(w.toString(), " \t\n\r\f,.;:?!=-_&'<>@()|[]\"/\\", false);
                    while (token.hasMoreTokens()) {
                        String temp = token.nextElement().toString();
                        if (checkword.isStopword(temp)) continue;
                        ISTerm word = new ISTerm();
                        word.setWord(temp);
                        word.setPos(wordlist.size() + 1);
                        wordlist.addElement(word);
                    }
                }

                public void handleStartTag(HTML.Tag tag, MutableAttributeSet attrSet, int pos) {
                    if (tag == HTML.Tag.A) {
                        try {
                            URL url_temp = new URL((String)attrSet.getAttribute(HTML.Attribute.HREF));
                            System.out.println("NEW LINK FOUND: " + url_temp.toString());
                            MainGUI.addInformation("NEW LINK FOUND: " + url_temp.toString());
                            v.addElement(url_temp);
                        }
                        catch (MalformedURLException murle) {
                            return;
                        }
                    }
                }
            };
            new ParserDelegator().parse(input, callback, false);
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return null;
        }
        URL[] url = new URL[v.size()];
        v.toArray(url);
        ISTermInterface[] words = new ISTermInterface[wordlist.size()];
        wordlist.toArray(words);
        ISDocument d = new ISDocument();
        d.setUrls(url);
        d.setTerms(words);
        d.setLink("");
        return d;
    }

    public String stem(String who) {
        try {
            Stemmer s = new Stemmer();
            char[] temp_char = new char[who.length()];
            for (int i = 0; i < who.length(); ++i) {
                temp_char[i] = who.charAt(i);
            }
            s.add(temp_char, who.length());
            s.stem();
            String temp = s.toString();
            temp = temp.toLowerCase();
            temp = temp.trim();
            return temp;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return null;
        }
    }

    public static void main(String[] args) {
    }
}

