package ISSearch;

import java.io.*;
import java.net.*;

/**
 * This <B>mandatory</B> class must implement all functions prescribed by <code>ISDocumentInterface</code>
 * 
 */
public class ISDocument implements ISDocumentInterface
{ 
    private String url;
    private ISTermInterface[] terms;
    private URL[] urls;
    
   /** Creates a new instance of ISDocument */
    public ISDocument()
    {
    }
       
  /**
  * Returns the set of absolute Url's extracted from the current document.
  * @return URLs extracted from the document (as <code>Array</code> of <code>URL</code>), or <I>null</I> when no links were found
  */
    public URL[] getUrls()
    {
        return urls;
    }
    
  /**
  * Sets the set of absolute Url's extracted from the current document.
  * @param u is the URL[] which contains the absolute URLs extracted from the current document.
  */
    public void setUrls(URL[] u)
    {
        urls = u;
    }
    
  /**
  * Returns the bag of words extracted from the document. The result should contain no stopwords.
  * @return The <code>Array</code> of words extracted from the document (as <code>Array</code> of Objects that must implement <code>ISTermInterface</code>),  or <I>null</I> when no terms were found
  */
    public ISTermInterface[] getTerms()
    {
        return terms;
    }
    
  /**
  * Sets the bag of words extracted from the document (without stopwords).
  * @param t is the ISTermInterface[] which contains extracted words.
  */
    public void setTerms(ISTermInterface[] t)
    {
        terms = t;
    }
    
  /**
  * Returns the absolute URL of the current document 
  * @return The absolute URL of the current document as <code>String</code>
  */
    public String getLink()
    {
        return url;
    }
    
  /**
  * Sets the absolute URL of the current document
  * @param u is the String which contains the URL of the current document
  */
    public void setLink(String u)
    {
        url = u;
    }
}