package ISSearch;

import java.net.*;
import java.net.URL;
import java.lang.String;
import java.util.*;
import java.sql.*;

/**
 * Interface des Query-Prozessors. Der Query Processor soll einfache Suchanfragen bearbeiten und die 
 * Rangliste der besten Treffer - sortiert nach Relevanz - zurckgeben. 
 */
public class ISQueryProcessor implements ISQueryProcessorInterface
{
    static MainGUI m = new MainGUI();
       
   /**
    * Diese Methode soll die Anfrage analysieren und die Top-10 der Trefferliste - sortiert nach Relevanz - zurckgeben. 
    * Einzelne Schritte bei der Verarbeitung der Anfrage sind:
    * <UL>
    * <LI> die Anfrage analysieren (z.B. Sonderzeichen entfernen, String.toLowerCase() anwenden, etc.) und einzelne Suchbegriffe extrahieren; 
    * <LI> Stoppwrter aus der Query entfernen; 
    * <LI> die restlichen Keywords in Wortstmme mit Hilfe des Stemmers umwandeln; 
    * <LI> Datenbankverbindung herstellen
    * <LI> Die Anfrage auf eine SQL-Query abbilden und diese auf der Datenbank ausfhren; 
    * <LI> Datenbankverbindung schliessen
    * <LI> Top-10 URLs der Trefferliste (ggf. weniger) als Ergebnis zurueckgeben.
    * </UL>
    * @param anfrage Die Query, die der Prozessor verarbeiten soll. Sie besteht aus positiven und auszuschliessenden Suchbegriffen, getrennt 
    * durch Leerzeichen (d.h ein Treffer soll passende Features zu 
    * <B>allen</B> positiven Wrtern enthalten und darf <B>keine</B> Negativ-Features enthalten). Man kann davon ausgehen, 
    * dass jede Query mindestens einen 'positiven' Suchbegriff enthalten soll.
    * <P>
    * Format der Suchanfrage:
    * <PRE>        
    * [-]key_1 [-]key_2 ... [-]key_n
    * </PRE>  
    * mit:
    * <PRE>       
    *   key   - Treffer soll den Wortstamm des Suchbegriffs enthalten.
    *  -key   - Treffer darf den Wortstamm des Suchbegriffs nicht enthalten.
    * </PRE>
    * @return Die Top-10 der Trefferliste (URLs der gefundenen Dokumente), sortiert absteigend nach Relevanz (d.h. result[0] 
    * hat den besten Score, result[1] den zweitbesten, usw.).
    * Als Relevanzma verwenden wir den 
    * Skalarprodukt zwischen dem Query-Vektor und dem Featurevektor des Dokuments. Die Query wird in unserem 
    * Modell durch den Vektor ihrer Positivterme (jeweils mit Gewicht 1.0) dargestellt, fr die Gewichtung der 
    * Features in den Dokumenten soll <code>tf*idf</code> Ma benutzt werden. Die Negativterme der Query werden bei der 
    * Berechnung der Relevanz nicht bercksichtigt. Wurden keine Treffer gefunden, gibt die Funktion <code>null</code> zurueck.
    * Sind bei der Verarbeitung der Anfrage Fehler aufgetreten, soll ebenfalls <code>null</code> zurueckgegeben werden.
    */
   public URL[] executeQuery(String anfrage)
   {
       ISParser p = new ISParser();
       ISDBCrawler dbcrawler = new ISDBCrawler();
       ISDB isdb = new ISDB();
       Vector stemmed_positive_keywords = new Vector();
       Vector stemmed_negative_keywords = new Vector();

       try {
            if(anfrage.equals("")) return null;
       } catch (NullPointerException e) {
           return null;
       }
       
       anfrage = anfrage.toLowerCase();
              
       StringTokenizer s = new StringTokenizer(anfrage);
       
       //analyzing the query
       while(s.hasMoreElements()) {
           String temp = (String)s.nextElement();
           if (!(temp.substring(0,1).equals("-")) && !(p.isStopword(temp))) {
               //pushing all positive keywords in a vector
               stemmed_positive_keywords.addElement(p.stem(temp));
           }        
           if ((temp.substring(0,1).equals("-")) && !(p.isStopword(temp))) {
               temp = temp.substring(1, temp.length());
               //pushing all negative keywords in a vector
               stemmed_negative_keywords.addElement(p.stem(temp));
           }
       }
       
       System.out.println("stemmed_positive_keywords:");
       for(int a=0; a<stemmed_positive_keywords.size(); a++) {
          System.out.println(stemmed_positive_keywords.elementAt(a)) ;
       }
       
       System.out.println("stemmed_negative_keywords:");
       for(int a=0; a<stemmed_negative_keywords.size(); a++) {
           System.out.println(stemmed_negative_keywords.elementAt(a));
       }
       
       //creating the SQL query
       String sql = "";
       
       //adding the positive keywords to the query
       for(int i=0; i<stemmed_positive_keywords.size(); i++) {
           sql = sql + "(SELECT docid FROM features WHERE stem = '" + p.stem(stemmed_positive_keywords.elementAt(i).toString()) + "')";
           if (i+1 < stemmed_positive_keywords.size()) sql = sql + " INTERSECT ";
       }
       
       //adding the negative keywords to the query
       if(stemmed_negative_keywords.size() > 0) sql = sql + " INTERSECT ";
       
       for(int i=0; i<stemmed_negative_keywords.size(); i++) {
           sql = sql + "(SELECT docid FROM features WHERE stem != '" + p.stem(stemmed_negative_keywords.elementAt(i).toString()) + "')";
           if (i+1 < stemmed_negative_keywords.size()) sql = sql + " INTERSECT ";
       }
       
       System.out.println(sql);
       
       
       dbcrawler.openDB();
       isdb = dbcrawler.isdb;
       Connection c = isdb.connection;
       
       try {
           Statement temp_stmt = c.createStatement();
           
           //getting all URLs that satisfy the query
           ResultSet temp = temp_stmt.executeQuery(sql);
           
           //saving the docid's of all URLs that satisfy the query
           Vector doc_ids = new Vector();
           while(temp.next()) {
               doc_ids.addElement(temp.getInt(1));
           }
           
           temp.close();
           temp_stmt.close();
           
           Vector tempurlarray = new Vector();
           //array of top10-URLs
           URL[] urlarray = new URL[10];

           for(int i=0; i<doc_ids.size(); i++) {
               //creating the SQL query to get the ranking
               sql = "SELECT docid, SUM(tfidf) FROM features WHERE docid=" + doc_ids.elementAt(i) + " AND ";
               for(int j=0; j<stemmed_positive_keywords.size(); j++) {
                   sql = sql + "stem = '" + stemmed_positive_keywords.elementAt(j).toString() + "'";
                   if(j+1 < stemmed_positive_keywords.size()) sql = sql + " OR ";
               }
               sql = sql + " GROUP BY docid ORDER BY SUM(tfidf) DESC";
               System.out.println(sql);
               temp_stmt = c.createStatement();
               //executing the SQL query to get the ranking
               temp = temp_stmt.executeQuery(sql);
               
               //saving all URLs in a temporary Vector
               while(temp.next()) {
                   tempurlarray.addElement(temp.getInt(1));
               }
               
               temp.close();
               temp_stmt.close();  
           }
           
           //adding the top10 URLs to the array which should be returned
           try {
               for(int i=0; i<10 && i<tempurlarray.size(); i++) {
                   temp_stmt = c.createStatement();
                   temp = temp_stmt.executeQuery("SELECT url FROM documents WHERE docid=" + tempurlarray.elementAt(i).toString());
                   if(temp.next()) urlarray[i] = new URL(temp.getString(1));
                   temp.close();
                   temp_stmt.close();
               }
           } catch (MalformedURLException e) {
               System.err.println(e.toString());
               return null;
           }
           
           dbcrawler.closeDB();
           
           return urlarray;
           
       } catch (SQLException e) {
           while (e != null) {
               System.err.println(e.toString());
               m.addInformation(e.toString());
               System.err.println("SQL-State: " + e.getSQLState());
               m.addInformation("SQL-State: " + e.getSQLState());
               System.err.println("ErrorCode: " + e.getErrorCode());
               m.addInformation("ErrorCode: " + e.getErrorCode());
               e = e.getNextException();
           }
           return null;
       }
   }
}