package ISSearch;

import java.util.*;
import java.io.*;
import java.net.*;

/**
 * This interface is used to represent the parsed document. 
 * The objects that implement this interface are used 
 * to store extracted words and links. 
 * The solution <B>must</B> contain the class 
 * that implements all functions prescribed by this interface.
 * @see URL
*/
public interface ISDocumentInterface
{

  /**
  * Returns the set of absolute Url's extracted from the current document.
  * @return URLs extracted from the document (as <code>Array</code> of <code>URL</code>), or <I>null</I> when no links were found
  */
  public URL[] getUrls();
  
  /**
  * Sets the set of absolute Url's extracted from the current document.
  * @param u is the URL[] which contains the absolute URLs extracted from the current document.
  */
  public void setUrls(URL[] u);

  /**
  * Returns the bag of words extracted from the document. The result should contain no stopwords.
  * @return The <code>Array</code> of words extracted from the document (as <code>Array</code> of Objects that must implement <code>ISTermInterface</code>),  or <I>null</I> when no terms were found
  */
  public ISTermInterface[] getTerms();
  
  /**
  * Sets the bag of words extracted from the document (without stopwords).
  * @param t is the ISTermInterface[] which contains extracted words.
  */
  public void setTerms(ISTermInterface[] t);

  /**
  * Returns the absolute URL of the current document 
  * @return The absolute URL of the current document as <code>String</code>
  */
  public String getLink(); 
  
  /**
  * Sets the absolute URL of the current document
  * @param u is the String which contains the URL of the current document
  */
  public void setLink(String u);
}
