package ISSearch;

import java.io.*;
import java.net.*;
import java.util.*;
import java.lang.*;

/**
 * Interface of the main Crawler class of the Web search engine.
 * This class is used to start and stop the Crawler,
 * to reset the engine and to control crawling parameters. Additionally,
 * it provides the functionality to store crawled documents into the database
 * using the built-in database interface block.
 */
public interface ISDBCrawlerInterface extends ISCrawlerInterface
{
   /**
    * Stores the crawled document and its URL into the database
    * @param link the URL of the crawled document
    * @param doc extracted terms and links from the document
    * @return true, if the storage was successful; false otherwise.
    */   
   public boolean store(URL link, ISDocumentInterface doc);
    
   /** Initializes the internal database interface and opens its database connection
    * @return true, if the connection to the database was successful, false otherwise.
    */
    public boolean openDB();
    
   /** Closes the database connection of the built-in database interface.
    */
    public void closeDB();
    
   /** Returns the built-in database interface of the crawler
    * @return the database interface of the crawler
    */
    public ISDBinterface getDBInterface();
}