/*
 * Decompiled with CFR 0.152.
 */
package ISSearch;

import ISSearch.ISDBinterface;
import ISSearch.ISDocumentInterface;
import ISSearch.ISParser;
import ISSearch.MainGUI;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JOptionPane;

public class ISDB
implements ISDBinterface {
    Connection connection = null;
    boolean openDatabase = false;
    MainGUI m = new MainGUI();

    public boolean openConnection(String user, String password, String hostname, int port, String service_name) {
        Connection con = null;
        Statement stmt = null;
        String driver = "oracle.jdbc.driver.OracleDriver";
        try {
            Class.forName(driver);
        }
        catch (Exception e) {
            System.err.println("error while loading jdbc driver");
            this.connection = con;
            return false;
        }
        try {
            String jdbcURL = "jdbc:oracle:thin:";
            String db = "(DESCRIPTION = (ADDRESS_LIST = (ADDRESS = (PROTOCOL = TCP)(HOST = " + hostname + ")(PORT = " + port + ")))" + "(CONNECT_DATA = (SERVICE_NAME = " + service_name + ")))";
            con = DriverManager.getConnection(jdbcURL + "@" + db, user, password);
            con.setAutoCommit(false);
            this.connection = con;
            stmt = con.createStatement();
        }
        catch (Exception e) {
            System.err.println("error with jdbc connection");
            this.connection = con;
            this.openDatabase = false;
            return false;
        }
        this.openDatabase = true;
        return true;
    }

    public void closeConnection() {
        try {
            this.connection.close();
            this.openDatabase = false;
        }
        catch (SQLException e) {
            while (e != null) {
                System.err.println(e.toString());
                MainGUI.addInformation(e.toString());
                System.err.println("SQL-State: " + e.getSQLState());
                MainGUI.addInformation("SQL-State: " + e.getSQLState());
                System.err.println("ErrorCode: " + e.getErrorCode());
                MainGUI.addInformation("ErrorCode: " + e.getErrorCode());
                e = e.getNextException();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean isOpen() {
        return this.openDatabase;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection con) {
        this.connection = con;
    }

    public boolean store(URL url, ISDocumentInterface doc) {
        try {
            Statement temp_stmt2;
            int docid = 0;
            Statement temp_stmt = this.connection.createStatement();
            ResultSet results_docid = temp_stmt.executeQuery("SELECT * FROM documents");
            while (results_docid.next()) {
                ++docid;
            }
            System.out.println("docid: " + docid);
            results_docid.close();
            temp_stmt.close();
            temp_stmt = this.connection.createStatement();
            ResultSet isThere_docid = temp_stmt.executeQuery("SELECT * FROM documents WHERE url='" + url.toString() + "'");
            if (isThere_docid.next()) {
                System.out.println("URL already in database documents...");
                temp_stmt2 = this.connection.createStatement();
                temp_stmt2.executeUpdate("DELETE FROM terms WHERE docid=(SELECT docid FROM documents WHERE url='" + url.toString() + "')");
                temp_stmt2.close();
                this.connection.commit();
            } else {
                MainGUI.addInformation("DBINFO: ADDING URL " + url.toString() + " TO TABLE documents...");
                temp_stmt2 = this.connection.createStatement();
                temp_stmt2.executeUpdate("INSERT INTO documents VALUES('" + docid + "','" + url.toString() + "')");
                temp_stmt2.close();
                this.connection.commit();
            }
            isThere_docid.close();
            temp_stmt.close();
            String stem = null;
            String term = null;
            String doc_url = null;
            int pos = 0;
            ISParser p = new ISParser();
            for (int i = 0; i < doc.getTerms().length; ++i) {
                stem = doc.getTerms()[i].getStem();
                term = doc.getTerms()[i].getWord();
                doc_url = doc.getLink();
                pos = doc.getTerms()[i].getPos();
                ResultSet temp_rs_for_terms = null;
                temp_stmt = this.connection.createStatement();
                temp_rs_for_terms = temp_stmt.executeQuery("SELECT docid FROM documents WHERE url='" + doc_url + "'");
                if (temp_rs_for_terms.next()) {
                    docid = temp_rs_for_terms.getInt(1);
                }
                temp_rs_for_terms.close();
                temp_stmt.close();
                if (stem == null || p.isStopword(stem) || stem.length() <= 2) continue;
                MainGUI.addInformation("DBINFO: ADDING TERM " + stem + " TO TABLE terms...");
                temp_stmt = this.connection.createStatement();
                temp_stmt.executeUpdate("INSERT INTO terms VALUES('" + docid + "','" + stem + "','" + term + "','" + pos + "')");
                temp_stmt.close();
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            while (e != null) {
                System.err.println(e.toString());
                MainGUI.addInformation(e.toString());
                System.err.println("SQL-State: " + e.getSQLState());
                MainGUI.addInformation("SQL-State: " + e.getSQLState());
                System.err.println("ErrorCode: " + e.getErrorCode());
                MainGUI.addInformation("ErrorCode: " + e.getErrorCode());
                e = e.getNextException();
            }
            return false;
        }
        return true;
    }

    public boolean createSchema() {
        try {
            Statement temp_stmt = this.connection.createStatement();
            temp_stmt.executeUpdate("CREATE TABLE documents(docid INT NOT NULL PRIMARY KEY, url VARCHAR(255) NOT NULL)");
            temp_stmt.close();
            temp_stmt = this.connection.createStatement();
            temp_stmt.executeUpdate("CREATE TABLE terms(docid INT NOT NULL, stem VARCHAR(255) NOT NULL, word VARCHAR(255) NOT NULL, position INT NOT NULL)");
            temp_stmt.close();
            temp_stmt = this.connection.createStatement();
            temp_stmt.executeUpdate("CREATE TABLE features(docid INT NOT NULL, stem VARCHAR(255) NOT NULL, rtf FLOAT NOT NULL, tf FLOAT NOT NULL, idf FLOAT NOT NULL, tfidf FLOAT NOT NULL, PRIMARY KEY (docid, stem))");
            temp_stmt.close();
            this.connection.commit();
            MainGUI.addInformation("Scheme successfully created.");
            JOptionPane.showMessageDialog(this.m, "Scheme successfully created.", "Create Scheme", 1);
            return true;
        }
        catch (SQLException e) {
            while (e != null) {
                System.err.println(e.toString());
                MainGUI.addInformation(e.toString());
                System.err.println("SQL-State: " + e.getSQLState());
                MainGUI.addInformation("SQL-State: " + e.getSQLState());
                System.err.println("ErrorCode: " + e.getErrorCode());
                MainGUI.addInformation("ErrorCode: " + e.getErrorCode());
                e = e.getNextException();
            }
            JOptionPane.showMessageDialog(this.m, "Error occured while creating scheme.", "Create Scheme", 0);
            return false;
        }
    }

    public void dropSchema() {
        try {
            Statement temp_stmt = this.connection.createStatement();
            temp_stmt.executeUpdate("DROP TABLE documents");
            temp_stmt.close();
            temp_stmt = this.connection.createStatement();
            temp_stmt.executeUpdate("DROP TABLE terms");
            temp_stmt.close();
            temp_stmt = this.connection.createStatement();
            temp_stmt.executeUpdate("DROP TABLE features");
            temp_stmt.close();
            this.connection.commit();
            MainGUI.addInformation("Scheme dropped.");
            JOptionPane.showMessageDialog(this.m, "Scheme dropped.", "Drop Scheme", 1);
        }
        catch (SQLException e) {
            while (e != null) {
                System.err.println(e.toString());
                MainGUI.addInformation(e.toString());
                System.err.println("SQL-State: " + e.getSQLState());
                MainGUI.addInformation("SQL-State: " + e.getSQLState());
                System.err.println("ErrorCode: " + e.getErrorCode());
                MainGUI.addInformation("ErrorCode: " + e.getErrorCode());
                e = e.getNextException();
            }
            JOptionPane.showMessageDialog(this.m, "Error occured while dropping scheme.", "Drop Scheme", 0);
        }
    }

    public boolean createFeatures() {
        try {
            int N = 0;
            float rtf = 0.0f;
            float tf = 0.0f;
            float df = 0.0f;
            int now = 0;
            ResultSet getting_terms = null;
            ResultSet temp = null;
            int temp_docid = 0;
            String temp_stem = null;
            boolean already_seen = false;
            Statement temp_stmt = this.connection.createStatement();
            temp_stmt.executeUpdate("DELETE FROM features");
            temp_stmt.close();
            temp_stmt = this.connection.createStatement();
            temp = temp_stmt.executeQuery("SELECT COUNT(*) FROM documents");
            temp.next();
            N = temp.getInt(1);
            System.out.println("Calculating N: " + N);
            temp.close();
            temp_stmt.close();
            temp_stmt = this.connection.createStatement();
            getting_terms = temp_stmt.executeQuery("SELECT * FROM terms ORDER BY docid");
            while (getting_terms.next()) {
                temp_docid = getting_terms.getInt("docid");
                temp_stem = getting_terms.getString("stem");
                temp_stmt = this.connection.createStatement();
                temp = temp_stmt.executeQuery("SELECT * FROM features WHERE docid=" + temp_docid + " AND stem='" + temp_stem + "'");
                already_seen = temp.next();
                temp.close();
                temp_stmt.close();
                if (already_seen) continue;
                temp_stmt = this.connection.createStatement();
                temp = temp_stmt.executeQuery("SELECT COUNT(*) FROM terms WHERE docid=" + temp_docid + " AND stem='" + temp_stem + "'");
                temp.next();
                tf = temp.getInt("COUNT(*)");
                MainGUI.addInformation("Calculating tf for term " + temp_stem + ": " + tf);
                System.out.println("Calculating tf for term " + temp_stem + ": " + tf);
                temp.close();
                temp_stmt.close();
                temp_stmt = this.connection.createStatement();
                temp = temp_stmt.executeQuery("SELECT COUNT(*) FROM (SELECT DISTINCT docid FROM terms WHERE stem='" + temp_stem + "')");
                temp.next();
                df = temp.getInt("COUNT(*)");
                MainGUI.addInformation("Calculating df for term " + temp_stem + ": " + df);
                System.out.println("Calculating df for term " + temp_stem + ": " + df);
                temp.close();
                temp_stmt.close();
                temp_stmt = this.connection.createStatement();
                temp = temp_stmt.executeQuery("SELECT COUNT(*) FROM terms WHERE docid=" + temp_docid);
                temp.next();
                now = temp.getInt(1);
                MainGUI.addInformation("Calculating number of words in document: " + now);
                System.out.println("Calculating number of words in document: " + now);
                temp.close();
                temp_stmt.close();
                rtf = tf / (float)now;
                MainGUI.addInformation("CREATING FEATURES...");
                System.out.println("CREATING FEATURES...");
                MainGUI.addInformation("DBINFO: INSERT INTO features VALUES(" + temp_docid + ", '" + temp_stem + "', " + rtf + ", " + tf + ", log(2," + N + "/" + df + "), " + tf + "*log(2," + N + "/" + df + "))");
                System.out.println("DBINFO: INSERT INTO features VALUES(" + temp_docid + ", '" + temp_stem + "', " + rtf + ", " + tf + ", log(2," + N + "/" + df + "), " + tf + "*log(2," + N + "/" + df + "))");
                temp_stmt = this.connection.createStatement();
                temp_stmt.executeUpdate("INSERT INTO features VALUES(" + temp_docid + ", '" + temp_stem + "', " + rtf + ", " + tf + ", log(2," + N + "/" + df + "), " + tf + "*log(2," + N + "/" + df + "))");
                this.connection.commit();
                temp_stmt.close();
            }
            getting_terms.close();
            temp_stmt.close();
        }
        catch (SQLException e) {
            while (e != null) {
                System.err.println(e.toString());
                MainGUI.addInformation(e.toString());
                System.err.println("SQL-State: " + e.getSQLState());
                MainGUI.addInformation("SQL-State: " + e.getSQLState());
                System.err.println("ErrorCode: " + e.getErrorCode());
                MainGUI.addInformation("ErrorCode: " + e.getErrorCode());
                e = e.getNextException();
            }
            return false;
        }
        return true;
    }
}

