/*
 * Decompiled with CFR 0.152.
 */
package ISSearch;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BrowserLauncher {
    public static int jvm;
    public static Object browser;
    public static boolean loadedWithoutErrors;
    public static Class mrjFileUtilsClass;
    public static Class mrjOSTypeClass;
    public static Class aeDescClass;
    public static Constructor aeTargetConstructor;
    public static Constructor appleEventConstructor;
    public static Constructor aeDescConstructor;
    public static Method findFolder;
    public static Method getFileCreator;
    public static Method getFileType;
    public static Method openURL;
    public static Method makeOSType;
    public static Method putParameter;
    public static Method sendNoReply;
    public static Object kSystemFolderType;
    public static Integer keyDirectObject;
    public static Integer kAutoGenerateReturnID;
    public static Integer kAnyTransactionID;
    public static Object linkage;
    public static final String JDirect_MacOSX = "/System/Library/Frameworks/Carbon.framework/Frameworks/HIToolbox.framework/HIToolbox";
    public static final int MRJ_2_0 = 0;
    public static final int MRJ_2_1 = 1;
    public static final int MRJ_3_0 = 3;
    public static final int MRJ_3_1 = 4;
    public static final int WINDOWS_NT = 5;
    public static final int WINDOWS_9x = 6;
    public static final int OTHER = -1;
    public static final String FINDER_TYPE = "FNDR";
    public static final String FINDER_CREATOR = "MACS";
    public static final String GURL_EVENT = "GURL";
    public static final String FIRST_WINDOWS_PARAMETER = "/c";
    public static final String SECOND_WINDOWS_PARAMETER = "start";
    public static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    public static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    public static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    public static final String NETSCAPE_OPEN_PARAMETER_END = ")'";
    public static String errorMessage;

    public static boolean loadClasses() {
        switch (jvm) {
            case 0: {
                try {
                    Class<?> aeTargetClass = Class.forName("com.apple.MacOS.AETarget");
                    Class<?> osUtilsClass = Class.forName("com.apple.MacOS.OSUtils");
                    Class<?> appleEventClass = Class.forName("com.apple.MacOS.AppleEvent");
                    Class<?> aeClass = Class.forName("com.apple.MacOS.ae");
                    aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
                    aeTargetConstructor = aeTargetClass.getDeclaredConstructor(Integer.TYPE);
                    appleEventConstructor = appleEventClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, aeTargetClass, Integer.TYPE, Integer.TYPE);
                    aeDescConstructor = aeDescClass.getDeclaredConstructor(String.class);
                    makeOSType = osUtilsClass.getDeclaredMethod("makeOSType", String.class);
                    putParameter = appleEventClass.getDeclaredMethod("putParameter", Integer.TYPE, aeDescClass);
                    sendNoReply = appleEventClass.getDeclaredMethod("sendNoReply", new Class[0]);
                    Field keyDirectObjectField = aeClass.getDeclaredField("keyDirectObject");
                    keyDirectObject = (Integer)keyDirectObjectField.get(null);
                    Field autoGenerateReturnIDField = appleEventClass.getDeclaredField("kAutoGenerateReturnID");
                    kAutoGenerateReturnID = (Integer)autoGenerateReturnIDField.get(null);
                    Field anyTransactionIDField = appleEventClass.getDeclaredField("kAnyTransactionID");
                    kAnyTransactionID = (Integer)anyTransactionIDField.get(null);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 1: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
                    Field systemFolderField = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
                    kSystemFolderType = systemFolderField.get(null);
                    findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
                    getFileCreator = mrjFileUtilsClass.getDeclaredMethod("getFileCreator", File.class);
                    getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", File.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nsfe) {
                    errorMessage = nsfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (SecurityException se) {
                    errorMessage = se.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 3: {
                try {
                    Class<?> linker = Class.forName("com.apple.mrj.jdirect.Linker");
                    Constructor<?> constructor = linker.getConstructor(Class.class);
                    linkage = constructor.newInstance(BrowserLauncher.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
                catch (InvocationTargetException ite) {
                    errorMessage = ite.getMessage();
                    return false;
                }
                catch (InstantiationException ie) {
                    errorMessage = ie.getMessage();
                    return false;
                }
                catch (IllegalAccessException iae) {
                    errorMessage = iae.getMessage();
                    return false;
                }
            }
            case 4: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", String.class);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    public static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 0: {
                try {
                    Integer finderCreatorCode = (Integer)makeOSType.invoke(null, FINDER_CREATOR);
                    Object aeTarget = aeTargetConstructor.newInstance(finderCreatorCode);
                    Integer gurlType = (Integer)makeOSType.invoke(null, GURL_EVENT);
                    Object appleEvent = appleEventConstructor.newInstance(gurlType, gurlType, aeTarget, kAutoGenerateReturnID, kAnyTransactionID);
                    return appleEvent;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InstantiationException ie) {
                    browser = null;
                    errorMessage = ie.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getMessage();
                    return browser;
                }
            }
            case 1: {
                File systemFolder;
                try {
                    systemFolder = (File)findFolder.invoke(null, kSystemFolderType);
                }
                catch (IllegalArgumentException iare) {
                    browser = null;
                    errorMessage = iare.getMessage();
                    return browser;
                }
                catch (IllegalAccessException iae) {
                    browser = null;
                    errorMessage = iae.getMessage();
                    return browser;
                }
                catch (InvocationTargetException ite) {
                    browser = null;
                    errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                    return browser;
                }
                String[] systemFolderFiles = systemFolder.list();
                for (int i = 0; i < systemFolderFiles.length; ++i) {
                    try {
                        Object fileCreator;
                        Object fileType;
                        File file = new File(systemFolder, systemFolderFiles[i]);
                        if (!file.isFile() || !FINDER_TYPE.equals((fileType = getFileType.invoke(null, file)).toString()) || !FINDER_CREATOR.equals((fileCreator = getFileCreator.invoke(null, file)).toString())) continue;
                        browser = file.toString();
                        return browser;
                    }
                    catch (IllegalArgumentException iare) {
                        errorMessage = iare.getMessage();
                        return null;
                    }
                    catch (IllegalAccessException iae) {
                        browser = null;
                        errorMessage = iae.getMessage();
                        return browser;
                    }
                    catch (InvocationTargetException ite) {
                        browser = null;
                        errorMessage = ite.getTargetException().getClass() + ": " + ite.getTargetException().getMessage();
                        return browser;
                    }
                }
                browser = null;
                break;
            }
            case 3: 
            case 4: {
                browser = "";
                break;
            }
            case 5: {
                browser = "cmd.exe";
                break;
            }
            case 6: {
                browser = "command.com";
                break;
            }
            default: {
                browser = "netscape";
            }
        }
        return browser;
    }

    public static void openURL(String url) throws IOException {
        if (!loadedWithoutErrors) {
            throw new IOException("Exception in finding browser: " + errorMessage);
        }
        Object browser = BrowserLauncher.locateBrowser();
        if (browser == null) {
            throw new IOException("Unable to locate browser: " + errorMessage);
        }
        switch (jvm) {
            case 0: {
                Object aeDesc = null;
                try {
                    aeDesc = aeDescConstructor.newInstance(url);
                    putParameter.invoke(browser, keyDirectObject, aeDesc);
                    sendNoReply.invoke(browser, new Object[0]);
                    break;
                }
                catch (InvocationTargetException ite) {
                    throw new IOException("InvocationTargetException while creating AEDesc: " + ite.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new IOException("IllegalAccessException while building AppleEvent: " + iae.getMessage());
                }
                catch (InstantiationException ie) {
                    throw new IOException("InstantiationException while creating AEDesc: " + ie.getMessage());
                }
                finally {
                    aeDesc = null;
                    browser = null;
                }
            }
            case 1: {
                Runtime.getRuntime().exec(new String[]{(String)browser, url});
                break;
            }
            case 3: {
                int[] instance = new int[1];
                int result = BrowserLauncher.ICStart(instance, 0);
                if (result == 0) {
                    int[] selectionStart = new int[]{0};
                    byte[] urlBytes = url.getBytes();
                    int[] selectionEnd = new int[]{urlBytes.length};
                    result = BrowserLauncher.ICLaunchURL(instance[0], new byte[]{0}, urlBytes, urlBytes.length, selectionStart, selectionEnd);
                    if (result == 0) {
                        BrowserLauncher.ICStop(instance);
                        break;
                    }
                    throw new IOException("Unable to launch URL: " + result);
                }
                throw new IOException("Unable to create an Internet Config instance: " + result);
            }
            case 4: {
                try {
                    openURL.invoke(null, url);
                    break;
                }
                catch (InvocationTargetException ite) {
                    throw new IOException("InvocationTargetException while calling openURL: " + ite.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new IOException("IllegalAccessException while calling openURL: " + iae.getMessage());
                }
            }
            case 5: 
            case 6: {
                Process process = Runtime.getRuntime().exec(new String[]{(String)browser, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, '\"' + url + '\"'});
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            case -1: {
                Process process = Runtime.getRuntime().exec(new String[]{(String)browser, NETSCAPE_REMOTE_PARAMETER, NETSCAPE_OPEN_PARAMETER_START + url + NETSCAPE_OPEN_PARAMETER_END});
                try {
                    int exitCode = process.waitFor();
                    if (exitCode == 0) break;
                    Runtime.getRuntime().exec(new String[]{(String)browser, url});
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            default: {
                Runtime.getRuntime().exec(new String[]{(String)browser, url});
            }
        }
    }

    public static native int ICStart(int[] var0, int var1);

    public static native int ICStop(int[] var0);

    public static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);

    static {
        block9: {
            loadedWithoutErrors = true;
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                String mrjVersion = System.getProperty("mrj.version");
                String majorMRJVersion = mrjVersion.substring(0, 3);
                try {
                    double version = Double.valueOf(majorMRJVersion);
                    if (version == 2.0) {
                        jvm = 0;
                        break block9;
                    }
                    if (version >= 2.1 && version < 3.0) {
                        jvm = 1;
                        break block9;
                    }
                    if (version == 3.0) {
                        jvm = 3;
                        break block9;
                    }
                    if (version >= 3.1) {
                        jvm = 4;
                        break block9;
                    }
                    loadedWithoutErrors = false;
                    errorMessage = "Unsupported MRJ version: " + version;
                }
                catch (NumberFormatException nfe) {
                    loadedWithoutErrors = false;
                    errorMessage = "Invalid MRJ version: " + mrjVersion;
                }
            } else {
                jvm = osName.startsWith("Windows") ? (osName.indexOf("9") != -1 ? 6 : 5) : -1;
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }
}

